/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.buildtools.ant.taskdefs;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.persistence.buildtools.helper.Version;
import org.eclipse.persistence.buildtools.helper.VersionException;

public class SelectBundle
extends Task {
    private boolean includepath = false;
    private boolean versiononly = false;
    private String criterion = "";
    private String basename = "";
    private String directory = "";
    private String property = "";
    private String separator = "_";
    private String suffix = "jar";
    private boolean minInclusive = false;
    private boolean maxInclusive = false;
    private Version minVersion = null;
    private Version maxVersion = null;
    private Version bestVersion = null;
    private Version version = null;

    private void evaluateCriteria() throws BuildException {
        if (this.criterion != null && this.criterion.length() != 0) {
            int endIndex = this.criterion.length() - 1;
            boolean minSquareBracket = this.criterion.startsWith("[");
            boolean maxSquareBracket = this.criterion.endsWith("]");
            boolean minRoundBracket = this.criterion.startsWith("(");
            boolean maxRoundBracket = this.criterion.endsWith(")");
            boolean initInt = this.criterion.substring(0, 1).contains("0123456789");
            boolean endInt = this.criterion.substring(endIndex - 1, endIndex).contains("0123456789");
            boolean commapresent = this.criterion.contains(",");
            if (!(minSquareBracket || minRoundBracket || initInt)) {
                throw new BuildException("The criterion attribute must begin with (,[, or a number.", this.getLocation());
            }
            if (!(maxSquareBracket || maxRoundBracket || endInt)) {
                throw new BuildException("The criterion attribute must end with ),], or a number.", this.getLocation());
            }
            if (initInt && !endInt || !initInt && endInt || !initInt && !commapresent || initInt && commapresent) {
                throw new BuildException("The criterion attribute must be a valid OSGi version range string", this.getLocation());
            }
            if (commapresent && this.criterion.substring(this.criterion.indexOf(44) + 1, endIndex).contains(",")) {
                throw new BuildException("The criterion attribute must be a valid OSGi version range string: multiple comma(,) detected.", this.getLocation());
            }
            this.minInclusive = minSquareBracket || initInt;
            boolean bl = this.maxInclusive = maxSquareBracket || endInt;
            if (initInt) {
                this.log("evaluateCriteria: Singleton detected", 3);
                this.minVersion = new Version(this.criterion);
                this.maxVersion = new Version("99999.99999.99999.\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff");
            }
            if (!initInt) {
                this.log("evaluateCriteria: Range(min:" + this.criterion.substring(1, this.criterion.indexOf(44)) + ")", 3);
                this.minVersion = new Version(this.criterion.substring(1, this.criterion.indexOf(44)));
            }
            if (!endInt) {
                this.log("evaluateCriteria: Range(max:" + this.criterion.substring(this.criterion.indexOf(44) + 1, endIndex) + ")", 3);
                this.maxVersion = new Version(this.criterion.substring(this.criterion.indexOf(44) + 1, endIndex));
            }
        } else {
            this.minInclusive = true;
            this.minVersion = new Version();
            this.maxVersion = new Version("99999.99999.99999.\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff");
        }
        if (this.minInclusive) {
            this.log("evaluateCriteria: minInclusive(true)", 3);
        } else {
            this.log("evaluateCriteria: minInclusive(false)", 3);
        }
        if (this.maxInclusive) {
            this.log("evaluateCriteria: maxInclusive(true)", 3);
        } else {
            this.log("evaluateCriteria: maxInclusive(false)", 3);
        }
        this.log("evaluateCriteria: minVersion(" + this.minVersion.getIdentifier() + ")", 3);
        this.log("evaluateCriteria: maxVersion(" + this.maxVersion.getIdentifier() + ")", 3);
    }

    private String matchCriteria() {
        String bestMatch = null;
        String[] filelist = this.getListOfFiles(this.directory);
        this.bestVersion = this.minVersion;
        this.log("matchCriteria: bestVersion.getIdentifier='" + this.bestVersion.getIdentifier() + "'", 3);
        this.log("matchCriteria: basename.length='" + Integer.toString(this.basename.length()) + "'", 3);
        this.log("matchCriteria: separator.length='" + Integer.toString(this.separator.length()) + "'", 3);
        int relativeVersionIndex = this.basename.length() + this.separator.length();
        this.log("matchCriteria: relativeVersionIndex='" + Integer.toString(relativeVersionIndex) + "' (Should be '" + Integer.toString(this.basename.length() + this.separator.length()) + "')", 3);
        if (filelist != null) {
            this.log("matchCriteria: filelist.length='" + Integer.toString(filelist.length) + "'", 3);
            for (int i = 0; i < filelist.length; ++i) {
                int versionEndIndex = filelist[i].indexOf("." + this.suffix);
                this.log("matchCriteria: versionEndIndex(" + Integer.toString(versionEndIndex) + ")", 3);
                this.log("matchCriteria: filelist[" + Integer.toString(i) + "](" + filelist[i] + ")", 3);
                try {
                    this.version = new Version(filelist[i].substring(relativeVersionIndex, versionEndIndex));
                }
                catch (VersionException e) {
                    this.log("matchCriteria: Exception detected -> " + e, 3);
                }
                this.log("matchCriteria: version string of found file(" + this.version.getIdentifier() + ")", 3);
                if (this.version.empty()) continue;
                if (this.minInclusive && this.maxInclusive) {
                    this.log("matchCriteria: Test:  " + this.minVersion.getIdentifier() + " <= " + this.version.getIdentifier() + " <= " + this.maxVersion.getIdentifier(), 3);
                    if (this.minVersion.le(this.version) && this.maxVersion.ge(this.version)) {
                        this.log("matchCriteria:      Pass", 3);
                        if (this.bestVersion.lt(this.version)) {
                            this.log("matchCriteria: " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                            bestMatch = filelist[i];
                            this.bestVersion = this.version;
                        } else {
                            this.log("matchCriteria: ! " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                        }
                    }
                } else if (this.minInclusive && !this.maxInclusive) {
                    this.log("matchCriteria: Test:  " + this.minVersion.getIdentifier() + " <= " + this.version.getIdentifier() + " < " + this.maxVersion.getIdentifier(), 3);
                    this.log("matchCriteria:   Result:  " + Boolean.toString(this.minVersion.le(this.version)) + " && " + Boolean.toString(this.maxVersion.gt(this.version)), 3);
                    if (this.minVersion.le(this.version) && this.maxVersion.gt(this.version)) {
                        this.log("matchCriteria:      Pass", 3);
                        if (this.bestVersion.lt(this.version)) {
                            this.log("matchCriteria: " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                            bestMatch = filelist[i];
                            this.bestVersion = this.version;
                        } else {
                            this.log("matchCriteria: ! " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                        }
                    }
                } else if (!this.minInclusive && this.maxInclusive) {
                    this.log("matchCriteria: Test:  " + this.minVersion.getIdentifier() + " < " + this.version.getIdentifier() + " <= " + this.maxVersion.getIdentifier(), 3);
                    if (this.minVersion.lt(this.version) && this.maxVersion.ge(this.version)) {
                        this.log("matchCriteria:      Pass", 3);
                        if (this.bestVersion.lt(this.version)) {
                            this.log("matchCriteria: " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                            bestMatch = filelist[i];
                            this.bestVersion = this.version;
                        } else {
                            this.log("matchCriteria: ! " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                        }
                    }
                } else if (!this.minInclusive && !this.maxInclusive) {
                    this.log("matchCriteria: Test:  " + this.minVersion.getIdentifier() + " < " + this.version.getIdentifier() + " < " + this.maxVersion.getIdentifier(), 3);
                    if (this.minVersion.lt(this.version) && this.maxVersion.gt(this.version)) {
                        this.log("matchCriteria:      Pass", 3);
                        if (this.bestVersion.lt(this.version)) {
                            this.log("matchCriteria: " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                            bestMatch = filelist[i];
                            this.bestVersion = this.version;
                        } else {
                            this.log("matchCriteria: ! " + this.bestVersion.getIdentifier() + " < " + this.version.getIdentifier(), 3);
                        }
                    }
                }
                this.log("matchCriteria: Best Match so far(" + bestMatch + ")", 3);
            }
            this.log("matchCriteria: BestMatch(" + bestMatch + ")", 3);
        } else {
            this.log("matchCriteria: filelist is null!", 3);
        }
        return bestMatch;
    }

    private String[] getListOfFiles(String directory) {
        class MyFilter
        implements FilenameFilter {
            MyFilter() {
            }

            @Override
            public boolean accept(File directory, String filepattern) {
                return filepattern.startsWith(SelectBundle.this.basename + SelectBundle.this.separator) && filepattern.endsWith("." + SelectBundle.this.suffix);
            }
        }
        return new File(directory).list(new MyFilter());
    }

    public void execute() throws BuildException {
        if (this.getProject() == null) {
            throw new IllegalStateException("Project not set!");
        }
        if (this.basename == null || this.basename.length() == 0) {
            throw new BuildException("The basename attribute must be present.", this.getLocation());
        }
        if (this.directory == null || this.directory.length() == 0) {
            throw new BuildException("The directory attribute must be present.", this.getLocation());
        }
        if (this.property == null || this.property.length() == 0) {
            throw new BuildException("The property attribute must be present.", this.getLocation());
        }
        this.log("execute: ** Evaluate **", 3);
        this.evaluateCriteria();
        this.log("execute: ** Match **", 3);
        String file = this.matchCriteria();
        if (file != null) {
            if (this.includepath) {
                this.getProject().setNewProperty(this.property, this.directory + "/" + file);
            } else if (this.versiononly) {
                this.getProject().setNewProperty(this.property, this.bestVersion.getIdentifier());
            } else {
                this.getProject().setNewProperty(this.property, file);
            }
        }
        this.log("execute: Search Finished.", 3);
    }

    public void setIncludepath(boolean includepath) {
        this.includepath = includepath;
    }

    public void setVersionOnly(boolean versiononly) {
        this.versiononly = versiononly;
    }

    public void setCriterion(String criterion) {
        this.criterion = criterion;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
        this.log("setDirectory: directory='" + directory + "'", 3);
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSeparator(String separator) {
        if (separator.length() > 1 || separator.length() == 0) {
            throw new BuildException("The separator attribute can only be a single character.", this.getLocation());
        }
        this.separator = separator;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

