/*
 * Copyright (c) 1998, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.tests.proxyindirection;

import java.util.*;

/**
 * TopLink generated Project class.
 * <b>WARNING</b>: This code was generated by an automated tool.
 * Any changes will be lost when the code is re-generated
 */
public class ProxyIndirectionProject extends org.eclipse.persistence.sessions.Project {

    /**
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    public ProxyIndirectionProject() {
        applyPROJECT();
        applyLOGIN();
        buildAddressDescriptor();
        buildAddressImplDescriptor();
        buildContactDescriptor();
        buildCubicleDescriptor();
        buildCubicleImplDescriptor();
        buildEmailImplDescriptor();
        buildEmployeeDescriptor();
        buildEmployeeImplDescriptor();
        buildLargeProjectDescriptor();
        buildLargeProjectImplDescriptor();
        buildPhoneImplDescriptor();
        buildProjectDescriptor();
        buildProjectImplDescriptor();
        buildComputerDescriptor();
        buildComputerImplDescriptor();
        buildDesktopComputerDescriptor();
        buildDesktopComputerImplDescriptor();
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyLOGIN() {
        org.eclipse.persistence.sessions.DatabaseLogin login = new org.eclipse.persistence.sessions.DatabaseLogin();

        login.setUserName("BLAH");
        login.setDriverClassName("sun.jdbc.odbc.JdbcOdbcDriver");
        login.setConnectionString("jdbc:odbc:MSACCESS");
        login.setPlatformClassName("org.eclipse.persistence.platform.database.AccessPlatform");
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void applyPROJECT() {
        setName("Proxy");
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildAddressDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Address.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Address.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildAddressImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(AddressImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_ADDRESS");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_ADDRESS.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("ADDRESS");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Address.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("city");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getCity");
        directtofieldmapping.setSetMethodName("setCity");
        directtofieldmapping.setFieldName("PROXY_ADDRESS.CITY");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("country");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getCountry");
        directtofieldmapping1.setSetMethodName("setCountry");
        directtofieldmapping1.setFieldName("PROXY_ADDRESS.COUNTRY");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getID");
        directtofieldmapping2.setSetMethodName("setID");
        directtofieldmapping2.setFieldName("PROXY_ADDRESS.ID");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("postalCode");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getPostalCode");
        directtofieldmapping3.setSetMethodName("setPostalCode");
        directtofieldmapping3.setFieldName("PROXY_ADDRESS.POSTAL_CODE");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping4 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("state");
        directtofieldmapping4.setIsReadOnly(false);
        directtofieldmapping4.setGetMethodName("getState");
        directtofieldmapping4.setSetMethodName("setState");
        directtofieldmapping4.setFieldName("PROXY_ADDRESS.STATE");
        descriptor.addMapping(directtofieldmapping4);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping5 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping5.setAttributeName("street");
        directtofieldmapping5.setIsReadOnly(false);
        directtofieldmapping5.setGetMethodName("getStreet");
        directtofieldmapping5.setSetMethodName("setStreet");
        directtofieldmapping5.setFieldName("PROXY_ADDRESS.STREET");
        descriptor.addMapping(directtofieldmapping5);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildContactDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Contact.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Contact.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildComputerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Computer.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Computer.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildComputerImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ComputerImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_COMPUTER");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_COMPUTER.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("PROXY_COMP");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(DesktopComputerImpl.class, "D");
        descriptor.getInheritancePolicy().addClassIndicator(ComputerImpl.class, "C");
        descriptor.getInterfacePolicy().addParentInterface(Computer.class);


        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getId");
        directtofieldmapping2.setSetMethodName("setId");
        directtofieldmapping2.setFieldName("PROXY_COMPUTER.ID");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getDescription");
        directtofieldmapping.setSetMethodName("setDescription");
        directtofieldmapping.setFieldName("PROXY_COMPUTER.DESCRIP");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("serialNumber");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getSerialNumber");
        directtofieldmapping1.setSetMethodName("setSerialNumber");
        directtofieldmapping1.setFieldName("PROXY_COMPUTER.SERL_NO");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildCubicleDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Cubicle.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Cubicle.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildCubicleImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(CubicleImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_CUBICLE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_CUBICLE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("CUBICLE");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Cubicle.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("_length");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getLength");
        directtofieldmapping.setSetMethodName("setLength");
        directtofieldmapping.setFieldName("PROXY_CUBICLE.CUB_LENGTH");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("height");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getHeight");
        directtofieldmapping1.setSetMethodName("setHeight");
        directtofieldmapping1.setFieldName("PROXY_CUBICLE.HEIGHT");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getID");
        directtofieldmapping2.setSetMethodName("setID");
        directtofieldmapping2.setFieldName("PROXY_CUBICLE.ID");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("width");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getWidth");
        directtofieldmapping3.setSetMethodName("setWidth");
        directtofieldmapping3.setFieldName("PROXY_CUBICLE.WIDTH");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setGetMethodName("getEmployee");
        onetoonemapping.setSetMethodName("setEmployee");
        onetoonemapping.setReferenceClass(EmployeeImpl.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addTargetForeignKeyFieldName("PROXY_EMPLOYEE.CUBICLE_ID", "PROXY_CUBICLE.ID");
        onetoonemapping.useProxyIndirection();
        descriptor.addMapping(onetoonemapping);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping2 = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping2.setAttributeName("computer");
        onetoonemapping2.setIsReadOnly(false);
        onetoonemapping2.setUsesIndirection(false);
        onetoonemapping2.setGetMethodName("getComputer");
        onetoonemapping2.setSetMethodName("setComputer");
        onetoonemapping2.setReferenceClass(DesktopComputerImpl.class);
        onetoonemapping2.setIsPrivateOwned(false);
        onetoonemapping2.addForeignKeyFieldName("PROXY_CUBICLE.COMP_ID", "PROXY_DESKTOP.ID");
        onetoonemapping2.useProxyIndirection();
        descriptor.addMapping(onetoonemapping2);

        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildDesktopComputerDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DesktopComputer.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(DesktopComputer.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildDesktopComputerImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(DesktopComputerImpl.class);
        descriptor.getInheritancePolicy().setParentClass(ComputerImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_DESKTOP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_DESKTOP.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInterfacePolicy().addParentInterface(DesktopComputer.class);
        descriptor.getInterfacePolicy().addParentInterface(Computer.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("moniterSize");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getMoniterSize");
        directtofieldmapping.setSetMethodName("setMoniterSize");
        directtofieldmapping.setFieldName("PROXY_DESKTOP.MONITOR_SIZE");
        descriptor.addMapping(directtofieldmapping);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildEmailImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EmailImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_EMAIL");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_EMAIL.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("CONTACT");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Contact.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("domain");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getDomain");
        directtofieldmapping.setSetMethodName("setDomain");
        directtofieldmapping.setFieldName("PROXY_EMAIL.EMAIL_DOMAIN");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getID");
        directtofieldmapping1.setSetMethodName("setID");
        directtofieldmapping1.setFieldName("PROXY_EMAIL.ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("isPublic");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("isPublic");
        directtofieldmapping2.setSetMethodName("setIsPublic");
        directtofieldmapping2.setFieldName("PROXY_EMAIL.IS_PUBLIC");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("username");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getUsername");
        directtofieldmapping3.setSetMethodName("setUsername");
        directtofieldmapping3.setFieldName("PROXY_EMAIL.USERNAME");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping4 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("wantsHTMLMail");
        directtofieldmapping4.setIsReadOnly(false);
        directtofieldmapping4.setGetMethodName("wantsHTMLMail");
        directtofieldmapping4.setSetMethodName("setWantsHTMLMail");
        directtofieldmapping4.setFieldName("PROXY_EMAIL.WANTS_HTML");
        descriptor.addMapping(directtofieldmapping4);

        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildEmployeeDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Employee.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Employee.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildEmployeeImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(EmployeeImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_EMPLOYEE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_EMPLOYEE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("EMPLOYEE");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Employee.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("age");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getAge");
        directtofieldmapping.setSetMethodName("setAge");
        directtofieldmapping.setFieldName("PROXY_EMPLOYEE.AGE");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("cubicleID");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getCubicleID");
        directtofieldmapping1.setSetMethodName("setCubicleID");
        directtofieldmapping1.setFieldName("PROXY_EMPLOYEE.CUBICLE_ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("firstName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getFirstName");
        directtofieldmapping2.setSetMethodName("setFirstName");
        directtofieldmapping2.setFieldName("PROXY_EMPLOYEE.FIRST_NAME");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("gender");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getGender");
        directtofieldmapping3.setSetMethodName("setGender");
        directtofieldmapping3.setFieldName("PROXY_EMPLOYEE.GENDER");
        descriptor.addMapping(directtofieldmapping3);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping4 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("id");
        directtofieldmapping4.setIsReadOnly(false);
        directtofieldmapping4.setGetMethodName("getID");
        directtofieldmapping4.setSetMethodName("setID");
        directtofieldmapping4.setFieldName("PROXY_EMPLOYEE.ID");
        descriptor.addMapping(directtofieldmapping4);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping5 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping5.setAttributeName("lastName");
        directtofieldmapping5.setIsReadOnly(false);
        directtofieldmapping5.setGetMethodName("getLastName");
        directtofieldmapping5.setSetMethodName("setLastName");
        directtofieldmapping5.setFieldName("PROXY_EMPLOYEE.LAST_NAME");
        descriptor.addMapping(directtofieldmapping5);

        // SECTION: ONETOMANYMAPPING
        org.eclipse.persistence.mappings.OneToManyMapping onetomanymapping = new org.eclipse.persistence.mappings.OneToManyMapping();
        onetomanymapping.setAttributeName("managedEmployees");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setGetMethodName("getManagedEmployees");
        onetomanymapping.setSetMethodName("setManagedEmployees");
        onetomanymapping.setReferenceClass(EmployeeImpl.class);
        onetomanymapping.setIsPrivateOwned(false);
        onetomanymapping.useCollectionClass(java.util.Vector.class);
        onetomanymapping.addTargetForeignKeyFieldName("PROXY_EMPLOYEE.MANAGER_ID", "PROXY_EMPLOYEE.ID");
        onetomanymapping.useTransparentCollection();
        descriptor.addMapping(onetomanymapping);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setGetMethodName("getAddress");
        onetoonemapping.setSetMethodName("setAddress");
        onetoonemapping.setReferenceClass(AddressImpl.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("PROXY_EMPLOYEE.ADD_ID", "PROXY_ADDRESS.ID");
        onetoonemapping.useProxyIndirection();
        descriptor.addMapping(onetoonemapping);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping1 = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping1.setAttributeName("manager");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(false);
        onetoonemapping1.setGetMethodName("getManager");
        onetoonemapping1.setSetMethodName("setManager");
        onetoonemapping1.setReferenceClass(EmployeeImpl.class);
        onetoonemapping1.setIsPrivateOwned(false);
        onetoonemapping1.addForeignKeyFieldName("PROXY_EMPLOYEE.MANAGER_ID", "PROXY_EMPLOYEE.ID");
        onetoonemapping1.useProxyIndirection();
        descriptor.addMapping(onetoonemapping1);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.VariableOneToOneMapping variableonetoonemapping1 = new org.eclipse.persistence.mappings.VariableOneToOneMapping();
        variableonetoonemapping1.setAttributeName("contact");
        variableonetoonemapping1.setIsReadOnly(false);
        variableonetoonemapping1.setUsesIndirection(false);
        variableonetoonemapping1.setGetMethodName("getContact");
        variableonetoonemapping1.setSetMethodName("setContact");
        variableonetoonemapping1.setReferenceClass(Contact.class);
        variableonetoonemapping1.setIsPrivateOwned(false);
        variableonetoonemapping1.addForeignQueryKeyName("PROXY_EMPLOYEE.CONTACT_ID", "id");
        variableonetoonemapping1.useProxyIndirection(Contact.class);
        descriptor.addMapping(variableonetoonemapping1);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping2 = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping2.setAttributeName("project");
        onetoonemapping2.setIsReadOnly(false);
        onetoonemapping2.setUsesIndirection(false);
        onetoonemapping2.setGetMethodName("getProject");
        onetoonemapping2.setSetMethodName("setProject");
        onetoonemapping2.setReferenceClass(ProjectImpl.class);
        onetoonemapping2.setIsPrivateOwned(false);
        onetoonemapping2.addForeignKeyFieldName("PROXY_EMPLOYEE.PROJ_ID", "PROXY_PROJECT.ID");
        onetoonemapping2.useProxyIndirection();
        descriptor.addMapping(onetoonemapping2);

        // SECTION: ONETOONEMAPPING
        org.eclipse.persistence.mappings.OneToOneMapping onetoonemapping3 = new org.eclipse.persistence.mappings.OneToOneMapping();
        onetoonemapping3.setAttributeName("largeProject");
        onetoonemapping3.setIsReadOnly(false);
        onetoonemapping3.setUsesIndirection(false);
        onetoonemapping3.setGetMethodName("getLargeProject");
        onetoonemapping3.setSetMethodName("setLargeProject");
        onetoonemapping3.setReferenceClass(LargeProjectImpl.class);
        onetoonemapping3.setIsPrivateOwned(false);
        onetoonemapping3.addForeignKeyFieldName("PROXY_EMPLOYEE.LPROJ_ID", "PROXY_LPROJECT.ID");
        onetoonemapping3.useProxyIndirection();
        descriptor.addMapping(onetoonemapping3);

        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildLargeProjectDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(LargeProject.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(LargeProject.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildLargeProjectImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(LargeProjectImpl.class);
        descriptor.getInheritancePolicy().setParentClass(ProjectImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_LPROJECT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_LPROJECT.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInterfacePolicy().addParentInterface(LargeProject.class);
        descriptor.getInterfacePolicy().addParentInterface(Project.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("budget");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getBudget");
        directtofieldmapping.setSetMethodName("setBudget");
        directtofieldmapping.setFieldName("PROXY_LPROJECT.BUDGET");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("investor");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getInvestor");
        directtofieldmapping1.setSetMethodName("setInvestor");
        directtofieldmapping1.setFieldName("PROXY_LPROJECT.INVESTOR");
        descriptor.addMapping(directtofieldmapping1);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildPhoneImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(PhoneImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_PHONE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_PHONE.ID");

        // SECTION: PROPERTIES
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberName("CONTACT");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInterfacePolicy().addParentInterface(Contact.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getID");
        directtofieldmapping.setSetMethodName("setID");
        directtofieldmapping.setFieldName("PROXY_PHONE.ID");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("isPublic");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("isPublic");
        directtofieldmapping1.setSetMethodName("setIsPublic");
        directtofieldmapping1.setFieldName("PROXY_PHONE.IS_PUBLIC");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("number");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getNumber");
        directtofieldmapping2.setSetMethodName("setNumber");
        directtofieldmapping2.setFieldName("PROXY_PHONE.PH_NUMBER");
        descriptor.addMapping(directtofieldmapping2);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping3 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("type");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setGetMethodName("getType");
        directtofieldmapping3.setSetMethodName("setType");
        directtofieldmapping3.setFieldName("PROXY_PHONE.PH_TYPE");
        descriptor.addMapping(directtofieldmapping3);

        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildProjectDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(Project.class);

        // SECTION: PROPERTIES
        descriptor.addAbstractQueryKey("id");
        descriptor.setJavaInterface(Project.class);
        addDescriptor(descriptor);
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    protected void buildProjectImplDescriptor() {
        org.eclipse.persistence.descriptors.RelationalDescriptor descriptor = new org.eclipse.persistence.descriptors.RelationalDescriptor();

        // SECTION: DESCRIPTOR
        descriptor.setJavaClass(ProjectImpl.class);
        Vector vector = new Vector();
        vector.addElement("PROXY_PROJECT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROXY_PROJECT.ID");

        // SECTION: PROPERTIES
        descriptor.setSequenceNumberName("PROJECT");
        descriptor.setIdentityMapClass(org.eclipse.persistence.internal.identitymaps.FullIdentityMap.class);
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(LargeProjectImpl.class, "L");
        descriptor.getInheritancePolicy().addClassIndicator(ProjectImpl.class, "P");
        descriptor.getInterfacePolicy().addParentInterface(Project.class);

        // SECTION: COPY POLICY
        descriptor.createCopyPolicy("constructor");

        // SECTION: INSTANTIATION POLICY
        descriptor.createInstantiationPolicy("constructor");

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getDescription");
        directtofieldmapping.setSetMethodName("setDescription");
        directtofieldmapping.setFieldName("PROXY_PROJECT.DESCRIP");
        descriptor.addMapping(directtofieldmapping);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping1 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getID");
        directtofieldmapping1.setSetMethodName("setID");
        directtofieldmapping1.setFieldName("PROXY_PROJECT.ID");
        descriptor.addMapping(directtofieldmapping1);

        // SECTION: DIRECTTOFIELDMAPPING
        org.eclipse.persistence.mappings.DirectToFieldMapping directtofieldmapping2 = new org.eclipse.persistence.mappings.DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("name");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getName");
        directtofieldmapping2.setSetMethodName("setName");
        directtofieldmapping2.setFieldName("PROXY_PROJECT.NAME");
        descriptor.addMapping(directtofieldmapping2);
        addDescriptor(descriptor);
    }
}
