/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new AssertionError();
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EmptySortedSet.INSTANCE;
    }

    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return EmptySortedMap.INSTANCE;
    }

    private static class EmptySortedMap<K, V>
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final SortedMap<?, ?> INSTANCE = new EmptySortedMap();

        private EmptySortedMap() {
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return CollectionUtils.emptySortedMap();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return CollectionUtils.emptySortedMap();
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return CollectionUtils.emptySortedMap();
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static class EmptySortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        static final SortedSet<?> INSTANCE = new EmptySortedSet();
        private static Iterator<?> ITER = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };

        private EmptySortedSet() {
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return CollectionUtils.emptySortedSet();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return CollectionUtils.emptySortedSet();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return CollectionUtils.emptySortedSet();
        }

        @Override
        public E first() {
            throw new NoSuchElementException();
        }

        @Override
        public E last() {
            throw new NoSuchElementException();
        }

        @Override
        public Iterator<E> iterator() {
            return ITER;
        }

        @Override
        public int size() {
            return 0;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

