/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Depth;
import oracle.kv.Direction;
import oracle.kv.Key;
import oracle.kv.KeyRange;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class KVInputSplit
extends InputSplit
implements Writable {
    private String kvStore;
    private String[] kvHelperHosts;
    private Direction direction;
    private int batchSize;
    private Key parentKey;
    private KeyRange subRange;
    private Depth depth;
    private Consistency consistency;
    private long timeout;
    private TimeUnit timeoutUnit;
    private String[] locations = new String[0];
    private String formatterClassName;
    private String kvStoreSecurityFile;
    private int kvPart;
    private List<Set<Integer>> partitionSets;

    public long getLength() throws IOException, InterruptedException {
        return 1L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return this.locations;
    }

    KVInputSplit setLocations(String[] locations) {
        this.locations = locations;
        return this;
    }

    KVInputSplit setDirection(Direction direction) {
        this.direction = direction;
        return this;
    }

    Direction getDirection() {
        return this.direction;
    }

    KVInputSplit setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    KVInputSplit setParentKey(Key parentKey) {
        this.parentKey = parentKey;
        return this;
    }

    Key getParentKey() {
        return this.parentKey;
    }

    KVInputSplit setSubRange(KeyRange subRange) {
        this.subRange = subRange;
        return this;
    }

    KeyRange getSubRange() {
        return this.subRange;
    }

    KVInputSplit setDepth(Depth depth) {
        this.depth = depth;
        return this;
    }

    Depth getDepth() {
        return this.depth;
    }

    KVInputSplit setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    Consistency getConsistency() {
        return this.consistency;
    }

    KVInputSplit setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    long getTimeout() {
        return this.timeout;
    }

    KVInputSplit setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    KVInputSplit setKVHelperHosts(String[] kvHelperHosts) {
        this.kvHelperHosts = kvHelperHosts;
        return this;
    }

    public String[] getKVHelperHosts() {
        return this.kvHelperHosts;
    }

    KVInputSplit setKVStoreName(String kvStore) {
        this.kvStore = kvStore;
        return this;
    }

    public String getKVStoreName() {
        return this.kvStore;
    }

    KVInputSplit setKVPart(int kvPart) {
        this.kvPart = kvPart;
        return this;
    }

    int getKVPart() {
        return this.kvPart;
    }

    KVInputSplit setPartitionSets(List<Set<Integer>> partitionSets) {
        assert (this.kvPart == 0);
        this.partitionSets = partitionSets;
        return this;
    }

    List<Set<Integer>> getPartitionSets() {
        return this.partitionSets;
    }

    KVInputSplit setFormatterClassName(String formatterClassName) {
        this.formatterClassName = formatterClassName;
        return this;
    }

    String getFormatterClassName() {
        return this.formatterClassName;
    }

    KVInputSplit setKVStoreSecurityFile(String securityFile) {
        this.kvStoreSecurityFile = securityFile;
        return this;
    }

    String getKVStoreSecurityFile() {
        return this.kvStoreSecurityFile;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        out.writeInt(this.kvHelperHosts.length);
        for (i = 0; i < this.kvHelperHosts.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.kvHelperHosts[i]);
        }
        Text.writeString((DataOutput)out, (String)this.kvStore);
        Text.writeString((DataOutput)out, (String)("" + this.kvPart));
        if (this.kvPart == 0) {
            assert (this.partitionSets != null);
            out.writeInt(this.partitionSets.size());
            for (Set<Integer> partitions : this.partitionSets) {
                out.writeInt(partitions.size());
                for (Integer p : partitions) {
                    out.writeInt(p);
                }
            }
        }
        Text.writeString((DataOutput)out, (String)(this.direction == null ? "" : this.direction.name()));
        out.writeInt(this.batchSize);
        this.writeBytes(out, this.parentKey == null ? null : this.parentKey.toByteArray());
        this.writeBytes(out, this.subRange == null ? null : this.subRange.toByteArray());
        Text.writeString((DataOutput)out, (String)(this.depth == null ? "" : this.depth.name()));
        this.writeBytes(out, this.consistency == null ? null : this.consistency.toByteArray());
        out.writeLong(this.timeout);
        Text.writeString((DataOutput)out, (String)(this.timeoutUnit == null ? "" : this.timeoutUnit.name()));
        out.writeInt(this.locations.length);
        for (i = 0; i < this.locations.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.locations[i]);
        }
        Text.writeString((DataOutput)out, (String)(this.formatterClassName == null ? "" : this.formatterClassName));
        Text.writeString((DataOutput)out, (String)(this.kvStoreSecurityFile == null ? "" : this.kvStoreSecurityFile));
    }

    public void readFields(DataInput in) throws IOException {
        String dirStr;
        int nSets;
        int nHelperHosts = in.readInt();
        this.kvHelperHosts = new String[nHelperHosts];
        for (int i = 0; i < nHelperHosts; ++i) {
            this.kvHelperHosts[i] = Text.readString((DataInput)in);
        }
        this.kvStore = Text.readString((DataInput)in);
        this.kvPart = Integer.parseInt(Text.readString((DataInput)in));
        this.partitionSets = null;
        if (this.kvPart == 0 && (nSets = in.readInt()) > 0) {
            this.partitionSets = new ArrayList<Set<Integer>>(nSets);
            while (nSets > 0) {
                int nPartitions;
                HashSet<Integer> partitions = new HashSet<Integer>(nPartitions);
                this.partitionSets.add(partitions);
                for (nPartitions = in.readInt(); nPartitions > 0; --nPartitions) {
                    partitions.add(in.readInt());
                }
                --nSets;
            }
        }
        this.direction = (dirStr = Text.readString((DataInput)in)) == null || dirStr.equals("") ? Direction.FORWARD : Direction.valueOf(dirStr);
        this.batchSize = in.readInt();
        byte[] pkBytes = this.readBytes(in);
        this.parentKey = pkBytes == null ? null : Key.fromByteArray(pkBytes);
        byte[] srBytes = this.readBytes(in);
        this.subRange = srBytes == null ? null : KeyRange.fromByteArray(srBytes);
        String depthStr = Text.readString((DataInput)in);
        this.depth = depthStr == null || depthStr.equals("") ? Depth.PARENT_AND_DESCENDANTS : Depth.valueOf(depthStr);
        byte[] consBytes = this.readBytes(in);
        this.consistency = consBytes == null ? null : Consistency.fromByteArray(consBytes);
        this.timeout = in.readLong();
        String tuStr = Text.readString((DataInput)in);
        this.timeoutUnit = tuStr == null || tuStr.equals("") ? null : TimeUnit.valueOf(tuStr);
        int len = in.readInt();
        this.locations = new String[len];
        for (int i = 0; i < len; ++i) {
            this.locations[i] = Text.readString((DataInput)in);
        }
        this.formatterClassName = Text.readString((DataInput)in);
        if (this.formatterClassName == null || this.formatterClassName.equals("")) {
            this.formatterClassName = null;
        }
        this.kvStoreSecurityFile = Text.readString((DataInput)in);
        if (this.kvStoreSecurityFile == null || this.kvStoreSecurityFile.equals("")) {
            this.kvStoreSecurityFile = null;
        }
    }

    private void writeBytes(DataOutput out, byte[] bytes) throws IOException {
        if (bytes == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private byte[] readBytes(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        in.readFully(ret);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KVInputSplit)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        KVInputSplit other = (KVInputSplit)((Object)obj);
        if (this.kvStore == null || other.kvStore == null) {
            return false;
        }
        if (!this.kvStore.equals(other.kvStore)) {
            return false;
        }
        if (this.kvHelperHosts == null || other.kvHelperHosts == null) {
            return false;
        }
        List<String> thisKvHelperHosts = Arrays.asList(this.kvHelperHosts);
        List<String> otherKvHelperHosts = Arrays.asList(other.getKVHelperHosts());
        if (thisKvHelperHosts.size() != otherKvHelperHosts.size()) {
            return false;
        }
        if (!thisKvHelperHosts.containsAll(otherKvHelperHosts)) {
            return false;
        }
        if (this.kvPart != other.kvPart) {
            return false;
        }
        return this.partitionSets == null ? other.partitionSets == null : this.partitionSets.equals(other.partitionSets);
    }

    public int hashCode() {
        int pm = 37;
        int hc = 11;
        int hcSum = 0;
        if (this.kvStore != null) {
            hcSum += this.kvStore.hashCode();
        }
        if (this.kvHelperHosts != null) {
            for (String kvHelperHost : this.kvHelperHosts) {
                hcSum += kvHelperHost.hashCode();
            }
        }
        hcSum += this.kvPart;
        if (this.partitionSets != null) {
            hcSum += this.partitionSets.hashCode();
        }
        hc = 37 * hc + hcSum;
        return hc;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        buf.append(": [store=");
        buf.append(this.kvStore);
        buf.append(", hosts=");
        if (this.kvHelperHosts != null) {
            buf.append(Arrays.asList(this.kvHelperHosts));
        } else {
            buf.append("null");
        }
        if (this.kvPart == 0) {
            buf.append(", nSets=").append(this.partitionSets.size());
        } else {
            buf.append(", partition=").append(this.kvPart);
        }
        buf.append("]");
        return buf.toString();
    }
}

