/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import com.sleepycat.util.PackedInteger;
import oracle.kv.Value;
import oracle.kv.avro.RawAvroBinding;
import oracle.kv.avro.RawRecord;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.avro.SchemaCache;
import oracle.kv.impl.api.avro.SchemaInfo;
import org.apache.avro.Schema;

class RawBinding
implements RawAvroBinding {
    private final SchemaCache schemaCache;

    RawBinding(SchemaCache schemaCache) {
        this.schemaCache = schemaCache;
    }

    @Override
    public RawRecord toObject(Value value) throws IllegalArgumentException {
        Schema schema = RawBinding.getValueSchema(value, this.schemaCache);
        byte[] buf = value.getValue();
        int dataOffset = RawBinding.getValueRawDataOffset(value);
        byte[] rawData = new byte[buf.length - dataOffset];
        System.arraycopy(buf, dataOffset, rawData, 0, rawData.length);
        return new RawRecord(rawData, schema);
    }

    public RawRecord toObjectForImport(Value value, Schema schema) throws IllegalArgumentException {
        byte[] buf = value.getValue();
        int dataOffset = RawBinding.getValueRawDataOffset(value);
        byte[] rawData = new byte[buf.length - dataOffset];
        System.arraycopy(buf, dataOffset, rawData, 0, rawData.length);
        return new RawRecord(rawData, schema);
    }

    static int getValueRawDataOffset(Value value) {
        return PackedInteger.getReadSortedIntLength(value.getValue(), 0);
    }

    static Schema getValueSchema(Value value, SchemaCache schemaCache) throws IllegalArgumentException {
        int schemaId;
        if (value.getFormat() != Value.Format.AVRO) {
            throw new IllegalArgumentException("Value.Format is not AVRO");
        }
        byte[] buf = value.getValue();
        try {
            schemaId = PackedInteger.readSortedInt(buf, 0);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Internal schema ID in Value is invalid, possibly due to incorrect binding usage", e);
        }
        SchemaInfo info = schemaCache.getSchemaInfoById(schemaId);
        if (info == null) {
            throw new IllegalArgumentException("Internal schema ID in Value is unknown, possibly due to incorrect binding usage; schemaId: " + schemaId);
        }
        return info.getSchema();
    }

    @Override
    public Value toValue(RawRecord object) throws UndefinedSchemaException {
        Schema schema = object.getSchema();
        byte[] rawData = object.getRawData();
        int rawDataSize = rawData.length;
        Value value = RawBinding.allocateValue(schema, rawDataSize, this.schemaCache);
        int dataOffset = RawBinding.getValueRawDataOffset(value);
        byte[] buf = value.getValue();
        System.arraycopy(rawData, 0, buf, dataOffset, rawDataSize);
        return value;
    }

    static Value allocateValue(Schema schema, int rawDataSize, SchemaCache schemaCache) throws UndefinedSchemaException {
        SchemaInfo info = schemaCache.getSchemaInfoByValue(schema);
        if (info == null) {
            throw AvroCatalogImpl.newUndefinedSchemaException(schema);
        }
        int schemaId = info.getId();
        int dataOffset = PackedInteger.getWriteSortedIntLength(schemaId);
        byte[] buf = new byte[dataOffset + rawDataSize];
        PackedInteger.writeSortedInt(buf, 0, schemaId);
        return Value.internalCreateValue(buf, Value.Format.AVRO);
    }
}

