/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import oracle.kv.impl.api.table.TableChange;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.api.table.TableMetadata;

class TableLimit
extends TableChange {
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String tableName;
    private final TableLimits limits;

    TableLimit(TableImpl table, int seqNum) {
        super(seqNum);
        assert (table.isTop());
        this.tableName = table.getFullName();
        this.namespace = table.getInternalNamespace();
        this.limits = table.getTableLimits();
    }

    @Override
    public boolean apply(TableMetadata md) {
        TableImpl table = md.getTable(this.namespace, this.tableName, true);
        if (table == null) {
            return false;
        }
        table.setTableLimits(this.limits);
        return true;
    }
}

