/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.async.EndpointConfig;
import oracle.kv.impl.security.ssl.SSLControl;

public class EndpointConfigBuilder {
    private static final String DEFAULT_OVERRIDE_PROPERTY_PREFIX = "oracle.kv.async.endpoint.config.default.";
    private static final Map<AsyncOption<?>, Object> optionDefaults = new HashMap();
    private final Map<AsyncOption<?>, Object> options = new HashMap();
    private SSLControl sslControl = null;
    private Object configId = null;

    public <T> EndpointConfigBuilder option(AsyncOption<T> option, T value) {
        this.options.put(option, value);
        return this;
    }

    public EndpointConfigBuilder sslControl(SSLControl sslCtrl) {
        this.sslControl = sslCtrl;
        return this;
    }

    public EndpointConfigBuilder configId(Object cfgId) {
        this.configId = cfgId;
        return this;
    }

    public EndpointConfig build() {
        return new EndpointConfig(this.options, optionDefaults, this.sslControl, this.configId);
    }

    private static <T> void optionDefault(AsyncOption<T> option, T value) {
        String propertyOverride = System.getProperty(DEFAULT_OVERRIDE_PROPERTY_PREFIX + option.name());
        if (propertyOverride != null) {
            value = option.parseStringValue(propertyOverride);
        }
        optionDefaults.put(option, value);
    }

    public static <T> T getOptionDefault(AsyncOption<T> option) {
        if (!optionDefaults.containsKey(option)) {
            throw new IllegalArgumentException("Option has no default value: " + option);
        }
        return option.type().cast(optionDefaults.get(option));
    }

    static {
        EndpointConfigBuilder.optionDefault(AsyncOption.SO_KEEPALIVE, null);
        EndpointConfigBuilder.optionDefault(AsyncOption.SO_LINGER, null);
        EndpointConfigBuilder.optionDefault(AsyncOption.SO_RCVBUF, null);
        EndpointConfigBuilder.optionDefault(AsyncOption.SO_REUSEADDR, false);
        EndpointConfigBuilder.optionDefault(AsyncOption.SO_SNDBUF, null);
        EndpointConfigBuilder.optionDefault(AsyncOption.TCP_NODELAY, true);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_LOCAL_MAXDLGS, 1024);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_LOCAL_MAXLEN, 1024);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_LOCAL_MAXTOTLEN, 0x100000);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_REMOTE_MAXDLGS, 1024);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_REMOTE_MAXLEN, 1024);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_REMOTE_MAXTOTLEN, 0x100000);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_CONNECT_TIMEOUT, 10000);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_HEARTBEAT_TIMEOUT, 10);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_HEARTBEAT_INTERVAL, 1000);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_IDLE_TIMEOUT, 10000);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_FLUSH_BATCHSZ, 64);
        EndpointConfigBuilder.optionDefault(AsyncOption.DLG_FLUSH_NBATCH, 4);
    }
}

