/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TablePath;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprArrayFilter;
import oracle.kv.impl.query.compiler.ExprArraySlice;
import oracle.kv.impl.query.compiler.ExprBaseTable;
import oracle.kv.impl.query.compiler.ExprFieldStep;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.ExprMapFilter;
import oracle.kv.impl.query.compiler.ExprVar;
import oracle.kv.impl.query.compiler.Function;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;
import oracle.kv.table.Index;

class IndexExpr {
    final Expr theExpr;
    TableImpl theTable;
    final List<StepInfo> theSteps;
    List<Expr> theFilteringPreds;
    boolean theDoesSlicing;
    boolean theIsJson;
    boolean theIsDirect = true;
    boolean theIsUnnested;
    boolean theIsGeo;
    ExprVar theCtxVar;
    int theCtxVarPos = -1;
    private boolean theIsMultiKey;
    List<IndexMatch> theIndexMatches;
    int thePrimKeyPos = -1;
    private int theCurrentMatch = -1;

    IndexExpr(Expr expr) {
        this.theExpr = expr;
        this.theSteps = new ArrayList<StepInfo>();
    }

    int numSteps() {
        return this.theSteps.size();
    }

    TablePath.StepKind getStepKind(int i) {
        return this.theSteps.get((int)i).theKind;
    }

    String getStepName(int i) {
        return this.theSteps.get((int)i).theName;
    }

    String getLastStepName() {
        return this.theSteps.get((int)(this.theSteps.size() - 1)).theName;
    }

    List<Expr> getFilteringPreds() {
        return this.theFilteringPreds;
    }

    boolean matchesIndex(TableImpl table, IndexImpl index) {
        this.theCurrentMatch = -1;
        if (this.theIndexMatches == null) {
            return false;
        }
        for (int i = 0; i < this.theIndexMatches.size(); ++i) {
            IndexMatch m = this.theIndexMatches.get(i);
            if (m.theTable.getId() != table.getId() || m.theIndex != index) continue;
            this.theCurrentMatch = i;
            return true;
        }
        return false;
    }

    boolean matchesIndex(IndexImpl index, int ipos) {
        this.theCurrentMatch = -1;
        if (this.theIndexMatches == null) {
            return false;
        }
        for (int i = 0; i < this.theIndexMatches.size(); ++i) {
            IndexMatch m = this.theIndexMatches.get(i);
            if (m.theIndex != index || m.theFieldPos != ipos) continue;
            this.theCurrentMatch = i;
            return true;
        }
        return false;
    }

    int getPathPos() {
        return this.theIndexMatches.get((int)this.theCurrentMatch).theFieldPos;
    }

    String getMapBothKey() {
        return this.theIndexMatches.get((int)this.theCurrentMatch).theMapBothKey;
    }

    String getMapBothKey(TableImpl table, IndexImpl index) {
        if (index == null) {
            return null;
        }
        if (this.matchesIndex(table, index)) {
            return this.theIndexMatches.get((int)this.theCurrentMatch).theMapBothKey;
        }
        throw new QueryStateException("No match found for index " + index.getName());
    }

    int getRelativeCtxVarPos() {
        return this.theIndexMatches.get((int)this.theCurrentMatch).theRelativeCtxVarPos;
    }

    int getRelativeCtxVarPos(TableImpl table, IndexImpl index) {
        if (this.matchesIndex(table, index)) {
            return this.theIndexMatches.get((int)this.theCurrentMatch).theRelativeCtxVarPos;
        }
        return 0;
    }

    FieldDefImpl getJsonDeclaredType() {
        return this.theIndexMatches.get((int)this.theCurrentMatch).theJsonDeclaredType;
    }

    boolean isMultiKey() {
        IndexMatch m = this.theIndexMatches.get(this.theCurrentMatch);
        if (m.theIndex == null) {
            return false;
        }
        if (m.theFieldPos >= m.theIndex.numFields()) {
            return false;
        }
        return m.theIndex.getIndexPath(m.theFieldPos).isMultiKey();
    }

    private void reverseSteps() {
        Collections.reverse(this.theSteps);
        if (this.theCtxVarPos >= 0) {
            this.theCtxVarPos = this.theSteps.size() - this.theCtxVarPos - 1;
        }
    }

    private void add(String name, TablePath.StepKind kind, Expr expr) {
        this.theSteps.add(new StepInfo(name, kind, expr));
    }

    private void addFilteringPred(Expr cond) {
        Function andOp;
        if (cond == null || this.theCtxVarPos >= 0) {
            return;
        }
        if (this.theFilteringPreds == null) {
            this.theFilteringPreds = new ArrayList<Expr>();
        }
        if ((andOp = cond.getFunction(FunctionLib.FuncCode.OP_AND)) != null) {
            this.theFilteringPreds.addAll(((ExprFuncCall)cond).getArgs());
        } else {
            this.theFilteringPreds.add(cond);
        }
    }

    private void addIndexMatch(IndexImpl index, int ipos, String mapKey, int relCtxVarPos, FieldDefImpl jsonDeclaredType) {
        if (this.theIndexMatches == null) {
            this.theIndexMatches = new ArrayList<IndexMatch>(8);
        }
        this.theIndexMatches.add(new IndexMatch(this.theTable, index, ipos, mapKey, relCtxVarPos, jsonDeclaredType));
        this.theCurrentMatch = this.theIndexMatches.size() - 1;
    }

    static IndexExpr create(Expr expr) {
        IndexExpr epath = new IndexExpr(expr);
        block12: while (expr != null) {
            if (!epath.theIsJson && (expr.getType().isAnyJson() || expr.getType().isAnyJsonAtomic())) {
                epath.theIsJson = true;
            }
            switch (expr.getKind()) {
                case FIELD_STEP: {
                    Expr stepExpr = (ExprFieldStep)expr;
                    String fieldName = ((ExprFieldStep)stepExpr).getFieldName();
                    ExprType inType = ((ExprFieldStep)stepExpr).getInput().getType();
                    if (fieldName == null || inType.isAtomic()) {
                        return null;
                    }
                    if (inType.isArray()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        epath.theIsMultiKey = true;
                        FieldDefImpl elemDef = ((ArrayDefImpl)inType.getDef()).getElement();
                        if (elemDef.isArray() || elemDef.isAtomic()) {
                            return null;
                        }
                        if (elemDef.isRecord()) {
                            epath.add(fieldName, TablePath.StepKind.REC_FIELD, expr);
                        } else {
                            epath.add(fieldName, TablePath.StepKind.MAP_FIELD, expr);
                        }
                    } else if (inType.isRecord()) {
                        epath.add(fieldName, TablePath.StepKind.REC_FIELD, expr);
                    } else {
                        epath.add(fieldName, TablePath.StepKind.MAP_FIELD, expr);
                    }
                    expr = expr.getInput();
                    continue block12;
                }
                case MAP_FILTER: {
                    Expr stepExpr = (ExprMapFilter)expr;
                    ExprType inType = expr.getInput().getType();
                    if (!inType.isMap() && !inType.isAnyJson()) {
                        return null;
                    }
                    if (inType.isMap()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        epath.theIsMultiKey = true;
                    }
                    if (((ExprMapFilter)stepExpr).getFilterKind() == ExprMapFilter.FilterKind.KEYS) {
                        epath.add("keys()", TablePath.StepKind.KEYS, expr);
                    } else {
                        epath.add("values()", TablePath.StepKind.VALUES, expr);
                    }
                    epath.addFilteringPred(((ExprMapFilter)stepExpr).getPredExpr());
                    expr = expr.getInput();
                    continue block12;
                }
                case ARRAY_SLICE: 
                case ARRAY_FILTER: {
                    Expr step;
                    ExprType inType = expr.getInput().getType();
                    if (inType.isArray()) {
                        if (epath.theIsMultiKey) {
                            return null;
                        }
                        epath.theIsMultiKey = true;
                    }
                    epath.add("[]", TablePath.StepKind.BRACKETS, expr);
                    if (expr.getKind() == Expr.ExprKind.ARRAY_SLICE) {
                        step = (ExprArraySlice)expr;
                        if (((ExprArraySlice)step).hasBounds()) {
                            epath.theDoesSlicing = true;
                        }
                    } else {
                        step = (ExprArrayFilter)expr;
                        Expr pred = ((ExprArrayFilter)step).getPredExpr();
                        if (pred != null) {
                            if (pred.getType().getDef().isBoolean()) {
                                epath.addFilteringPred(pred);
                            } else {
                                epath.theDoesSlicing = true;
                            }
                        }
                    }
                    expr = expr.getInput();
                    continue block12;
                }
                case VAR: {
                    ExprVar varExpr = (ExprVar)expr;
                    switch (varExpr.getVarKind()) {
                        case FOR: {
                            expr = varExpr.getDomainExpr();
                            if (expr.getKind() != Expr.ExprKind.BASE_TABLE) {
                                epath.theIsDirect = false;
                                if (!expr.isMultiValued()) continue block12;
                                epath.theIsUnnested = true;
                                continue block12;
                            }
                            ExprBaseTable tableExpr = (ExprBaseTable)expr;
                            epath.reverseSteps();
                            epath.theTable = tableExpr.getTableForAlias(varExpr.getTableAlias());
                            expr = null;
                            continue block12;
                        }
                        case CTX_ELEM: {
                            expr = varExpr.getCtxExpr();
                            epath.theIsDirect = false;
                            epath.theCtxVar = varExpr;
                            epath.theCtxVarPos = epath.theSteps.size();
                            if (expr.getKind() == Expr.ExprKind.ARRAY_FILTER) {
                                epath.add("[]", TablePath.StepKind.BRACKETS, expr);
                                expr = expr.getInput();
                                continue block12;
                            }
                            if (expr.getKind() == Expr.ExprKind.MAP_FILTER) {
                                epath.add("values()", TablePath.StepKind.VALUES, expr);
                                expr = expr.getInput();
                                continue block12;
                            }
                            return null;
                        }
                        case CTX_KEY: {
                            expr = varExpr.getCtxExpr();
                            epath.theIsDirect = false;
                            epath.theCtxVar = varExpr;
                            epath.theCtxVarPos = epath.theSteps.size();
                            assert (expr.getKind() == Expr.ExprKind.MAP_FILTER);
                            epath.add("keys()", TablePath.StepKind.KEYS, expr);
                            expr = expr.getInput();
                            continue block12;
                        }
                    }
                    return null;
                }
                case BASE_TABLE: {
                    throw new QueryStateException("Reached base table expression for path " + epath.getPathName());
                }
            }
            return null;
        }
        int pkPos = -1;
        if (epath.numSteps() == 1 && (pkPos = epath.theTable.findKeyComponent(epath.getLastStepName())) >= 0) {
            epath.thePrimKeyPos = pkPos;
            epath.addIndexMatch(null, pkPos, null, 0, null);
        }
        Map<String, Index> indexes = epath.theTable.getIndexes();
        for (Map.Entry<String, Index> entry : indexes.entrySet()) {
            boolean foundMatch = false;
            IndexImpl index = (IndexImpl)entry.getValue();
            List<IndexImpl.IndexField> indexPaths = index.getIndexFields();
            int numFields = indexPaths.size();
            for (IndexImpl.IndexField ipath : indexPaths) {
                if (!epath.matchToIndexPath(index, ipath)) continue;
                if (ipath.getDeclaredType() == null) {
                    foundMatch = true;
                    break;
                }
                if (ipath.isGeometry() || ipath.isPoint()) {
                    foundMatch = true;
                    epath.theIsGeo = true;
                    break;
                }
                ExprType.Quantifier quant = ipath.isMultiKey() && epath.getMapBothKey() == null ? ExprType.Quantifier.STAR : ExprType.Quantifier.QSTN;
                ExprType t = TypeManager.createType(TypeManager.ANY_JATOMIC_ONE(), quant);
                epath.theExpr.setType(t);
                foundMatch = true;
                break;
            }
            if (foundMatch || pkPos < 0) continue;
            epath.addIndexMatch(index, numFields + pkPos, null, 0, null);
        }
        return epath;
    }

    private boolean matchToIndexPath(IndexImpl index, IndexImpl.IndexField ipath) {
        if (this.theIsMultiKey && !ipath.isMultiKey()) {
            return false;
        }
        IndexExpr epath = this;
        boolean mapBothIndex = index.isMapBothIndex();
        String mapKey = null;
        int inumSteps = ipath.numSteps();
        int enumSteps = this.numSteps();
        int relativeCtxVarPos = -2;
        int ii = 0;
        int ie = 0;
        while (ii < inumSteps && ie < enumSteps) {
            boolean eq;
            String istep = ipath.getStep(ii);
            String estep = epath.getStepName(ie);
            TablePath.StepKind ikind = ipath.getStepKind(ii);
            TablePath.StepKind ekind = epath.getStepKind(ie);
            if (ie == this.theCtxVarPos) {
                relativeCtxVarPos = ii >= ipath.getMultiKeyStepPos() ? 1 : -1;
            }
            boolean bl = ikind == ekind && (ipath.isMapKeyStep(ii) ? istep.equals(estep) : istep.equalsIgnoreCase(estep)) ? true : (eq = false);
            if (eq) {
                ++ii;
                ++ie;
                continue;
            }
            if (ikind == TablePath.StepKind.BRACKETS) {
                if (ii == inumSteps - 1) {
                    return false;
                }
                ++ii;
                continue;
            }
            if (ekind == TablePath.StepKind.BRACKETS) {
                if (ie == enumSteps - 1) {
                    return false;
                }
                ++ie;
                continue;
            }
            if (ipath.isValuesStep(ii) && mapBothIndex) {
                mapKey = estep;
                ++ii;
                ++ie;
                continue;
            }
            return false;
        }
        if (ii == inumSteps && (ie == enumSteps || ie == enumSteps - 1 && epath.getStepKind(ie) == TablePath.StepKind.BRACKETS)) {
            this.addIndexMatch(index, ipath.getPosition(), mapKey, relativeCtxVarPos, ipath.getDeclaredType());
            return true;
        }
        return false;
    }

    String getPathName() {
        StringBuilder sb = new StringBuilder();
        int numSteps = this.theSteps.size();
        for (int i = 0; i < numSteps; ++i) {
            String step = this.theSteps.get((int)i).theName;
            if ("[]".equals(step)) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append(step);
            if (i >= numSteps - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    static class IndexMatch {
        TableImpl theTable;
        IndexImpl theIndex;
        int theFieldPos;
        String theMapBothKey;
        int theRelativeCtxVarPos;
        FieldDefImpl theJsonDeclaredType;

        IndexMatch(TableImpl table, IndexImpl index, int ipos, String mapKey, int relCtxVarPos, FieldDefImpl jsonDeclaredType) {
            this.theTable = table;
            this.theIndex = index;
            this.theFieldPos = ipos;
            this.theMapBothKey = mapKey;
            this.theRelativeCtxVarPos = relCtxVarPos;
            this.theJsonDeclaredType = jsonDeclaredType;
        }
    }

    static class StepInfo {
        String theName;
        TablePath.StepKind theKind;
        Expr theExpr;

        StepInfo(String name, TablePath.StepKind kind, Expr expr) {
            this.theName = name;
            this.theKind = kind;
            this.theExpr = expr;
        }
    }
}

