/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.ArbNodeParams;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.ArbNode;
import oracle.kv.impl.topo.ArbNodeId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.shell.Shell;

public class GenerateConfig {
    public static final String COMMAND_NAME = "generateconfig";
    public static final String COMMAND_DESC = "generates configuration files for the specified storage node";
    public static final String COMMAND_ARGS = CommandParser.getHostUsage() + " " + CommandParser.getPortUsage() + " -sn <StorageNodeId> -target <zipfile>" + Shell.eolt + "[" + CommandParser.getUserUsage() + "] [" + CommandParser.getSecurityUsage() + "] [-secdir <overriden security directory>]";
    private StorageNodeId snid;
    private Parser parser;
    private CommandServiceAPI cs;
    private Topology t;
    private Parameters p;
    private String target;
    private String userName;
    private String securityFilePath;
    private String secDir;
    private boolean isSecured;
    private LoginCredentials creds;

    private void generate() throws Exception {
        this.initLogin();
        String host = this.parser.getHostname();
        int port = this.parser.getRegistryPort();
        AdminLoginManager loginMgr = KVStoreLogin.getAdminLoginMgr(host, port, this.creds);
        this.cs = RegistryUtils.getAdmin(host, port, (LoginManager)loginMgr);
        this.t = this.cs.getTopology();
        this.p = this.cs.getParameters();
        GlobalParams gp = this.p.getGlobalParams();
        StorageNodeParams snp = this.p.get(this.snid);
        AdminParams ap = GenerateConfig.getAdminParams(this.snid, this.p);
        LoadParameters lp = GenerateConfig.generateConfig(this.t, this.p, gp, snp, ap, this.snid);
        if (this.isSecured) {
            if (this.secDir == null || this.secDir.isEmpty()) {
                this.secDir = "security";
            }
        } else {
            this.secDir = null;
        }
        LoadParameters bootLp = GenerateConfig.generateBootConfig(gp, snp, ap, this.secDir);
        File rootDir = new File(snp.getRootDirPath());
        this.createFiles(rootDir.getName(), gp.getKVStoreName(), lp, bootLp);
        GenerateConfig.createZip(this.target, rootDir.getName(), null);
        GenerateConfig.delete(new File(rootDir.getName()));
    }

    public static AdminParams getAdminParams(StorageNodeId storageNodeId, Parameters params) {
        Collection aps = params.getAdminParams();
        for (AdminParams ap : aps) {
            if (!ap.getStorageNodeId().equals(storageNodeId)) continue;
            return ap;
        }
        return null;
    }

    static LoadParameters generateConfig(Topology topo, Parameters params, GlobalParams globalParams, StorageNodeParams storageNodeParams, AdminParams adminParams, StorageNodeId storageNodeId) {
        LoadParameters lp = new LoadParameters();
        lp.addMap(globalParams.getMap());
        lp.addMap(storageNodeParams.getMap());
        if (storageNodeParams.getStorageDirMap() != null) {
            lp.addMap(storageNodeParams.getStorageDirMap());
        }
        if (storageNodeParams.getRNLogDirMap() != null) {
            lp.addMap(storageNodeParams.getRNLogDirMap());
        }
        if (storageNodeParams.getAdminDirMap() != null) {
            lp.addMap(storageNodeParams.getAdminDirMap());
        }
        if (adminParams != null) {
            lp.addMap(adminParams.getMap());
        }
        List<RepNode> rns = topo.getSortedRepNodes();
        for (RepNode rn : rns) {
            if (!rn.getStorageNodeId().equals(storageNodeId)) continue;
            RepNodeParams rnp = params.get((RepNodeId)rn.getResourceId());
            lp.addMap(rnp.getMap());
        }
        List<ArbNode> ans = topo.getSortedArbNodes();
        for (ArbNode an : ans) {
            if (!an.getStorageNodeId().equals(storageNodeId)) continue;
            ArbNodeParams anp = params.get((ArbNodeId)an.getResourceId());
            lp.addMap(anp.getMap());
        }
        return lp;
    }

    static LoadParameters generateBootConfig(GlobalParams gp, StorageNodeParams snp, AdminParams ap, String securityDir) throws Exception {
        LoadParameters lp = new LoadParameters();
        boolean hostingAdmin = false;
        if (ap != null) {
            hostingAdmin = true;
        }
        BootstrapParams bp = new BootstrapParams(snp.getRootDirPath(), snp.getHostname(), snp.getHAHostname(), snp.getHAPortRange(), snp.getServicePortRange(), gp.getKVStoreName(), snp.getRegistryPort(), snp.getAdminWebPort(), snp.getCapacity(), securityDir, hostingAdmin, snp.getMgmtClass());
        bp.setStorageDirMap(snp.getStorageDirMap());
        bp.setRNLogDirMap(snp.getRNLogDirMap());
        bp.setAdminDirMap(snp.getAdminDirMap());
        ParameterMap map = bp.getMap();
        map.setParameter("storageNodeId", Integer.toString(snp.getStorageNodeId().getStorageNodeId()));
        lp.addMap(map);
        lp.addMap(bp.getStorageDirMap());
        lp.addMap(bp.getRNLogDirMap());
        lp.addMap(bp.getAdminDirMap());
        lp.setVersion(3);
        return lp;
    }

    private void createFiles(String rootName, String storeName, LoadParameters lp, LoadParameters bootLp) throws Exception {
        String secPolicy = "grant {\n  permission java.security.AllPermission;\n};\n";
        String tmpName = rootName;
        File rootDir = new File(tmpName);
        rootDir.mkdir();
        bootLp.saveParameters(new File(rootDir, "config.xml"));
        File storeDir = new File(rootDir, storeName);
        storeDir.mkdir();
        File snDir = FileNames.getStorageNodeDir((File)storeDir, (StorageNodeId)this.snid);
        snDir.mkdir();
        GenerateConfig.writeFile(new File(rootDir, "security.policy"), secPolicy);
        GenerateConfig.writeFile(new File(storeDir, "security.policy"), secPolicy);
        lp.saveParameters(FileNames.getSNAConfigFile((String)rootDir.getAbsolutePath(), (String)storeName, (StorageNodeId)this.snid));
    }

    static void writeFile(File file, String content) {
        try (PrintWriter writer = null;){
            FileOutputStream fos = new FileOutputStream(file);
            writer = new PrintWriter(fos);
            writer.printf("%s", content);
        }
    }

    static void createZip(String targetConfigName, String sourceName, String targetName) throws IOException {
        try {
            if (!targetConfigName.contains(".zip")) {
                targetConfigName = targetConfigName + ".zip";
            }
            FileOutputStream fout = new FileOutputStream(new File(targetConfigName));
            ZipOutputStream zout = new ZipOutputStream(fout);
            System.out.println("Creating zipfile " + targetConfigName);
            File source = new File(sourceName);
            File target = new File(targetName == null ? sourceName : targetName);
            GenerateConfig.addDirectory(zout, source, target);
            zout.close();
        }
        catch (IOException ioe) {
            throw new IOException("IOException :" + ioe);
        }
    }

    private static void addDirectory(ZipOutputStream zout, File source, File target) {
        File[] files = source.listFiles();
        System.out.println("Adding directory " + target.getPath());
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                GenerateConfig.addDirectory(zout, new File(source.getPath() + File.separator + files[i].getName()), new File(target.getPath() + File.separator + files[i].getName()));
                continue;
            }
            try {
                int length;
                String sourcePath = source.getPath() + File.separator + files[i].getName();
                String targetPath = target.getPath() + File.separator + files[i].getName();
                System.out.println("Adding file " + targetPath);
                byte[] buffer = new byte[1024];
                FileInputStream fin = new FileInputStream(sourcePath);
                zout.putNextEntry(new ZipEntry(targetPath));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                fin.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IOException :" + ioe);
            }
        }
    }

    static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                GenerateConfig.delete(file);
            }
        }
        f.delete();
    }

    private void initLogin() throws IOException {
        KVStoreLogin storeLogin = new KVStoreLogin(this.userName, this.securityFilePath);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        this.isSecured = storeLogin.foundTransportSettings();
        if (this.isSecured) {
            this.creds = storeLogin.makeShellLoginCredentials();
        }
    }

    public void parseArgs(String[] args) {
        this.parser = new Parser(args);
        this.parser.parseArgs();
        this.userName = this.parser.getUserName();
        this.securityFilePath = this.parser.getSecurityFile();
    }

    public static void main(String[] args) {
        GenerateConfig gen = new GenerateConfig();
        gen.parseArgs(args);
        try {
            gen.generate();
        }
        catch (Exception e) {
            System.err.println("Exception in GenerateConfig: " + e);
        }
    }

    class Parser
    extends CommandParser {
        public static final String snidFlag = "-sn";
        public static final String targetFlag = "-target";
        public static final String secDirFlag = "-secdir";

        public Parser(String[] args) {
            super(args);
        }

        protected void verifyArgs() {
            if (this.getHostname() == null || this.getRegistryPort() == 0 || GenerateConfig.this.snid == null || GenerateConfig.this.target == null) {
                this.usage("Missing required argument");
            }
        }

        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar generateconfig\n\t" + COMMAND_ARGS);
            System.exit(-1);
        }

        protected boolean checkArg(String arg) {
            if (arg.equals(snidFlag)) {
                String sn = this.nextArg(arg);
                try {
                    GenerateConfig.this.snid = StorageNodeId.parse(sn);
                }
                catch (IllegalArgumentException iae) {
                    this.usage("Invalid Storage Node Id: " + sn);
                }
                return true;
            }
            if (arg.equals(targetFlag)) {
                GenerateConfig.this.target = this.nextArg(arg);
                return true;
            }
            if (arg.equals(secDirFlag)) {
                GenerateConfig.this.secDir = this.nextArg(arg);
                return true;
            }
            return false;
        }
    }
}

