/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.orderedlist;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.testing.models.orderedlist.Child;
import org.eclipse.persistence.testing.models.orderedlist.PhoneNumber;
import org.eclipse.persistence.testing.models.orderedlist.Project;

public class Employee
implements ChangeTracker {
    public BigDecimal id;
    public String firstName = "";
    public String lastName = "";
    public ValueHolderInterface manager = new ValueHolder();
    public List<Employee> managedEmployees = new ArrayList<Employee>();
    public List<PhoneNumber> phoneNumbers;
    public List<Project> projects = new ArrayList<Project>();
    public List<Project> projectsLed = new ArrayList<Project>();
    public List<String> responsibilitiesList = new ArrayList<String>();
    public Vector<Child> children;
    int salary;
    public PropertyChangeListener listener;

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listener != null && oldValue != newValue) {
            this.listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    public void collectionChange(String propertyName, Object oldValue, Object newValue, int changeType, boolean isChangeApplied) {
        if (this.listener != null) {
            this.listener.propertyChange((PropertyChangeEvent)new CollectionChangeEvent((Object)this, propertyName, oldValue, newValue, changeType, isChangeApplied));
        }
    }

    public Employee() {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
        this.children = new Vector();
    }

    public Employee(String firstName, String lastName) {
        this();
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public Employee(String firstName) {
        this(firstName, "");
    }

    public void addManagedEmployee(Employee employee) {
        this.getManagedEmployees().add(employee);
        employee.setManager(this);
    }

    public void addManagedEmployee(int index, Employee employee) {
        this.getManagedEmployees().add(index, employee);
        employee.setManager(this);
    }

    public Employee setManagedEmployee(int index, Employee employee) {
        Employee removedEmp = this.getManagedEmployees().set(index, employee);
        removedEmp.setManager(null);
        employee.setManager(this);
        return removedEmp;
    }

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
    }

    public void addPhoneNumber(int index, PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(index, phoneNumber);
    }

    public PhoneNumber setPhoneNumber(int index, PhoneNumber phoneNumber) {
        return this.getPhoneNumbers().set(index, phoneNumber);
    }

    public void addProject(Project project) {
        this.getProjects().add(project);
        project.getEmployees().add(this);
    }

    public void addProject(int index, Project project) {
        this.getProjects().add(index, project);
        project.getEmployees().add(this);
    }

    public Project setProject(int index, Project project) {
        Project removedProject = this.getProjects().set(index, project);
        removedProject.getEmployees().remove(this);
        project.getEmployees().add(this);
        return removedProject;
    }

    public void addProjectLed(Project project) {
        this.getProjectsLed().add(project);
        project.setTeamLeader(this);
    }

    public void addResponsibility(String responsibility) {
        this.getResponsibilitiesList().add(responsibility);
    }

    public void addResponsibility(int index, String responsibility) {
        this.getResponsibilitiesList().add(index, responsibility);
    }

    public String setResponsibility(int index, String responsibility) {
        return this.getResponsibilitiesList().set(index, responsibility);
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String getLastName() {
        return this.lastName;
    }

    public int getSalary() {
        return this.salary;
    }

    public List<Employee> getManagedEmployees() {
        return this.managedEmployees;
    }

    public Employee getManager() {
        return (Employee)this.manager.getValue();
    }

    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public List<Project> getProjectsLed() {
        return this.projectsLed;
    }

    public List<String> getResponsibilitiesList() {
        return this.responsibilitiesList;
    }

    public void removeManagedEmployee(Employee employee) {
        this.getManagedEmployees().remove(employee);
        employee.setManager(null);
    }

    public Employee removeManagedEmployee(int i) {
        Employee emp = this.getManagedEmployees().remove(i);
        emp.setManager(null);
        return emp;
    }

    public void removePhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().remove(phoneNumber);
    }

    public PhoneNumber removePhoneNumber(int i) {
        PhoneNumber phone = this.getPhoneNumbers().remove(i);
        return phone;
    }

    public void removeProject(Project project) {
        this.getProjects().remove(project);
        project.getEmployees().remove(this);
    }

    public Project removeProject(int i) {
        Project project = this.getProjects().remove(i);
        project.getEmployees().remove(this);
        return project;
    }

    public void removeProjectLed(Project project) {
        this.getProjectsLed().remove(project);
        project.setTeamLeader(null);
    }

    public void removeResponsibility(String responsibility) {
        this.getResponsibilitiesList().remove(responsibility);
    }

    public String removeResponsibility(int i) {
        return this.getResponsibilitiesList().remove(i);
    }

    public void setChildren(Vector<Child> children) {
        this.propertyChange("children", this.children, children);
        this.children = children;
    }

    public void setFirstName(String firstName) {
        this.propertyChange("firstName", this.getFirstName(), firstName);
        this.firstName = firstName;
    }

    public void setId(BigDecimal id) {
        this.propertyChange("id", this.id, id);
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.propertyChange("lastName", this.lastName, lastName);
        this.lastName = lastName;
    }

    public void getSalary(int salary) {
        this.propertyChange("salary", this.salary, salary);
        this.salary = salary;
    }

    public void setManagedEmployees(List<Employee> managedEmployees) {
        this.propertyChange("managedEmployees", this.managedEmployees, managedEmployees);
        this.managedEmployees = managedEmployees;
    }

    public void setManager(Employee manager) {
        this.propertyChange("manager", this.manager.getValue(), manager);
        this.manager.setValue((Object)manager);
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
        this.propertyChange("phoneNumbers", this.phoneNumbers, phoneNumbers);
        this.phoneNumbers = phoneNumbers;
    }

    public void setProjects(List<Project> projects) {
        this.propertyChange("projects", this.projects, projects);
        this.projects = projects;
    }

    public void setProjectsLed(List<Project> projectsLed) {
        this.projectsLed = projectsLed;
    }

    public void setResponsibilitiesList(List<String> responsibilitiesList) {
        this.propertyChange("responsibilitiesList", this.responsibilitiesList, responsibilitiesList);
        this.responsibilitiesList = responsibilitiesList;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Employee: ");
        writer.write(this.getFirstName());
        writer.write(" ");
        writer.write(this.getLastName());
        return writer.toString();
    }
}

