/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.List;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.Company;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.SingleHouse;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class AggregateCollectionMultipleUoWTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork1;
    public UnitOfWork unitOfWork2;

    public AggregateCollectionMultipleUoWTest() {
    }

    public AggregateCollectionMultipleUoWTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy1(Object object) {
        AgentBuilderHelper.setLastName(object, "Jackson");
        List customers = AgentBuilderHelper.getCustomers(object);
        Customer customer1 = (Customer)customers.get(0);
        customer1.setName("Vince Carter");
        customer1.removeDependant(customer1.getDependants().lastElement());
        List houses = AgentBuilderHelper.getHouses(object);
        House house2 = (House)houses.get(houses.size() - 1);
        house2.setDescriptions("do not buy it, it collapses -:)");
    }

    protected void changeUnitOfWorkWorkingCopy2(Object object) {
        AgentBuilderHelper.setLastName(object, "White");
        List customers = AgentBuilderHelper.getCustomers(object);
        Customer customer1 = (Customer)customers.get(0);
        customer1.setName("Tracy Martins");
        Customer newCustomer = new Customer();
        newCustomer.setIncome(753923);
        newCustomer.setName("Pete Lee");
        newCustomer.setCompany(Company.example5());
        newCustomer.addDependant(new Dependant("Sue", 5));
        newCustomer.addDependant(new Dependant("David", 1));
        AgentBuilderHelper.addCustomer(object, newCustomer);
        SingleHouse newHouse = new SingleHouse();
        newHouse.setLocation("123 Slater Street");
        newHouse.setDescriptions("every convinent to who works with The Object People");
        newHouse.setNumberOfGarages(3);
        AgentBuilderHelper.addHouse(object, newHouse);
    }

    protected void changeUnitOfWorkWorkingCopy3(Object object) {
        AgentBuilderHelper.setFirstName(object, "Johnie");
        Customer customer1 = (Customer)AgentBuilderHelper.getCustomers(object).get(2);
        customer1.setName("James");
        customer1.removeDependant(customer1.getDependants().firstElement());
        customer1.addDependant(new Dependant("Stevenson", 14));
        AgentBuilderHelper.removeHouse(object, (House)AgentBuilderHelper.getHouses(object).get(AgentBuilderHelper.getHouses(object).size() - 1));
        House newHouse = new House();
        newHouse.setLocation("45 Mann Ave");
        newHouse.setDescriptions("Close to Ottawa U.");
        AgentBuilderHelper.addHouse(object, newHouse);
    }

    protected void setup() {
        super.setup();
    }

    protected void test() {
        try {
            this.unitOfWork1 = this.getSession().acquireUnitOfWork();
            Object object = this.unitOfWork1.registerObject(this.objectToBeWritten);
            this.changeUnitOfWorkWorkingCopy1(object);
            this.unitOfWork1.commitAndResume();
            UnitOfWork nestedUnitOfWork = this.unitOfWork1.acquireUnitOfWork();
            Object objectClone1 = nestedUnitOfWork.registerObject(object);
            UnitOfWork nestedNestedUnitOfWork = nestedUnitOfWork.acquireUnitOfWork();
            Object objectClone = nestedNestedUnitOfWork.registerObject(objectClone1);
            this.changeUnitOfWorkWorkingCopy2(objectClone);
            nestedNestedUnitOfWork.commit();
            nestedUnitOfWork.commit();
            this.unitOfWork1.commit();
            this.unitOfWork2 = this.getSession().acquireUnitOfWork();
            Object objectClone2 = this.unitOfWork2.readObject(this.originalObject.getClass());
            this.changeUnitOfWorkWorkingCopy3(objectClone2);
            this.unitOfWork2.commit();
        }
        catch (OptimisticLockException ex) {
            throw new TestWarningException("Optimistic locking exception thrown when object was changed outside during the transaction");
        }
    }

    protected void verify() {
    }
}

