/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.clientserver.AddressClient;
import org.eclipse.persistence.testing.tests.clientserver.Client2;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerOptimisticLockingTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected Client2[] clients = new Client2[NUM_CLIENTS];
    protected AddressClient aClient;
    protected Server server;
    public static int NUM_CLIENTS = 15;

    public ClientServerOptimisticLockingTest() {
        this.setDescription("Tests running a number of threads while using optomistic locking");
    }

    public void reset() {
        block3: {
            try {
                for (int i = 0; i < NUM_CLIENTS; ++i) {
                    this.clients[i].release();
                }
                this.aClient.release();
                this.server.logout();
                this.getDatabaseSession().logout();
                this.getDatabaseSession().login();
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void setup() {
        block3: {
            try {
                this.login = (DatabaseLogin)this.getSession().getLogin().clone();
                this.server = new Server(this.login);
                this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
                this.server.login();
                this.server.copyDescriptors(this.getSession());
                for (int i = 0; i < NUM_CLIENTS; ++i) {
                    this.clients[i] = new Client2(this.server, this.getSession(), "Client" + i);
                }
                this.aClient = new AddressClient(this.server, this.getSession(), "aClient");
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block3;
                this.verify();
            }
        }
    }

    public void test() {
        block6: {
            try {
                int i;
                ClientSession cs = this.server.serverSession.acquireClientSession();
                Employee newEmp = new Employee();
                newEmp.setFirstName("Matthew");
                newEmp.setLastName("MacIvor");
                UnitOfWork uow = cs.acquireUnitOfWork();
                uow.registerObject((Object)newEmp);
                uow.commit();
                cs.release();
                for (i = 0; i < NUM_CLIENTS; ++i) {
                    this.clients[i].start();
                }
                this.aClient.start();
                try {
                    for (i = 0; i < NUM_CLIENTS; ++i) {
                        this.clients[i].join();
                    }
                    this.aClient.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception ex) {
                if (!(ex instanceof ValidationException)) break block6;
                this.verify();
            }
        }
    }

    public void verify() {
        try {
            for (int i = 0; i < NUM_CLIENTS; ++i) {
                if (this.clients[i].exception == null) continue;
                throw new TestErrorException("Error occurred, check system.out");
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof ValidationException) || ((ValidationException)ex).getErrorCode() == 7090) {
                // empty if block
            }
        }
    }
}

