/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CustomSQLSubQueryTest
extends AutoVerifyTestCase {
    protected ReadAllQuery query;
    protected int numberOfManagedEmployees;
    protected Object objectsFromDatabase;
    protected Class<?> referenceClass = Employee.class;
    protected Employee someManager;

    public CustomSQLSubQueryTest() {
        this.setName("CustomSQLSubQueryTest(" + this.referenceClass.getName() + ")");
        this.setDescription("The test runs a ReadAllQuery with a customSQL subquery to the database.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.someManager = (Employee)this.getSession().readObject(this.referenceClass);
        this.numberOfManagedEmployees = this.someManager.getManagedEmployees().size();
    }

    protected void test() {
        this.query = new ReadAllQuery();
        this.query.setReferenceClass(this.referenceClass);
        ReportQuery hierarchyQuery = new ReportQuery();
        hierarchyQuery.setReferenceClass(this.referenceClass);
        hierarchyQuery.setCall((Call)new SQLCall("SELECT EMP_ID FROM EMPLOYEE WHERE MANAGER_ID=#employeeId"));
        this.query.setSelectionCriteria(this.query.getExpressionBuilder().get("id").in(hierarchyQuery));
        this.query.addArgument("employeeId");
    }

    protected void verify() throws Exception {
        Vector<BigDecimal> params = new Vector<BigDecimal>();
        params.add(this.someManager.getId());
        try {
            Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query, params);
            if (this.numberOfManagedEmployees != results.size()) {
                throw new TestErrorException(results.size() + " objects were read from the database, but originially there were, " + this.numberOfManagedEmployees + ".");
            }
        }
        catch (DatabaseException e) {
            throw new TestErrorException("Custom SQL subquery with parameters failed with a DatabaseException.");
        }
    }
}

