/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.rmi.registry.LocateRegistry;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.AggregateSystem;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.Client;
import org.eclipse.persistence.testing.models.aggregate.Employee1;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedSystem;
import org.eclipse.persistence.testing.tests.distributedservers.InsertNewCycleTest;
import org.eclipse.persistence.testing.tests.distributedservers.InsertNewObjectIntoCycleTest;
import org.eclipse.persistence.testing.tests.distributedservers.StoredInObjectOptimisticLockTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeNothingTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeObjectTestEmployee1;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeObjectWithOptimisticLockTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateChangeValueTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateCollectionWithNewValueTest;
import org.eclipse.persistence.testing.tests.distributedservers.UpdateToNullTest;
import org.eclipse.persistence.testing.tests.distributedservers.VerifyAggregateCollectionNewObjectTest;
import org.eclipse.persistence.testing.tests.distributedservers.VerifyAggregateCollectionObjectsDeletedFromCacheTest;
import org.eclipse.persistence.testing.tests.distributedservers.VerifyDeletedObjectsTest;
import org.eclipse.persistence.testing.tests.distributedservers.VerifyObjectsDeletedFromCacheTest;
import org.eclipse.persistence.testing.tests.unitofwork.UOWSystem;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public abstract class DistributedServersModel
extends TestModel {
    public static Vector distributedServers;
    protected static boolean registryStarted;

    public DistributedServersModel() {
        this.setDescription("This suite tests updating objects with changed parts.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
        this.addRequiredSystem(new DistributedSystem());
        this.addRequiredSystem(new UOWSystem());
        this.addRequiredSystem(new AggregateSystem());
    }

    public void addTests() {
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        ComplexUpdateTest test = new UpdateToNullTest(employee);
        this.addTest((Test)test);
        test = new UpdateChangeValueTest(employee);
        this.addTest((Test)test);
        test = new UpdateChangeNothingTest(employee);
        this.addTest((Test)test);
        test = new UpdateChangeObjectTest(employee);
        this.addTest((Test)test);
        this.addTest((Test)new UpdateChangeObjectTestEmployee1((Employee1)manager.getObject(Employee1.class, "example1")));
        this.addTest((Test)new UpdateCollectionWithNewValueTest(employee));
        this.addTest((Test)new VerifyDeletedObjectsTest());
        this.addTest((Test)new VerifyObjectsDeletedFromCacheTest());
        this.addTest((Test)new InsertNewCycleTest());
        this.addTest((Test)new InsertNewObjectIntoCycleTest());
        this.addTest((Test)new VerifyAggregateCollectionObjectsDeletedFromCacheTest((Agent)manager.getObject(Agent.class, "example1")));
        this.addTest((Test)new VerifyAggregateCollectionObjectsDeletedFromCacheTest((Builder)manager.getObject(Builder.class, "example1")));
        this.addTest((Test)new VerifyAggregateCollectionNewObjectTest((Agent)manager.getObject(Agent.class, "example1")));
        this.addTest((Test)new VerifyAggregateCollectionNewObjectTest((Builder)manager.getObject(Builder.class, "example1")));
        this.addTest((Test)new UpdateChangeObjectWithOptimisticLockTest(employee));
        this.addTest((Test)new StoredInObjectOptimisticLockTest((Client)manager.getObject(Client.class, "example1")));
    }

    public abstract DistributedServer createDistributedServer(Session var1);

    public static Vector getDistributedServers() {
        if (distributedServers == null) {
            distributedServers = new Vector(5);
        }
        return distributedServers;
    }

    public static boolean isRegistryStarted() {
        return registryStarted;
    }

    public void reset() {
        if (DistributedServersModel.isRegistryStarted()) {
            try {
                if (this.requiresRegistry()) {
                    LocateRegistry.getRegistry(1099);
                }
                Enumeration enumtr = DistributedServersModel.getDistributedServers().elements();
                while (enumtr.hasMoreElements()) {
                    DistributedServer server = (DistributedServer)enumtr.nextElement();
                    server.stopServer();
                }
                DistributedServersModel.setRegistryStarted(false);
                DistributedServersModel.getDistributedServers().removeAllElements();
                this.stopCacheSynchronization();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }

    public static void setRegistryStarted(boolean newRegistryStarted) {
        registryStarted = newRegistryStarted;
    }

    public boolean requiresRegistry() {
        return true;
    }

    public void setup() {
        if (!DistributedServersModel.isRegistryStarted()) {
            try {
                if (this.requiresRegistry()) {
                    LocateRegistry.createRegistry(1099);
                }
                DistributedServersModel.setRegistryStarted(true);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                try {
                    LocateRegistry.getRegistry(1099);
                    DistributedServersModel.setRegistryStarted(true);
                }
                catch (Exception secondTryException) {
                    System.out.println(secondTryException.toString());
                }
            }
        } else {
            try {
                if (this.requiresRegistry()) {
                    LocateRegistry.getRegistry(1099);
                }
                DistributedServersModel.setRegistryStarted(true);
                Enumeration servers = DistributedServersModel.getDistributedServers().elements();
                while (servers.hasMoreElements()) {
                    ((DistributedServer)servers.nextElement()).stopServer();
                }
                DistributedServersModel.getDistributedServers().removeAllElements();
                this.stopCacheSynchronization();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
        DistributedServer server = this.createDistributedServer(this.getSession());
        DistributedServersModel.getDistributedServers().removeAllElements();
        DistributedServersModel.getDistributedServers().addElement(server);
        server.run();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.startCacheSynchronization();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void startCacheSynchronization();

    public abstract void stopCacheSynchronization();
}

