/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.logging;

import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.junit.Assert;

public class LogCategoryHelper {
    public static void testLength() {
        Assert.assertEquals((String)"Logging category length value is incorrect", (long)LogCategory.values().length, (long)LogCategory.length);
    }

    public static void testToValue() {
        for (LogCategory category : LogCategory.values()) {
            String name = category.getName();
            String lower = name.toLowerCase();
            String upper = name.toUpperCase();
            LogCategory categoryFromName = LogCategory.toValue((String)name);
            LogCategory categoryFromLower = LogCategory.toValue((String)lower);
            LogCategory categoryFromUpper = LogCategory.toValue((String)upper);
            Assert.assertEquals((String)("Logging category was not found for " + name), (Object)category, (Object)categoryFromName);
            Assert.assertEquals((String)("Logging category was not found for " + lower), (Object)category, (Object)categoryFromLower);
            Assert.assertEquals((String)("Logging category was not found for " + upper), (Object)category, (Object)categoryFromUpper);
        }
    }

    public static void testGetNameSpace() throws ReflectiveOperationException {
        String namespacePrefix = (String)ReflectionHelper.getPrivateStatic(LogCategory.class, (String)"NAMESPACE_PREFIX");
        for (LogCategory category : LogCategory.values()) {
            String name = category.getName();
            StringBuilder sb = new StringBuilder(namespacePrefix.length() + name.length());
            sb.append(namespacePrefix);
            sb.append(name);
            String nameSpace = sb.toString();
            Assert.assertEquals((String)("Logger name space shall be " + nameSpace), (Object)nameSpace, (Object)category.getNameSpace());
        }
    }
}

