/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.logging;

import org.eclipse.persistence.logging.LogLevel;
import org.junit.Assert;

public class LogLevelHelper {
    public static String logIdToName(int id) {
        return LogLevel.toValue((int)id).getName();
    }

    public static void testLength() {
        Assert.assertEquals((String)"Log level length value is incorrect", (long)LogLevel.values().length, (long)LogLevel.length);
    }

    public static void testToValueString() {
        String[] invalidNames;
        for (LogLevel level : LogLevel.values()) {
            String name = level.getName();
            String lower = name.toLowerCase();
            String upper = name.toUpperCase();
            LogLevel levelFromName = LogLevel.toValue((String)name);
            LogLevel levelFromLower = LogLevel.toValue((String)lower);
            LogLevel levelFromUpper = LogLevel.toValue((String)upper);
            Assert.assertEquals((String)("Log level was not found for name: " + name), (Object)level, (Object)levelFromName);
            Assert.assertEquals((String)("Log level was not found for name: " + lower), (Object)level, (Object)levelFromLower);
            Assert.assertEquals((String)("Log level was not found for name: " + upper), (Object)level, (Object)levelFromUpper);
        }
        for (String invalidName : invalidNames = new String[]{null, "", " " + LogLevel.ALL.getName(), LogLevel.ALL.getName() + " ", "unknown", "something", "AL", "ONFIG", "EVER"}) {
            LogLevel level = LogLevel.toValue((String)invalidName);
            String levelName = level != null ? level.getName() : "null";
            Assert.assertEquals((String)("Log level \"" + levelName + "\" was found for name: " + invalidName), null, (Object)level);
        }
    }

    public static void testToValueInt() {
        int[] invalidIds;
        for (LogLevel level : LogLevel.values()) {
            int id = level.getId();
            LogLevel levelValue = LogLevel.toValue((int)id);
            Assert.assertEquals((String)("Log level was not found for ID: " + id), (Object)level, (Object)levelValue);
        }
        for (int id : invalidIds = new int[]{-2, -1, LogLevel.length, LogLevel.length + 1}) {
            try {
                LogLevel.toValue((int)-1);
                Assert.fail((String)("LogLevel.toValue(" + id + ") shall throw IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static void testToValueIntFallBack() {
        int[] invalidIds;
        for (LogLevel level : LogLevel.values()) {
            int id = level.getId();
            LogLevel levelValue = level == LogLevel.ALL ? LogLevel.toValue((int)id, (LogLevel)LogLevel.OFF) : LogLevel.toValue((int)id, (LogLevel)LogLevel.ALL);
            Assert.assertEquals((String)("Log level was not found for ID: " + id), (Object)level, (Object)levelValue);
        }
        for (int id : invalidIds = new int[]{-2, -1, LogLevel.length, LogLevel.length + 1}) {
            LogLevel level = LogLevel.toValue((int)id, (LogLevel)LogLevel.ALL);
            Assert.assertEquals((String)("Expected log level " + LogLevel.ALL.getName() + " for ID: " + id), (Object)level, (Object)LogLevel.ALL);
        }
    }

    public static void testShouldLogOnLogLevel() {
        for (LogLevel level : LogLevel.values()) {
            for (LogLevel toLog : LogLevel.values()) {
                boolean result = level.shouldLog(toLog);
                if (toLog.getId() >= level.getId()) {
                    Assert.assertEquals((String)("Message with " + toLog.getName() + " level should be logged on level " + level.getName()), (Object)true, (Object)result);
                    continue;
                }
                Assert.assertEquals((String)("Message with " + toLog.getName() + " level should not be logged on level " + level.getName()), (Object)false, (Object)result);
            }
        }
    }

    public static void testShouldLogOnId() {
        for (LogLevel level : LogLevel.values()) {
            for (LogLevel toLog : LogLevel.values()) {
                boolean result = level.shouldLog(toLog.getId());
                if (toLog.getId() >= level.getId()) {
                    Assert.assertEquals((String)("Message with " + toLog.getName() + " level should be logged on level " + level.getName()), (Object)true, (Object)result);
                    continue;
                }
                Assert.assertEquals((String)("Message with " + toLog.getName() + " level should not be logged on level " + level.getName()), (Object)false, (Object)result);
            }
        }
    }
}

