/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nls.japanese;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.nls.japanese.NLSEmployee;

public class NLSMemoryQueryTriggerIndirectionTest
extends AutoVerifyTestCase {
    protected ReadAllQuery queryAll;
    protected Vector allEmployees;
    protected Vector inMemoryResult;

    public NLSMemoryQueryTriggerIndirectionTest() {
        this.setDescription("[NLS_Japanese] Test memory query trigger indirection option");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.allEmployees = (Vector)this.getSession().executeQuery("memoryQueryTriggerIndirectionQuery", NLSEmployee.class);
        this.queryAll = (ReadAllQuery)this.getSession().getDescriptor(NLSEmployee.class).getQueryManager().getQuery("memoryQueryTriggerIndirectionQuery");
    }

    public void test() {
        ReadAllQuery queryAllCopy = (ReadAllQuery)this.queryAll.clone();
        queryAllCopy.checkCacheOnly();
        queryAllCopy.setSelectionCriteria(new ExpressionBuilder().get("address").get("city").notEqual((Object)"\u3059\u30db\u30bb\u30c8\u30c4\u30aa\u30a2\u30b7"));
        this.inMemoryResult = (Vector)this.getSession().executeQuery((DatabaseQuery)queryAllCopy);
    }

    public void verify() {
        if (this.inMemoryResult.size() != this.allEmployees.size() - 1) {
            throw new TestErrorException("In Memory Query did not return all objects.  Auto-indirection triggering is not working");
        }
    }
}

