/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.SelfUpdatable;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingPolicyDeleteRowTest;

public class OptimisticLockingPolicyChangedValueUpdateTest
extends OptimisticLockingPolicyDeleteRowTest {
    public OptimisticLockingPolicyChangedValueUpdateTest(Class<?> aClass) {
        super(aClass);
        this.setDescription("This test verifies that an optimistic lock exception is thrown on update when the write lock is changed");
    }

    @Override
    protected void verify() {
        boolean exceptionCaught = false;
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            SelfUpdatable object = (SelfUpdatable)uow.registerObject(this.originalObject);
            object.update();
            uow.commit();
        }
        catch (OptimisticLockException exception) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new TestErrorException("No Optimistic Lock exception was thrown");
        }
    }
}

