/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance;

import java.sql.Date;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.interfaces.InterfaceHashtableProject;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.models.performance.toplink.EmployeeSystem;
import org.eclipse.persistence.testing.models.performance.toplink.PhoneNumber;
import org.eclipse.persistence.testing.tests.performance.reading.DeferredvsWriteLockTest;
import org.eclipse.persistence.testing.tests.performance.reading.EmulatedReadObjectPreparedvsDynamicTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllComplexvsConformTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllFirstResultVsRownumFilteringTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllMaxRowsFirstResultVsRownumFilteringTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllMaxRowsVsRownumFilteringTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllStreamvsCursorSizeTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllStreamvsCursorTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsBatch1mTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsBatch21mTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsConformNewUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsConformTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsCursorTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsInMemoryTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadAllvsJoinBatchTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectCachevsDatabaseTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectPreparedvsDynamicTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectStaticvsDynamicTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectvsJoinTest;
import org.eclipse.persistence.testing.tests.performance.reading.ReadObjectvsParameterizedSQLTest;
import org.eclipse.persistence.testing.tests.performance.writing.InsertBatchUnitOfWorkComparisonTest;

public class PerformanceComparisonModel
extends TestModel {
    public PerformanceComparisonModel() {
        this.setDescription("Performance tests that compare/verify the performance of two or more ways of doing something.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getReadingTestSuite());
        this.addTest((Test)this.getWritingTestSuite());
    }

    public TestSuite getReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ReadingTestSuite");
        suite.setDescription("This suite tests reading performance.");
        suite.addTest((Test)new DeferredvsWriteLockTest());
        suite.addTest((Test)new ReadObjectStaticvsDynamicTest());
        suite.addTest((Test)new ReadObjectCachevsDatabaseTest());
        suite.addTest((Test)new ReadObjectvsJoinTest());
        suite.addTest((Test)new ReadAllvsJoinBatchTest());
        suite.addTest((Test)new ReadAllvsBatch1mTest());
        suite.addTest((Test)new ReadAllvsBatch21mTest());
        suite.addTest((Test)new ReadAllvsInMemoryTest());
        suite.addTest((Test)new ReadAllvsConformTest());
        suite.addTest((Test)new ReadAllComplexvsConformTest());
        suite.addTest((Test)new ReadAllvsConformNewUnitOfWorkTest());
        suite.addTest((Test)new ReadObjectvsParameterizedSQLTest());
        suite.addTest((Test)new ReadAllvsCursorTest());
        suite.addTest((Test)new ReadAllStreamvsCursorTest());
        suite.addTest((Test)new ReadAllMaxRowsFirstResultVsRownumFilteringTest());
        suite.addTest((Test)new ReadAllMaxRowsVsRownumFilteringTest());
        suite.addTest((Test)new ReadAllFirstResultVsRownumFilteringTest());
        suite.addTest((Test)new ReadAllStreamvsCursorSizeTest());
        suite.addTest((Test)new ReadObjectPreparedvsDynamicTest());
        suite.addTest((Test)new EmulatedReadObjectPreparedvsDynamicTest());
        return suite;
    }

    public TestSuite getWritingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("WritingTestSuite");
        suite.setDescription("This suite tests uow/writing performance.");
        suite.addTest((Test)new InsertBatchUnitOfWorkComparisonTest());
        return suite;
    }

    public void setup() {
        for (int j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j);
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            this.getDatabaseSession().insertObject((Object)empInsert);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getDatabaseSession().addDescriptors((Project)new InterfaceHashtableProject());
    }
}

