/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.MethodBaseQueryRedirector;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RedirectorOnDescriptorTest
extends TestCase {
    protected static boolean redirectedReadObject = false;
    protected static boolean redirectedReadAll = false;
    protected static boolean redirectedDeleteObject = false;
    protected static boolean redirectedUpdate = false;
    protected static boolean redirectedInsert = false;
    protected ReadObjectQuery readObjectQuery = null;
    protected ReadAllQuery readAllQuery = null;
    protected DeleteObjectQuery deleteObjectQuery = null;
    protected InsertObjectQuery insertQuery = null;
    protected UpdateObjectQuery updateQuery = null;
    protected ClassDescriptor descriptor = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
        this.descriptor = (ClassDescriptor)this.getSession().getProject().getDescriptors().get(Employee.class);
        this.readObjectQuery = this.descriptor.getQueryManager().getReadObjectQuery();
        MethodBaseQueryRedirector redirector = new MethodBaseQueryRedirector(RedirectorOnDescriptorTest.class, "readObject");
        ReadObjectQuery roq = new ReadObjectQuery(this.descriptor.getJavaClass());
        roq.setRedirector((QueryRedirector)redirector);
        this.descriptor.getQueryManager().setReadObjectQuery(roq);
        this.readAllQuery = this.descriptor.getQueryManager().getReadAllQuery();
        redirector = new MethodBaseQueryRedirector(RedirectorOnDescriptorTest.class, "readAll");
        ReadAllQuery raq = new ReadAllQuery(this.descriptor.getJavaClass());
        raq.setRedirector((QueryRedirector)redirector);
        this.descriptor.getQueryManager().setReadAllQuery(raq);
        this.deleteObjectQuery = this.descriptor.getQueryManager().getDeleteQuery();
        redirector = new MethodBaseQueryRedirector(RedirectorOnDescriptorTest.class, "deleteObject");
        DeleteObjectQuery doq = new DeleteObjectQuery();
        doq.setRedirector((QueryRedirector)redirector);
        this.descriptor.getQueryManager().setDeleteQuery(doq);
        this.insertQuery = this.descriptor.getQueryManager().getInsertQuery();
        redirector = new MethodBaseQueryRedirector(RedirectorOnDescriptorTest.class, "insertObject");
        InsertObjectQuery ioq = new InsertObjectQuery();
        ioq.setRedirector((QueryRedirector)redirector);
        this.descriptor.getQueryManager().setInsertQuery(ioq);
        this.updateQuery = this.descriptor.getQueryManager().getUpdateQuery();
        redirector = new MethodBaseQueryRedirector(RedirectorOnDescriptorTest.class, "updateObject");
        UpdateObjectQuery uoq = new UpdateObjectQuery();
        uoq.setRedirector((QueryRedirector)redirector);
        this.descriptor.getQueryManager().setUpdateQuery(uoq);
    }

    public void test() {
        this.getSession().readAllObjects(Employee.class);
        this.getSession().getIdentityMapAccessor().initializeIdentityMap(Employee.class);
        Employee employee = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("id").equal(99));
        employee = (Employee)this.getSession().readObject(Employee.class);
        try {
            this.getAbstractSession().deleteObject((Object)employee);
        }
        catch (DatabaseException exc) {
            redirectedDeleteObject = false;
        }
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        employee = (Employee)uow.readObject(Employee.class);
        employee.setFirstName(employee.getFirstName() + "-changed");
        employee = new Employee();
        employee.setFirstName("Paul");
        employee.setLastName("Sheldon");
        uow.registerObject((Object)employee);
        uow.commit();
    }

    public void verify() {
        if (!redirectedReadObject) {
            throw new TestErrorException("ReadObjectQuery was not properly redirected when redirection was set on the Descriptor.");
        }
        if (!redirectedReadAll) {
            throw new TestErrorException("ReadAllQuery was not properly redirected when redirection was set on the Descriptor.");
        }
        if (!redirectedDeleteObject) {
            throw new TestErrorException("DeleteQuery was not properly redirected when redirection was set on the Descriptor.");
        }
        if (!redirectedUpdate) {
            throw new TestErrorException("UpdateObjectQuery was not properly redirected when redirection was set on the Descriptor.");
        }
        if (!redirectedInsert) {
            throw new TestErrorException("InsertObjectQuery was not properly redirected when redirection was set on the Descriptor.");
        }
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.descriptor.getQueryManager().setReadObjectQuery(this.readObjectQuery);
        this.descriptor.getQueryManager().setReadAllQuery(this.readAllQuery);
        this.descriptor.getQueryManager().setDeleteQuery(this.deleteObjectQuery);
        this.descriptor.getQueryManager().setInsertQuery(this.insertQuery);
        this.descriptor.getQueryManager().setUpdateQuery(this.updateQuery);
        boolean redirectedReadObject = false;
        boolean redirectedReadAll = false;
        boolean redirectedDeleteObject = false;
        boolean redirectedInsert = false;
        boolean redirectedUpdate = false;
    }

    public static Object deleteObject(DatabaseQuery query, DataRecord row, Session session) {
        redirectedDeleteObject = true;
        return null;
    }

    public static Object insertObject(DatabaseQuery query, DataRecord row, Session session) {
        redirectedInsert = true;
        return null;
    }

    public static Object readAll(DatabaseQuery query, DataRecord row, Session session) {
        redirectedReadAll = true;
        return null;
    }

    public static Object readObject(DatabaseQuery query, DataRecord row, Session session) {
        redirectedReadObject = true;
        return null;
    }

    public static Object updateObject(DatabaseQuery query, DataRecord row, Session session) {
        redirectedUpdate = true;
        return null;
    }
}

