/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class CacheHitTest
extends TestCase {
    protected Object originalObject;
    protected Object objectToRead;
    protected Object objectRead;
    protected SessionLog oldLog;
    protected StringWriter tempStream;

    public CacheHitTest() {
        this.setDescription("This test verifies that selecting with primary key obtains a cache hit.");
    }

    public CacheHitTest(Object originalObject) {
        this();
        this.setName(this.getName() + "(" + originalObject.getClass() + ")");
        this.originalObject = originalObject;
    }

    protected void loadObjectIntoCache() {
        this.objectToRead = this.getSession().readObject(this.originalObject);
    }

    protected Object readObject() {
        return this.getSession().readObject(this.originalObject);
    }

    public void reset() {
        if (this.oldLog != null) {
            this.getSession().setSessionLog(this.oldLog);
        }
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.loadObjectIntoCache();
        this.oldLog = this.getSession().getSessionLog();
        this.tempStream = new StringWriter();
        DefaultSessionLog newLog = new DefaultSessionLog();
        newLog.setWriter((Writer)this.tempStream);
        newLog.setLevel(3);
        this.getSession().setSessionLog((SessionLog)newLog);
    }

    public void test() {
        this.objectRead = this.readObject();
    }

    protected void verify() {
        if (this.objectRead != this.objectToRead) {
            throw new TestErrorException("Expecting: " + this.objectToRead + " retrieved: " + this.objectRead);
        }
        if (this.tempStream.toString().length() > 0) {
            throw new TestErrorException("The read went to the database, but should not have, '" + this.tempStream.toString() + "'");
        }
    }
}

