/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.inmemory;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkConformNewObjectTest
extends AutoVerifyTestCase {
    public UnitOfWorkConformNewObjectTest() {
        this.setDescription("Test that the query maintains order for non changed objects.");
    }

    public void test() {
        String lastName = "UOWConformNewObjectTest";
        Employee emp1 = new Employee();
        emp1.setFirstName("1");
        emp1.setLastName(lastName);
        Employee emp2 = new Employee();
        emp2.setFirstName("2");
        emp2.setLastName(lastName);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.setShouldNewObjectsBeCached(true);
        uow.registerNewObject((Object)emp1);
        uow.registerNewObject((Object)emp2);
        uow.assignSequenceNumber((Object)emp1);
        Object errorMsg = "";
        ReadAllQuery queryReadAll = new ReadAllQuery();
        queryReadAll.setReferenceClass(Employee.class);
        queryReadAll.conformResultsInUnitOfWork();
        Vector employees = (Vector)uow.executeQuery((DatabaseQuery)queryReadAll);
        Object localErrorMsg = "";
        if (!employees.contains(emp1)) {
            localErrorMsg = (String)localErrorMsg + "emp1, ";
        }
        if (!employees.contains(emp2)) {
            localErrorMsg = (String)localErrorMsg + "emp2";
        }
        if (((String)localErrorMsg).length() > 0) {
            errorMsg = (String)errorMsg + "ReadAll: " + (String)errorMsg + "; ";
        }
        ReadAllQuery queryReadAllByLastName = new ReadAllQuery();
        queryReadAllByLastName.setReferenceClass(Employee.class);
        queryReadAllByLastName.conformResultsInUnitOfWork();
        ExpressionBuilder builder = queryReadAllByLastName.getExpressionBuilder();
        queryReadAllByLastName.setSelectionCriteria(builder.get("lastName").equal((Object)lastName));
        Vector employeesByLastName = (Vector)uow.executeQuery((DatabaseQuery)queryReadAllByLastName);
        localErrorMsg = "";
        if (!employeesByLastName.contains(emp1)) {
            localErrorMsg = (String)localErrorMsg + "emp1, ";
        }
        if (!employeesByLastName.contains(emp2)) {
            localErrorMsg = (String)localErrorMsg + "emp2";
        }
        if (((String)localErrorMsg).length() > 0) {
            errorMsg = (String)errorMsg + "ReadAllByLastName: " + (String)errorMsg + "; ";
        }
        ReadObjectQuery queryReadObject_1 = new ReadObjectQuery();
        queryReadObject_1.setReferenceClass(Employee.class);
        queryReadObject_1.conformResultsInUnitOfWork();
        builder = queryReadObject_1.getExpressionBuilder();
        queryReadObject_1.setSelectionCriteria(builder.get("lastName").equal((Object)lastName).and(builder.get("firstName").equal((Object)"1")));
        if (emp1 != uow.executeQuery((DatabaseQuery)queryReadObject_1)) {
            errorMsg = (String)errorMsg + "ReadObject_1: emp1; ";
        }
        ReadObjectQuery queryReadObject_2 = new ReadObjectQuery();
        queryReadObject_2.setReferenceClass(Employee.class);
        queryReadObject_2.conformResultsInUnitOfWork();
        builder = queryReadObject_2.getExpressionBuilder();
        queryReadObject_2.setSelectionCriteria(builder.get("lastName").equal((Object)lastName).and(builder.get("firstName").equal((Object)"2")));
        if (emp2 != uow.executeQuery((DatabaseQuery)queryReadObject_2)) {
            errorMsg = (String)errorMsg + "ReadObject_2: emp2; ";
        }
        ReadObjectQuery queryReadObject_1_ByObject = new ReadObjectQuery();
        queryReadObject_1_ByObject.setReferenceClass(Employee.class);
        queryReadObject_1_ByObject.conformResultsInUnitOfWork();
        queryReadObject_1_ByObject.setSelectionObject((Object)emp1);
        Employee result = (Employee)uow.executeQuery((DatabaseQuery)queryReadObject_1_ByObject);
        if (emp1 != result) {
            errorMsg = (String)errorMsg + "queryReadObject_1_ByObject: emp1; ";
        }
        ReadObjectQuery queryReadObject_1_ByKey = new ReadObjectQuery();
        queryReadObject_1_ByKey.setReferenceClass(Employee.class);
        queryReadObject_1_ByKey.conformResultsInUnitOfWork();
        queryReadObject_1_ByKey.setSelectionId((Object)emp1.getId());
        result = (Employee)uow.executeQuery((DatabaseQuery)queryReadObject_1_ByKey);
        if (emp1 != result) {
            errorMsg = (String)errorMsg + "queryReadObject_1_ByKey: emp1; ";
        }
        uow.release();
        if (((String)errorMsg).length() > 0) {
            errorMsg = "The following objects were not found: " + (String)errorMsg;
            throw new TestErrorException((String)errorMsg);
        }
    }
}

