/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.TestCase;

public class SessionManagerGetMultipleSessionsTest
extends TestCase {
    public SessionManagerGetMultipleSessionsTest() {
        this.setDescription("Tests bug#5685604, ensuring that multiple sessions.xml files can be loaded.");
    }

    public void test() {
        SessionManager.getManager().getSessions().remove("EmployeeSession");
        SessionManager.getManager().getSessions().remove("ServerSession");
        XMLSessionConfigLoader employeeLoader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSession.xml");
        employeeLoader.setSessionName("EmployeeSession");
        employeeLoader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        XMLSessionConfigLoader serverLoader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaServerSession.xml");
        serverLoader.setSessionName("ServerSession");
        serverLoader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        serverLoader.setShouldLogin(false);
        AbstractSession session1 = SessionManager.getManager().getSession(employeeLoader);
        AbstractSession session2 = SessionManager.getManager().getSession(serverLoader);
        AbstractSession session3 = SessionManager.getManager().getSession(employeeLoader);
        if (session1 != session3 || !session1.isConnected()) {
            this.throwError("SessionManager corrupted old sessions when loading new sessions.xml.");
        }
    }

    public void reset() {
        SessionManager.getManager().destroySession("EmployeeSession");
        SessionManager.getManager().destroySession("ServerSession");
    }
}

