/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.simultaneous;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.ui.SynchronizedTestExecutor;
import org.eclipse.persistence.testing.framework.ui.SynchronizedTester;
import org.eclipse.persistence.testing.tests.simultaneous.TestExecutorWithClientSession;

public class MultithreadTestCase
extends AutoVerifyTestCase {
    protected TestCase[] test;
    protected int numberOfTests;
    protected boolean useSequenceConnectionPool = false;
    protected TestEventListenerImpl[] testExecutorListener;
    protected TestExecutorWithClientSession[] testExecutorWithClientSession;
    protected SynchronizedTestExecutor[] testThread;
    protected SynchronizedTesterImpl[] testThreadListener;
    protected Hashtable allowedExceptions;
    private Session originalSession;

    protected MultithreadTestCase() {
        this.setDescription("Runs several tests simultaneously");
        this.allowedExceptions = new Hashtable();
        this.addAllowedException("org.eclipse.persistence.exceptions.OptimisticLockException");
    }

    public MultithreadTestCase(Vector test) {
        this();
        this.setTests(test);
    }

    public boolean addAllowedException(String exceptionClassName) {
        try {
            this.allowedExceptions.put(exceptionClassName, Class.forName(exceptionClassName));
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void removeAllowedException(String exceptionClassName) {
        this.allowedExceptions.remove(exceptionClassName);
    }

    public void setTests(Vector test) {
        if (test != null && !test.isEmpty()) {
            this.numberOfTests = test.size();
            this.test = new TestCase[this.numberOfTests];
            test.toArray(this.test);
            this.testExecutorWithClientSession = new TestExecutorWithClientSession[this.numberOfTests];
            this.testExecutorListener = new TestEventListenerImpl[this.numberOfTests];
            this.testThread = new SynchronizedTestExecutor[this.numberOfTests];
            this.testThreadListener = new SynchronizedTesterImpl[this.numberOfTests];
        }
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.setupSession();
        for (int i = 0; i < this.numberOfTests; ++i) {
            this.test[i].setContainer((TestEntity)this);
            this.testExecutorWithClientSession[i] = new TestExecutorWithClientSession(this.getExecutor());
            this.testExecutorListener[i] = new TestEventListenerImpl();
            this.testExecutorWithClientSession[i].setListener(this.testExecutorListener[i]);
            this.testThreadListener[i] = new SynchronizedTesterImpl();
            this.test[i].setExecutor((TestExecutor)this.testExecutorWithClientSession[i]);
            this.testThread[i] = new SynchronizedTestExecutor((TestExecutor)this.testExecutorWithClientSession[i], (Test)this.test[i], (SynchronizedTester)this.testThreadListener[i]);
            this.testThread[i].setName("Test Thread " + i);
        }
    }

    protected void setupSession() {
        this.originalSession = this.getSession();
        Session newSession = MultithreadTestCase.setupNewSession(this.originalSession, this.useSequenceConnectionPool);
        this.getExecutor().setSession(newSession);
    }

    public static Session setupNewSession(Session originalSession, boolean useSequenceConnectionPool) {
        if (originalSession.isServerSession()) {
            return originalSession;
        }
        if (originalSession.isDatabaseSession()) {
            DatabaseSession databaseSession = (DatabaseSession)originalSession;
            DatabaseLogin login = (DatabaseLogin)databaseSession.getLogin().clone();
            databaseSession.getSequencingControl().initializePreallocated();
            ServerSession serverSession = new ServerSession((Login)login, 5, 5);
            serverSession.setSessionLog(databaseSession.getSessionLog());
            if (useSequenceConnectionPool) {
                serverSession.getSequencingControl().setShouldUseSeparateConnection(true);
            } else {
                serverSession.getSequencingControl().setShouldUseSeparateConnection(false);
            }
            serverSession.login();
            Vector descriptors = new Vector();
            Iterator iterator = databaseSession.getDescriptors().values().iterator();
            while (iterator.hasNext()) {
                descriptors.addElement(iterator.next());
            }
            serverSession.addDescriptors(descriptors);
            return serverSession;
        }
        if (originalSession.isClientSession()) {
            ClientSession clientSession = (ClientSession)originalSession;
            ServerSession serverSession = clientSession.getParent();
            return serverSession;
        }
        return null;
    }

    protected void test() {
        int numberOfCompletedTests;
        for (int i = 0; i < this.numberOfTests; ++i) {
            this.testThread[i].start();
        }
        do {
            numberOfCompletedTests = 0;
            for (int i = 0; i < this.numberOfTests; ++i) {
                if (!this.testThreadListener[i].isFinished()) continue;
                ++numberOfCompletedTests;
            }
        } while (numberOfCompletedTests < this.numberOfTests);
    }

    protected void verify() {
        EclipseLinkException exception = null;
        for (int i = 0; i < this.numberOfTests && exception == null; ++i) {
            exception = this.test[i].getTestResult().getException();
            if (exception == null) continue;
            Enumeration enumtr = this.allowedExceptions.elements();
            while (enumtr.hasMoreElements() && exception != null) {
                if (!((Class)enumtr.nextElement()).isInstance((Object)exception)) continue;
                exception = null;
            }
            if (exception == null) continue;
            this.setTestException(exception);
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.originalSession != null) {
            this.resetSession();
        }
    }

    protected void resetSession() {
        MultithreadTestCase.resetOriginalSession(this.originalSession, this.getSession());
        this.getExecutor().setSession(this.originalSession);
        this.originalSession = null;
    }

    public static void resetOriginalSession(Session originalSession, Session newSession) {
        if (originalSession.isServerSession()) {
            return;
        }
        if (originalSession.isDatabaseSession()) {
            ((DatabaseSession)newSession).logout();
            DatabaseSession databaseSession = (DatabaseSession)originalSession;
            databaseSession.logout();
            databaseSession.login();
        }
    }

    public void logResult(Writer log) {
        super.logResult(log);
        for (int i = 0; i < this.numberOfTests; ++i) {
            try {
                log.write(Helper.cr() + Helper.getTabs((int)(this.getNestedCounter() + 1)) + "Test Thread " + i);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.test[i].logResult(log);
        }
    }

    public void useSequenceConnectionPool() {
        this.useSequenceConnectionPool = true;
    }

    protected class TestEventListenerImpl
    implements TestListener {
        public static final int INITIAL = 0;
        public static final int STARTED = 1;
        public static final int FINISHED = 2;
        private int state = 0;

        private TestEventListenerImpl() {
        }

        public void addError(Test test, Throwable error) {
        }

        public void addFailure(Test test, AssertionFailedError error) {
        }

        public void endTest(Test test) {
            this.state = 2;
        }

        public void startTest(Test test) {
            this.state = 1;
        }

        public boolean isStarted() {
            return this.state == 1;
        }

        public boolean isFinished() {
            return this.state == 2;
        }
    }

    protected class SynchronizedTesterImpl
    implements SynchronizedTester {
        public static final int INITIAL = 0;
        public static final int FINISHED = 1;
        private int state = 0;
        private Throwable exception;

        private SynchronizedTesterImpl() {
        }

        public void finishedTest() {
            this.state = 1;
        }

        public void notifyException(Throwable exception) {
            this.exception = exception;
        }

        public boolean isFinished() {
            return this.state == 1;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

