/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.types.TypeTester;
import org.eclipse.persistence.testing.tests.types.WriteTypeObjectTest;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class NumericTester
extends TypeTester {
    public int intValue;
    public Integer integerClassValue;
    public float floatValue;
    public Float floatClassValue;
    public long longValue;
    public Long longClassValue;
    public double doubleValue;
    public Double doubleClassValue;
    public short shortValue;
    public Short shortClassValue;
    public byte byteValue;
    public Byte byteClassValue;
    public BigInteger bigIntegerValue;
    public BigDecimal bigDecimalValue;

    public NumericTester() {
        super("ZERO");
        this.intValue = 0;
        this.integerClassValue = 0;
        this.floatValue = 0.0f;
        this.floatClassValue = Float.valueOf(0.0f);
        this.longValue = 0L;
        this.longClassValue = 0L;
        this.doubleValue = 0.0;
        this.doubleClassValue = 0.0;
        this.shortValue = 0;
        this.shortClassValue = 0;
        this.byteValue = 0;
        this.byteClassValue = 0;
        this.bigIntegerValue = new BigInteger("0");
        this.bigDecimalValue = new BigDecimal(this.bigIntegerValue, 19);
    }

    public NumericTester(String name) {
        super(name);
    }

    private static void addBigDecimalField(TableDefinition definition, DatabasePlatform platform) {
        FieldTypeDefinition fieldDef = (FieldTypeDefinition)platform.getFieldTypes().get(BigDecimal.class);
        if (fieldDef.isSizeAllowed()) {
            int scale = fieldDef.getMaxPrecision() / 2;
            definition.addField("BIGDECF", Float.class, fieldDef.getMaxPrecision(), scale);
        } else {
            definition.addField("BIGDECF", Float.class);
        }
    }

    private static void addDoubleField(TableDefinition definition, DatabasePlatform platform) {
        FieldTypeDefinition fieldDef = (FieldTypeDefinition)platform.getFieldTypes().get(Double.class);
        if (fieldDef.isSizeAllowed()) {
            int scale = fieldDef.getMaxPrecision() / 2;
            definition.addField("DOUBLEF", Float.class, fieldDef.getMaxPrecision(), scale);
            definition.addField("DOUBLEFC", Float.class, fieldDef.getMaxPrecision(), scale);
        } else {
            definition.addField("DOUBLEF", Float.class);
            definition.addField("DOUBLEFC", Float.class);
        }
    }

    private static void addFloatField(TableDefinition definition, DatabasePlatform platform) {
        FieldTypeDefinition fieldDef = (FieldTypeDefinition)platform.getFieldTypes().get(Float.class);
        if (fieldDef.isSizeAllowed()) {
            int scale = fieldDef.getMaxPrecision() / 2;
            definition.addField("FLOATF", Float.class, fieldDef.getMaxPrecision(), scale);
            definition.addField("FLOATFC", Float.class, fieldDef.getMaxPrecision(), scale);
        } else {
            definition.addField("FLOATF", Float.class);
            definition.addField("FLOATFC", Float.class);
        }
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(NumericTester.class);
        descriptor.setTableName("NUMBERS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("intValue", "INTF");
        descriptor.addDirectMapping("integerClassValue", "INTFC");
        descriptor.addDirectMapping("floatValue", "FLOATF");
        descriptor.addDirectMapping("floatClassValue", "FLOATFC");
        descriptor.addDirectMapping("longValue", "LONGF");
        descriptor.addDirectMapping("longClassValue", "LONGFC");
        descriptor.addDirectMapping("doubleValue", "DOUBLEF");
        descriptor.addDirectMapping("doubleClassValue", "DOUBLEFC");
        descriptor.addDirectMapping("shortValue", "SHORTF");
        descriptor.addDirectMapping("shortClassValue", "SHORTFC");
        descriptor.addDirectMapping("byteValue", "BYTEF");
        descriptor.addDirectMapping("byteClassValue", "BYTEFC");
        descriptor.addDirectMapping("bigIntegerValue", "BIGINTF");
        descriptor.addDirectMapping("bigDecimalValue", "BIGDECF");
        return descriptor;
    }

    public static RelationalDescriptor descriptorWithAccessors() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(NumericTester.class);
        descriptor.setTableName("NUMBERS");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("testName", "getTestName", "setTestName", "NAME");
        descriptor.addDirectMapping("intValue", "getIntegerValue", "setIntegerValue", "INTF");
        descriptor.addDirectMapping("integerClassValue", "getIntegerClassValue", "setIntegerClassValue", "INTFC");
        descriptor.addDirectMapping("floatValue", "getFloatValue", "setFloatValue", "FLOATF");
        descriptor.addDirectMapping("floatClassValue", "getFloatClassValue", "setFloatClassValue", "FLOATFC");
        descriptor.addDirectMapping("longValue", "getLongValue", "setLongValue", "LONGF");
        descriptor.addDirectMapping("longClassValue", "getLongClassValue", "setLongClassValue", "LONGFC");
        descriptor.addDirectMapping("doubleValue", "getDoubleValue", "setDoubleValue", "DOUBLEF");
        descriptor.addDirectMapping("doubleClassValue", "getDoubleClassValue", "setDoubleClassValue", "DOUBLEFC");
        descriptor.addDirectMapping("shortValue", "getShortValue", "setShortValue", "SHORTF");
        descriptor.addDirectMapping("shortClassValue", "getShortClassValue", "setShortClassValue", "SHORTFC");
        descriptor.addDirectMapping("byteValue", "getByteValue", "setByteValue", "BYTEF");
        descriptor.addDirectMapping("byteClassValue", "getByteClassValue", "setByteClassValue", "BYTEFC");
        descriptor.addDirectMapping("bigIntegerValue", "getBigIntegerValue", "setBigIntegerValue", "BIGINTF");
        descriptor.addDirectMapping("bigDecimalValue", "getBigDecimalValue", "setBigDecimalValue", "BIGDECF");
        return descriptor;
    }

    public BigDecimal getBigDecimalValue() {
        return this.bigDecimalValue;
    }

    public BigInteger getBigIntegerValue() {
        return this.bigIntegerValue;
    }

    public Byte getByteClassValue() {
        return this.byteClassValue;
    }

    public byte getByteValue() {
        return this.byteValue;
    }

    public Double getDoubleClassValue() {
        return this.doubleClassValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public Float getFloatClassValue() {
        return this.floatClassValue;
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public Integer getIntegerClassValue() {
        return this.integerClassValue;
    }

    public int getIntegerValue() {
        return this.intValue;
    }

    public Long getLongClassValue() {
        return this.longClassValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public Short getShortClassValue() {
        return this.shortClassValue;
    }

    public short getShortValue() {
        return this.shortValue;
    }

    protected static NumericTester maximumValues(DatabasePlatform platform) {
        NumericTester tester = new NumericTester("MAXIMUM");
        Hashtable maximums = platform.maximumNumericValues();
        tester.setIntegerValue((Integer)maximums.get(Integer.class));
        tester.setIntegerClassValue((Integer)maximums.get(Integer.class));
        tester.setFloatValue(((Float)maximums.get(Float.class)).floatValue());
        tester.setFloatClassValue((Float)maximums.get(Float.class));
        tester.setLongValue((Long)maximums.get(Long.class));
        tester.setLongClassValue((Long)maximums.get(Long.class));
        tester.setDoubleValue((Double)maximums.get(Double.class));
        tester.setDoubleClassValue((Double)maximums.get(Double.class));
        tester.setShortValue((Short)maximums.get(Short.class));
        tester.setShortClassValue((Short)maximums.get(Short.class));
        tester.setByteValue((Byte)maximums.get(Byte.class));
        tester.setByteClassValue((Byte)maximums.get(Byte.class));
        tester.setBigIntegerValue((BigInteger)maximums.get(BigInteger.class));
        tester.setBigDecimalValue((BigDecimal)maximums.get(BigDecimal.class));
        return tester;
    }

    protected static NumericTester minimumValues(DatabasePlatform platform) {
        NumericTester tester = new NumericTester("MINIMUM");
        Hashtable minimums = platform.minimumNumericValues();
        tester.setIntegerValue((Integer)minimums.get(Integer.class));
        tester.setIntegerClassValue((Integer)minimums.get(Integer.class));
        tester.setFloatValue(((Float)minimums.get(Float.class)).floatValue());
        tester.setFloatClassValue((Float)minimums.get(Float.class));
        tester.setLongValue((Long)minimums.get(Long.class));
        tester.setLongClassValue((Long)minimums.get(Long.class));
        tester.setDoubleValue((Double)minimums.get(Double.class));
        tester.setDoubleClassValue((Double)minimums.get(Double.class));
        tester.setShortValue((Short)minimums.get(Short.class));
        tester.setShortClassValue((Short)minimums.get(Short.class));
        tester.setByteValue((Byte)minimums.get(Byte.class));
        tester.setByteClassValue((Byte)minimums.get(Byte.class));
        tester.setBigIntegerValue((BigInteger)minimums.get(BigInteger.class));
        tester.setBigDecimalValue((BigDecimal)minimums.get(BigDecimal.class));
        return tester;
    }

    public void setBigDecimalValue(BigDecimal aBigDecimal) {
        this.bigDecimalValue = aBigDecimal;
    }

    public void setBigIntegerValue(BigInteger aBigInteger) {
        this.bigIntegerValue = aBigInteger;
    }

    public void setByteClassValue(byte aByte) {
        this.byteClassValue = aByte;
    }

    public void setByteClassValue(Byte aByte) {
        this.byteClassValue = aByte;
    }

    public void setByteValue(byte aByte) {
        this.byteValue = aByte;
    }

    public void setDoubleClassValue(double aDouble) {
        this.doubleClassValue = aDouble;
    }

    public void setDoubleClassValue(Double aDouble) {
        this.doubleClassValue = aDouble;
    }

    public void setDoubleValue(double aDouble) {
        this.doubleValue = aDouble;
    }

    public void setFloatClassValue(float aFloat) {
        this.floatClassValue = Float.valueOf(aFloat);
    }

    public void setFloatClassValue(Float aFloat) {
        this.floatClassValue = aFloat;
    }

    public void setFloatValue(float newFloat) {
        this.floatValue = newFloat;
    }

    public void setIntegerClassValue(int anInteger) {
        this.integerClassValue = anInteger;
    }

    public void setIntegerClassValue(Integer anInteger) {
        this.integerClassValue = anInteger;
    }

    public void setIntegerValue(int anInt) {
        this.intValue = anInt;
    }

    public void setLongClassValue(long aLong) {
        this.longClassValue = aLong;
    }

    public void setLongClassValue(Long aLong) {
        this.longClassValue = aLong;
    }

    public void setLongValue(long aLong) {
        this.longValue = aLong;
    }

    public void setShortClassValue(Short aShort) {
        this.shortClassValue = aShort;
    }

    public void setShortClassValue(short aShort) {
        this.shortClassValue = aShort;
    }

    public void setShortValue(short aShort) {
        this.shortValue = aShort;
    }

    public static TableDefinition tableDefinition(Session session) {
        org.eclipse.persistence.platform.database.DatabasePlatform platform = session.getPlatform();
        TableDefinition definition = TypeTester.tableDefinition();
        definition.setName("NUMBERS");
        definition.addField("INTF", Integer.class);
        definition.addField("INTFC", Integer.class);
        definition.addField("LONGF", Long.class);
        definition.addField("LONGFC", Long.class);
        definition.addField("SHORTF", Short.class);
        definition.addField("SHORTFC", Short.class);
        definition.addField("BYTEF", Byte.class);
        definition.addField("BYTEFC", Byte.class);
        NumericTester.addFloatField(definition, (DatabasePlatform)platform);
        NumericTester.addDoubleField(definition, (DatabasePlatform)platform);
        definition.addField("BIGINTF", BigInteger.class);
        NumericTester.addBigDecimalField(definition, (DatabasePlatform)platform);
        return definition;
    }

    public static Vector testInstances(Session session) {
        Vector<NumericTester> tests = new Vector<NumericTester>(3);
        tests.addElement(NumericTester.zeroValues((DatabasePlatform)session.getPlatform()));
        tests.addElement(NumericTester.minimumValues((DatabasePlatform)session.getPlatform()));
        tests.addElement(NumericTester.maximumValues((DatabasePlatform)session.getPlatform()));
        return tests;
    }

    public String toString() {
        return "NumericTester(" + this.getTestName() + ")";
    }

    @Override
    protected void verify(WriteTypeObjectTest testCase) throws TestException {
        if (this.getTestName().equals("MINIMUM") || this.getTestName().equals("MAXIMUM")) {
            throw new TestWarningException("MINIMUM and MAXIMUM tests fail on several platforms due to precision loss.");
        }
        try {
            super.verify(testCase);
        }
        catch (TestException exception) {
            if (testCase.getSession().getLogin().isJDBCODBCBridge()) {
                throw new TestWarningException("This error occurred because driver data optimization is used and JDBC-ODBC looses precision on numerics over 15 digits.");
            }
            throw exception;
        }
    }

    protected static NumericTester zeroValues(DatabasePlatform platform) {
        NumericTester tester = new NumericTester("ZERO");
        tester.setIntegerValue(0);
        tester.setIntegerClassValue((Integer)0);
        tester.setFloatValue(0.0f);
        tester.setFloatClassValue(Float.valueOf(0.0f));
        tester.setLongValue(0L);
        tester.setLongClassValue((Long)0L);
        tester.setDoubleValue(0.0);
        tester.setDoubleClassValue((Double)0.0);
        tester.setShortValue((short)0);
        tester.setShortClassValue((Short)0);
        tester.setByteValue((byte)0);
        tester.setByteClassValue((Byte)0);
        tester.setBigIntegerValue(new BigInteger("0"));
        tester.setBigDecimalValue(new BigDecimal("0"));
        return tester;
    }
}

