/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class DoubleNestedUnitOfWorkRegisterNewObjectTest
extends AutoVerifyTestCase {
    public DoubleNestedUnitOfWorkRegisterNewObjectTest() {
        this.setDescription("Test designed to verify that a new object registered in a nested unit of work is unregistered when deleted in same unit of work.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork nestedUow1 = uow.acquireUnitOfWork();
        UnitOfWork nestedNestedUOW = nestedUow1.acquireUnitOfWork();
        Employee employee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        employee.setId(new BigDecimal(15));
        Employee nestedEmployee = (Employee)nestedNestedUOW.registerObject((Object)employee);
        nestedNestedUOW.commit();
        nestedUow1.commit();
        nestedUow1 = uow.acquireUnitOfWork();
        nestedNestedUOW = nestedUow1.acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(new ExpressionBuilder().get("id").equal((Object)new BigDecimal(15)));
        query.conformResultsInUnitOfWork();
        nestedEmployee = (Employee)nestedNestedUOW.executeQuery((DatabaseQuery)query);
        nestedNestedUOW.deleteObject((Object)nestedEmployee);
        nestedNestedUOW.commit();
        nestedUow1.commit();
        if (!((UnitOfWorkImpl)uow).getNewObjectsCloneToOriginal().isEmpty()) {
            throw new TestErrorException("Failed to unregister the Object in the nested unit of work");
        }
        if (!((UnitOfWorkImpl)uow).getPrimaryKeyToNewObjects().isEmpty()) {
            throw new TestErrorException("Failed to unregister the Object in the nested unit of work");
        }
    }

    public void reset() {
        this.getAbstractSession().commitTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

