/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class NoAttributeTransformationMethodTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public NoAttributeTransformationMethodTest() {
        this.setDescription("This tests No Attribute Transformation Method (TL-ERROR 49)  uses EmployeeWithProblems class");
    }

    protected void setup() {
        this.expectedException = DescriptorException.noAttributeTransformationMethod(null);
        this.orgDescriptor = this.getSession().getDescriptor(EmployeeWithProblems.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
    }

    @Override
    public void reset() {
        this.getSession().getDescriptors().remove(EmployeeWithProblems.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("ADDRESS");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.addFieldTransformation("EMPLOYEE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("EMPLOYEE.END_TIME", "getEndTime");
        descriptor.addMapping((DatabaseMapping)normalHoursMapping);
        return descriptor;
    }
}

