/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.weaving;

import java.lang.reflect.Field;
import java.util.List;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicInsertObjectTest;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.models.performance.Address;
import org.eclipse.persistence.testing.models.performance.Employee;
import org.eclipse.persistence.testing.models.performance.EmployeePopulator;
import org.eclipse.persistence.testing.models.performance.EmployeeSystem;
import org.eclipse.persistence.testing.models.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.performance.LargeProject;
import org.eclipse.persistence.testing.models.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.performance.Project;
import org.eclipse.persistence.testing.models.performance.SmallProject;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeWeavingTestModel
extends TestModel {
    public EmployeeWeavingTestModel() {
        this.setDescription("This model tests reading/writing using weaved performance employee model.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new EmployeeSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getWeaverTestSuite());
        this.addTest((Test)this.getReadObjectTestSuite());
        this.addTest((Test)this.getUpdateTestSuite());
        this.addTest((Test)this.getInsertTestSuite());
        this.addTest((Test)this.getReadAllTestSuite());
        this.addTest((Test)this.getFetchGroupsTestSuite());
    }

    public TestSuite getInsertTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeWeavedInsertTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the employee weaved performance model.");
        EmployeePopulator system = new EmployeePopulator();
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample1()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample2()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample3()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample4()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicEmployeeExample5()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicSmallProjectExample1()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicSmallProjectExample2()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicSmallProjectExample3()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicLargeProjectExample1()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicLargeProjectExample2()));
        suite.addTest((Test)new UnitOfWorkBasicInsertObjectTest((Object)system.basicLargeProjectExample3()));
        return suite;
    }

    public TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeWeavedReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the employee weaved performance model.");
        suite.addTest((Test)new ReadAllTest(Employee.class, 12));
        suite.addTest((Test)new ReadAllTest(Project.class, 15));
        suite.addTest((Test)new ReadAllTest(LargeProject.class, 5));
        suite.addTest((Test)new ReadAllTest(SmallProject.class, 10));
        return suite;
    }

    public TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeWeavedReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the employee weaved performance model.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public TestSuite getUpdateTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("EmployeeWeavedUpdateTestSuite");
        suite.setDescription("This suite tests the updating of each object in the employee demo.");
        Class<Employee> employeeClass = Employee.class;
        Class<LargeProject> largeProjectClass = LargeProject.class;
        Class<SmallProject> smallProjectClass = SmallProject.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0003")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0004")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(employeeClass, "0005")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(smallProjectClass, "0003")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0001")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0002")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(largeProjectClass, "0003")));
        return suite;
    }

    public TestSuite getWeaverTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("WeaverTestSuite");
        suite.setDescription("This suite tests that the weaver ran on the class files correctly.");
        suite.addTest((Test)this.buildWeaverTest());
        return suite;
    }

    public TestSuite getFetchGroupsTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("FetchGroupsTestSuite");
        suite.setDescription("This suite tests weaving of fetch groups.");
        suite.addTest((Test)this.buildFetchGroupReadObjectTest());
        suite.addTest((Test)this.buildFetchGroupReadAllTest());
        suite.addTest((Test)this.buildFetchGroupReadObjectUOWTest());
        suite.addTest((Test)this.buildFetchGroupReadObjectUOWTransactionTest());
        suite.addTest((Test)this.buildFetchGroupUpdateObjectUOWTest());
        suite.addTest((Test)this.buildFetchGroupUpdateNonFetchedObjectUOWTest());
        return suite;
    }

    public TestCase buildWeaverTest() {
        TestCase test = new TestCase(){

            public void test() {
                this.testWeaving(new Employee(), true);
                this.testWeaving(new SmallProject(), true);
                this.testWeaving(new LargeProject(), true);
                this.testWeaving(new EmploymentPeriod(), false);
                this.testWeaving(new PhoneNumber(), true);
                this.testWeaving(new Address(), false);
                if (new EmployeeSystem() instanceof PersistenceWeaved) {
                    this.throwError("EmployeeSystem should not be weaved.");
                }
            }

            public void testWeaving(Object object, boolean indirection) {
                if (!(object instanceof PersistenceWeaved)) {
                    this.throwError("Object not weaved:" + object);
                }
                if (object instanceof PersistenceWeavedLazy != indirection) {
                    this.throwError("Object not weaved for indirection:" + object);
                }
                if (!(object instanceof ChangeTracker)) {
                    this.throwError("Object not weaved for ChangeTracker:" + object);
                }
                if (object instanceof EmploymentPeriod) {
                    if (!this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("period").getReferenceDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                        this.throwError("Descriptor not set to use change tracking:" + object);
                    }
                } else {
                    if (!this.getSession().getDescriptor(object).getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                        this.throwError("Descriptor not set to use change tracking:" + object);
                    }
                    if (!(object instanceof PersistenceEntity)) {
                        this.throwError("Object not weaved for PersistenceEntity:" + object);
                    }
                    if (!(object instanceof FetchGroupTracker)) {
                        this.throwError("Object not weaved for FetchGroupTracker:" + object);
                    }
                }
            }
        };
        test.setName("WeaverTeest");
        return test;
    }

    public TestCase buildFetchGroupReadObjectTest() {
        TestCase test = new TestCase(){

            public void test() throws Exception {
                Employee fetched = (Employee)this.getSession().readObject(Employee.class);
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadObjectQuery query = new ReadObjectQuery((Object)fetched);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                query.setFetchGroup(fetchGroup);
                Employee partial = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
                EmployeeWeavingTestModel.this.verfiyFetchGroup(this, partial, fetched);
            }
        };
        test.setName("FetchGroupReadObjectTest");
        return test;
    }

    public TestCase buildFetchGroupReadObjectUOWTest() {
        TestCase test = new TestCase(){

            public void test() throws Exception {
                Employee fetched = (Employee)this.getSession().readObject(Employee.class);
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadObjectQuery query = new ReadObjectQuery((Object)fetched);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                query.setFetchGroup(fetchGroup);
                Employee partial = (Employee)this.getSession().acquireUnitOfWork().executeQuery((DatabaseQuery)query);
                EmployeeWeavingTestModel.this.verfiyFetchGroup(this, partial, fetched);
            }
        };
        test.setName("FetchGroupReadObjectUOWTest");
        return test;
    }

    public TestCase buildFetchGroupUpdateObjectUOWTest() {
        TransactionalTestCase test = new TransactionalTestCase(){

            public void test() throws Exception {
                Employee fetched = (Employee)this.getSession().readObject(Employee.class);
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadObjectQuery query = new ReadObjectQuery((Object)fetched);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                query.setFetchGroup(fetchGroup);
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                Employee partial = (Employee)uow.executeQuery((DatabaseQuery)query);
                partial.setFirstName("partial");
                uow.commit();
                fetched = (Employee)this.getSession().readObject((Object)partial);
                if (!fetched.getFirstName().equals("partial")) {
                    this.throwError("Partial update not merged.");
                }
            }
        };
        test.setName("FetchGroupUpdateObjectUOWTest");
        return test;
    }

    public TestCase buildFetchGroupUpdateNonFetchedObjectUOWTest() {
        TransactionalTestCase test = new TransactionalTestCase(){

            public void test() throws Exception {
                Employee fetched = (Employee)this.getSession().readObject(Employee.class);
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadObjectQuery query = new ReadObjectQuery((Object)fetched);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                fetchGroup.addAttribute("address");
                query.setFetchGroup(fetchGroup);
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                Employee partial = (Employee)uow.executeQuery((DatabaseQuery)query);
                partial.setSalary(1234);
                uow.commit();
                fetched = (Employee)this.getSession().readObject((Object)partial);
                if (fetched.getSalary() != 1234) {
                    this.throwError("Partial update not merged.");
                }
            }
        };
        test.setName("FetchGroupUpdateNonFetchedObjectUOWTest");
        return test;
    }

    public TestCase buildFetchGroupReadObjectUOWTransactionTest() {
        TestCase test = new TestCase(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void test() throws Exception {
                Employee fetched = (Employee)this.getSession().readObject(Employee.class);
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadObjectQuery query = new ReadObjectQuery((Object)fetched);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                fetchGroup.addAttribute("manager");
                query.setFetchGroup(fetchGroup);
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                uow.beginEarlyTransaction();
                try {
                    Employee partial = (Employee)uow.executeQuery((DatabaseQuery)query);
                    EmployeeWeavingTestModel.this.verfiyFetchGroup(this, partial, fetched);
                }
                finally {
                    uow.release();
                }
            }
        };
        test.setName("FetchGroupReadObjectUOWTransactionTest");
        return test;
    }

    public TestCase buildFetchGroupReadAllTest() {
        TestCase test = new TestCase(){

            public void test() throws Exception {
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                FetchGroup fetchGroup = new FetchGroup();
                fetchGroup.addAttribute("firstName");
                fetchGroup.addAttribute("lastName");
                fetchGroup.addAttribute("period");
                query.setFetchGroup(fetchGroup);
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (Employee partial : result) {
                    partial.getFirstName();
                    partial.getAddress().getCity();
                }
            }
        };
        test.setName("FetchGroupReadAllTest");
        return test;
    }

    public void verfiyFetchGroup(TestCase test, Employee partial, Employee fetched) throws Exception {
        Field firstNameField = Employee.class.getDeclaredField("firstName");
        firstNameField.setAccessible(true);
        if (!fetched.getFirstName().equals(firstNameField.get(partial))) {
            test.throwError("FirstName not fetch correctly.");
        }
        Field salaryField = Employee.class.getDeclaredField("salary");
        salaryField.setAccessible(true);
        if (((Number)salaryField.get(partial)).longValue() != 0L) {
            test.throwError("Salary should not be fetched.");
        }
        if (!partial.getFirstName().equals(fetched.getFirstName())) {
            test.throwError("FirstName not fetch correctly.");
        }
        if (!partial.getLastName().equals(fetched.getLastName())) {
            test.throwError("LastName not fetch correctly.");
        }
        if (partial.getSalary() != fetched.getSalary()) {
            test.throwError("Salary not fetch correctly.");
        }
        if (!partial.getAddress().getCity().equals(fetched.getAddress().getCity())) {
            test.throwError("Address not fetch correctly.");
        }
    }
}

