/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.oracle;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestProblemException;

public class SessionExchanger {
    public boolean shouldLogoutOriginalSession = true;
    public boolean shouldLoginNewSession = true;
    DatabaseSession originalSession;
    DatabaseSession newSession;
    boolean hasLoggedOutOriginalSession;
    PoolDataSource dataSource;

    public DatabaseSession createNewSession(DatabaseSession originalSession, boolean useDatabaseSession, boolean useExternalConnectionPooling) {
        return this.createNewSession(originalSession, useDatabaseSession, useExternalConnectionPooling, null, null);
    }

    public DatabaseSession createNewSession(DatabaseSession originalSession, boolean useDatabaseSession, boolean useExternalConnectionPooling, Properties loginProperties, Map<String, Object> sessionProperties) {
        if (useExternalConnectionPooling) {
            return this.createNewSession(originalSession, useDatabaseSession, useExternalConnectionPooling, loginProperties, sessionProperties, -1, -1, -1, -1);
        }
        return this.createNewSession(originalSession, useDatabaseSession, useExternalConnectionPooling, loginProperties, sessionProperties, 2, 2, 2, 2);
    }

    public DatabaseSession createNewSession(DatabaseSession originalSession, boolean useDatabaseSession, boolean useExternalConnectionPooling, Properties loginProperties, Map<String, Object> sessionProperties, int minWriteConnections, int maxWriteConnections, int minReadConnections, int maxReadConnections) {
        this.setup(originalSession);
        DatabaseLogin login = this.cloneAndSetDataSource(originalSession.getLogin(), useExternalConnectionPooling, minWriteConnections, maxWriteConnections);
        if (useDatabaseSession) {
            this.newSession = new DatabaseSessionImpl((Login)login);
        } else {
            this.newSession = useExternalConnectionPooling ? new ServerSession((Login)login) : new ServerSession((Login)login, minWriteConnections, minWriteConnections);
            if (!useExternalConnectionPooling) {
                ServerSession ss = (ServerSession)this.newSession;
                if (ss.getReadConnectionPool().getMaxNumberOfConnections() != maxReadConnections) {
                    ss.getReadConnectionPool().setMaxNumberOfConnections(maxReadConnections);
                }
                if (ss.getReadConnectionPool().getMinNumberOfConnections() != minReadConnections) {
                    ss.getReadConnectionPool().setMinNumberOfConnections(minReadConnections);
                }
            }
        }
        this.setProperties(loginProperties, sessionProperties);
        this.newSession.setSessionLog(originalSession.getSessionLog());
        this.newSession.setLogLevel(originalSession.getLogLevel());
        if (this.shouldLoginNewSession) {
            this.newSession.login();
        }
        return this.newSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSession returnOriginalSession() {
        try {
            this.clearNewSession();
            DatabaseSession databaseSession = this.originalSession;
            return databaseSession;
        }
        finally {
            try {
                if (this.originalSession != null && this.hasLoggedOutOriginalSession) {
                    this.hasLoggedOutOriginalSession = false;
                    this.originalSession.login();
                }
            }
            finally {
                this.originalSession = null;
            }
        }
    }

    public boolean isBusy() {
        return this.newSession != null;
    }

    void setup(DatabaseSession originalSession) {
        if (this.isBusy()) {
            throw new TestProblemException("SessionExchanger: new session has been already created");
        }
        this.originalSession = originalSession;
        if (this.shouldLogoutOriginalSession && originalSession.isConnected()) {
            originalSession.logout();
            this.hasLoggedOutOriginalSession = true;
        }
    }

    void clearNewSession() {
        try {
            if (this.newSession != null && this.newSession.isConnected()) {
                this.newSession.logout();
            }
        }
        finally {
            this.newSession = null;
            if (this.dataSource != null) {
                this.dataSource = null;
            }
        }
    }

    DatabaseLogin cloneAndSetDataSource(DatabaseLogin login, boolean useExternalConnectionPooling, int minConnections, int maxConnections) {
        DatabaseLogin cloneLogin = (DatabaseLogin)login.clone();
        if (useExternalConnectionPooling) {
            this.createDataSource(login.getConnectionString(), minConnections, maxConnections);
            cloneLogin.setConnector((Connector)new JNDIConnector((DataSource)this.dataSource));
            cloneLogin.setUsesExternalConnectionPooling(true);
        }
        return cloneLogin;
    }

    void setProperties(Properties loginProperties, Map<String, Object> sessionProperties) {
        if (loginProperties != null) {
            this.newSession.getLogin().setProperties(loginProperties);
        }
        if (sessionProperties != null) {
            ((AbstractSession)this.newSession).setProperties(sessionProperties);
        }
    }

    void createDataSource(String connectionString, int minConnections, int maxConnections) {
        try {
            this.dataSource = PoolDataSourceFactory.getPoolDataSource();
            this.dataSource.setConnectionFactoryClassName("oracle.jdbc.pool.OracleDataSource");
            Properties props = new Properties();
            if (minConnections >= 0) {
                this.dataSource.setMinPoolSize(minConnections);
                this.dataSource.setInitialPoolSize(minConnections);
            }
            if (maxConnections >= 0) {
                this.dataSource.setMaxPoolSize(maxConnections);
            }
            this.dataSource.setURL(connectionString);
        }
        catch (SQLException ex) {
            throw new TestProblemException("Failed to create OracleDataSource with " + connectionString + ".\n", ex);
        }
    }
}

