/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.sql.Timestamp;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.TimestampUtils;
import oracle.kv.impl.api.table.TimestampValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.TimestampDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class TimestampDefImpl
extends FieldDefImpl
implements TimestampDef {
    private static final long serialVersionUID = 1L;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    public static final int MAX_PRECISION = 9;
    public static final int DEF_PRECISION = 9;
    static final String DEF_STRING_FORMAT = "%04d-%02d-%02dT%02d:%02d:%02d";
    static final Timestamp MAX_VALUE = TimestampUtils.createTimestamp(253402300799L, 999999999);
    static final Timestamp MIN_VALUE = TimestampUtils.createTimestamp(-263595168000L, 0);
    static final int MIN_YEAR = TimestampUtils.getYear(TimestampUtils.toBytes(MIN_VALUE, 9));
    static final int MAX_YEAR = TimestampUtils.getYear(TimestampUtils.toBytes(MAX_VALUE, 9));
    static final Timestamp[] maxValues = new Timestamp[10];
    static final Timestamp[] minValues = new Timestamp[10];
    private final int precision;

    TimestampDefImpl(int precision) {
        this(precision, null);
    }

    TimestampDefImpl(int precision, String description) {
        super(FieldDef.Type.TIMESTAMP, description);
        this.precision = precision;
        this.validate();
    }

    private TimestampDefImpl(TimestampDefImpl impl) {
        super(impl);
        this.precision = impl.precision;
    }

    @Override
    public TimestampDefImpl clone() {
        return new TimestampDefImpl(this);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TimestampDefImpl) {
            TimestampDefImpl otherDef = (TimestampDefImpl)other;
            return this.precision == otherDef.precision;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Integer.valueOf(this.precision).hashCode();
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public TimestampDef asTimestamp() {
        return this;
    }

    @Override
    public TimestampValueImpl createTimestamp(Timestamp value) {
        return new TimestampValueImpl((TimestampDef)this, value);
    }

    @Override
    TimestampValueImpl createTimestamp(String value) {
        return new TimestampValueImpl((TimestampDef)this, value);
    }

    @Override
    public short getRequiredSerialVersion() {
        return 13;
    }

    @Override
    public TimestampValueImpl createTimestamp(byte[] value) {
        return new TimestampValueImpl((TimestampDef)this, value);
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public TimestampValueImpl fromString(String timestampString) {
        return this.fromString(timestampString, null, true);
    }

    @Override
    public TimestampValueImpl fromString(String timestampString, String pattern, boolean withZoneUTC) {
        if (timestampString == null) {
            throw new IllegalArgumentException("Timestamp string can not be null");
        }
        return this.createTimestamp(TimestampUtils.parseString(timestampString, pattern, withZoneUTC));
    }

    @Override
    public TimestampValueImpl currentTimestamp() {
        return this.createTimestamp(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        if (superType.isAny() || superType.isAnyAtomic()) {
            return true;
        }
        return superType.isTimestamp() && this.precision <= superType.asTimestamp().getPrecision();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        node.put("precision", this.precision);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isTextual()) {
            throw new IllegalArgumentException("Timestamp value must be a string");
        }
        return this.fromString(node.asText());
    }

    static int getMaxPrecision() {
        return 9;
    }

    Timestamp getMaxValue() {
        return maxValues[this.precision];
    }

    Timestamp getMinValue() {
        return minValues[this.precision];
    }

    int getNumBytes() {
        return TimestampUtils.getNumBytes(this.precision);
    }

    private void validate() {
        if (this.precision < 0 || this.precision > 9) {
            throw new IllegalArgumentException("Timestamp precision must be between 0 and 9, inclusive");
        }
    }

    static {
        for (int p = 0; p <= 9; ++p) {
            TimestampDefImpl.maxValues[p] = TimestampUtils.roundToPrecision(MAX_VALUE, p);
            TimestampDefImpl.minValues[p] = TimestampUtils.roundToPrecision(MIN_VALUE, p);
        }
    }
}

