/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 *     05/16/2008-1.0M8 Guy Pelletier 
 *       - 218084: Implement metadata merging functionality between mapping files
 ******************************************************************************/  
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

/**
 * INTERNAL:
 * Object to hold onto query hints metadata. Use this object to preserve 
 * information like multiples and order of specification. We lose that by 
 * using a java hash object directly.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class QueryHintMetadata extends ORMetadata {
    private String m_name;
    private String m_value;
    
    /**
     * INTERNAL:
     */
    public QueryHintMetadata() {
        super("<hint>");
    }
    
    /**
     * INTERNAL:
     */
    public QueryHintMetadata(MetadataAnnotation hint, MetadataAccessibleObject accessibleObject) {
        super(hint, accessibleObject);
        
        m_name = (String) hint.getAttribute("name");
        m_value = (String) hint.getAttribute("value");
    }
    
    /**
     * INTERNAL:
     */
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof QueryHintMetadata) {
            QueryHintMetadata hint = (QueryHintMetadata) objectToCompare;
            
            if (! valuesMatch(m_name, hint.getName())) {
                return false;
            }
            
            return valuesMatch(m_value, hint.getValue());
        }
        
        return false;
    }
    
    /**
     * INTERNAL:
     * Used for OX mapping.
     */
    public String getName() {
        return m_name;
    }
    
    /**
     * INTERNAL:
     * Used for OX mapping.
     */
    public String getValue() {
        return m_value;
    }
    
    /**
     * INTERNAL:
     * Used for OX mapping.
     */
    public void setName(String name) {
        m_name = name;
    }
    
    /**
     * INTERNAL:
     * Used for OX mapping.
     */
    public void setValue(String value) {
        m_value = value;
    }
}
