/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.awt.Image;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.JAXBSchemaOutputResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelOutputResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private static final Map<String, Boolean> PARSER_FEATURES = new HashMap<String, Boolean>(2);
    protected XMLContext xmlContext;
    private Generator generator;
    private HashMap<QName, Class> qNameToGeneratedClasses;
    private HashMap<String, Class> classToGeneratedClasses;
    private HashMap<QName, Class> qNamesToDeclaredClasses;
    private HashMap<Type, QName> typeToSchemaType;
    private TypeMappingInfo[] boundTypes;
    private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedType;
    private Map<Type, TypeMappingInfo> typeToTypeMappingInfo;
    private Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToJavaTypeAdapters;

    protected JAXBContext() {
    }

    public JAXBContext(XMLContext context) {
        this.xmlContext = context;
    }

    public JAXBContext(XMLContext context, Generator generator, Type[] boundTypes) {
        this(context);
        this.generator = generator;
        this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
        this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
        this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
        this.boundTypes = new TypeMappingInfo[boundTypes.length];
        for (int i = 0; i < boundTypes.length; ++i) {
            TypeMappingInfo newTypeInfo = new TypeMappingInfo();
            newTypeInfo.setType(boundTypes[i]);
            this.boundTypes[i] = newTypeInfo;
        }
    }

    public JAXBContext(XMLContext context, Generator generator, TypeMappingInfo[] boundTypes) {
        this(context);
        this.generator = generator;
        this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
        this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
        this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
        this.typeMappingInfoToGeneratedType = generator.getAnnotationsProcessor().getTypeMappingInfoToGeneratedClasses();
        this.setTypeMappingInfoToJavaTypeAdapaters(this.createAdaptersForAdapterClasses(generator.getAnnotationsProcessor().getTypeMappingInfoToAdapterClasses()));
        this.boundTypes = boundTypes;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        this.generateSchema(outputResolver, null);
    }

    public void generateSchema(SchemaOutputResolver outputResolver, Map<QName, Type> additonalGlobalElements) {
        if (this.generator == null) {
            ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
            List sessions = this.xmlContext.getSessions();
            for (Session session : sessions) {
                Vector descriptors = session.getProject().getOrderedDescriptors();
                for (XMLDescriptor xDesc : descriptors) {
                    descriptorsToProcess.add(xDesc);
                }
            }
            SchemaModelGenerator smGen = new SchemaModelGenerator();
            smGen.generateSchemas(descriptorsToProcess, null, (SchemaModelOutputResolver)new JAXBSchemaOutputResolver(outputResolver), additonalGlobalElements);
        } else {
            this.generator.generateSchemaFiles(outputResolver, additonalGlobalElements);
        }
    }

    public JAXBMarshaller createMarshaller() {
        JAXBMarshaller marshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
        if (this.generator != null && this.generator.hasMarshalCallbacks()) {
            Iterator callIt = this.generator.getMarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                MarshalCallback cb = (MarshalCallback)this.generator.getMarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            marshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
        }
        marshaller.setQNameToGeneratedClasses(this.qNameToGeneratedClasses);
        marshaller.setJaxbContext(this);
        return marshaller;
    }

    public JAXBUnmarshaller createUnmarshaller() {
        JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller(PARSER_FEATURES));
        if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
            Iterator callIt = this.generator.getUnmarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                UnmarshalCallback cb = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            unmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
        }
        unmarshaller.setJaxbContext(this);
        return unmarshaller;
    }

    public JAXBValidator createValidator() {
        return new JAXBValidator(this.xmlContext.createValidator());
    }

    public JAXBBinder createBinder() {
        return new JAXBBinder(this.xmlContext);
    }

    public <T> JAXBBinder createBinder(Class<T> nodeClass) {
        if (nodeClass.getName().equals("org.w3c.dom.Node")) {
            return new JAXBBinder(this.xmlContext);
        }
        throw new UnsupportedOperationException((Throwable)JAXBException.unsupportedNodeClass((String)nodeClass.getName()));
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.xmlContext);
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> qNameToClass) {
        this.qNameToGeneratedClasses = qNameToClass;
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.classToGeneratedClasses;
    }

    public void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
        this.classToGeneratedClasses = classToClass;
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        this.xmlContext.applyORMMetadata(ormSession);
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.qNamesToDeclaredClasses;
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
        this.qNamesToDeclaredClasses = nameToDeclaredClasses;
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.generator.getAnnotationsProcessor().getArrayClassesToGeneratedClasses();
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.generator.getAnnotationsProcessor().getCollectionClassesToGeneratedClasses();
    }

    public void initTypeToSchemaType() {
        this.typeToSchemaType = new HashMap();
        if (this.typeToTypeMappingInfo == null || this.typeToTypeMappingInfo.size() == 0) {
            return;
        }
        for (XMLDescriptor next : this.xmlContext.getSession(0).getProject().getOrderedDescriptors()) {
            Class javaClass = next.getJavaClass();
            if (next.getSchemaReference() == null) continue;
            QName schemaType = next.getSchemaReference().getSchemaContextAsQName(next.getNamespaceResolver());
            Type type = null;
            if (this.generator != null) {
                type = this.generator.getAnnotationsProcessor().getGeneratedClassesToCollectionClasses().get(javaClass);
                if (type == null) {
                    JavaClass arrayClass = this.generator.getAnnotationsProcessor().getGeneratedClassesToArrayClasses().get(javaClass);
                    if (arrayClass != null) {
                        String arrayClassName = arrayClass.getName();
                        try {
                            type = PrivilegedAccessHelper.getClassForName((String)arrayClassName);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (type == null && this.getTypeMappingInfoToGeneratedType() != null) {
                        for (Map.Entry<TypeMappingInfo, Class> entry : this.getTypeMappingInfoToGeneratedType().entrySet()) {
                            if (!entry.getValue().equals(javaClass)) continue;
                            type = entry.getKey().getType();
                            break;
                        }
                    }
                }
                if (type == null) {
                    type = javaClass;
                }
            } else {
                type = javaClass;
            }
            this.typeToSchemaType.put(type, schemaType);
        }
        if (this.boundTypes != null) {
            for (TypeMappingInfo next : this.boundTypes) {
                Type nextType;
                QName name;
                if (this.typeToSchemaType.get(next) != null || (name = this.getSchemaTypeForTypeMappingInfo(nextType = next.getType())) == null) continue;
                this.typeToSchemaType.put(nextType, name);
            }
        }
    }

    private QName getSchemaTypeForTypeMappingInfo(Type type) {
        QName name = null;
        if (type instanceof Class && (name = this.generator.getAnnotationsProcessor().getUserDefinedSchemaTypes().get(((Class)type).getName())) == null) {
            Class theClass = (Class)type;
            name = type == ClassConstants.ABYTE || type == ClassConstants.APBYTE || type == Image.class || type == Source.class || theClass.getCanonicalName().equals("javax.activation.DataHandler") ? XMLConstants.BASE_64_BINARY_QNAME : (type == ClassConstants.OBJECT ? XMLConstants.ANY_TYPE_QNAME : (QName)XMLConversionManager.getDefaultJavaTypes().get(type));
        }
        return name;
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        if (this.typeToTypeMappingInfo != null && this.typeToTypeMappingInfo.size() > 0) {
            return new HashMap<TypeMappingInfo, QName>();
        }
        return this.generator.getAnnotationsProcessor().getTypeMappingInfoToSchemaType();
    }

    public HashMap<Type, QName> getTypeToSchemaType() {
        if (this.typeToSchemaType == null) {
            this.initTypeToSchemaType();
        }
        return this.typeToSchemaType;
    }

    Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedType() {
        return this.typeMappingInfoToGeneratedType;
    }

    Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
        return this.typeToTypeMappingInfo;
    }

    void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typeToMappingInfo) {
        this.typeToTypeMappingInfo = typeToMappingInfo;
        this.generator.setTypeToTypeMappingInfo(typeToMappingInfo);
    }

    void setTypeMappingInfoToJavaTypeAdapaters(Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters) {
        this.typeMappingInfoToJavaTypeAdapters = typeMappingInfoToAdapters;
    }

    private Map<TypeMappingInfo, RootLevelXmlAdapter> createAdaptersForAdapterClasses(Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses) {
        HashMap<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters = new HashMap<TypeMappingInfo, RootLevelXmlAdapter>();
        for (Map.Entry<TypeMappingInfo, Class> entry : typeMappingInfoToAdapterClasses.entrySet()) {
            Class adapterClass = entry.getValue();
            if (adapterClass == null) continue;
            try {
                XmlAdapter adapter = (XmlAdapter)adapterClass.newInstance();
                Class boundType = this.getBoundTypeForXmlAdapterClass(adapterClass);
                RootLevelXmlAdapter rootLevelXmlAdapter = new RootLevelXmlAdapter(adapter, boundType);
                typeMappingInfoToAdapters.put(entry.getKey(), rootLevelXmlAdapter);
            }
            catch (Exception ex) {}
        }
        return typeMappingInfoToAdapters;
    }

    private Class getBoundTypeForXmlAdapterClass(Class adapterClass) {
        Class boundType = Object.class;
        for (Method method : PrivilegedAccessHelper.getDeclaredMethods((Class)adapterClass)) {
            Class returnType;
            if (!method.getName().equals("marshal") || (returnType = PrivilegedAccessHelper.getMethodReturnType((Method)method)).getName().equals(boundType.getName())) continue;
            boundType = returnType;
            break;
        }
        return boundType;
    }

    Map<TypeMappingInfo, RootLevelXmlAdapter> getTypeMappingInfoToJavaTypeAdapters() {
        return this.typeMappingInfoToJavaTypeAdapters;
    }

    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return (T)this.xmlContext.getValueByXPath(object, xPath, namespaceResolver, returnType);
    }

    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        this.xmlContext.setValueByXPath(object, xPath, namespaceResolver, value);
    }

    static {
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/normalized-value", false);
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/element-default", false);
    }

    static class RootLevelXmlAdapter {
        private XmlAdapter xmlAdapter;
        private Class boundType;

        public RootLevelXmlAdapter(XmlAdapter adapter, Class boundType) {
            this.xmlAdapter = adapter;
            this.boundType = boundType;
        }

        public XmlAdapter getXmlAdapter() {
            return this.xmlAdapter;
        }

        public Class getBoundType() {
            return this.boundType;
        }

        public void setXmlAdapter(XmlAdapter xmlAdapter) {
            this.xmlAdapter = xmlAdapter;
        }

        public void setBoundType(Class boundType) {
            this.boundType = boundType;
        }
    }
}

