/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.DescriptorNotFoundContentHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class XMLRelationshipMappingNodeValue
extends MappingNodeValue {
    public void processChild(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, XMLDescriptor xmlDescriptor, DatabaseMapping mapping) throws SAXException {
        if (xmlDescriptor == null) {
            DescriptorNotFoundContentHandler handler = new DescriptorNotFoundContentHandler(unmarshalRecord, mapping);
            String qnameString = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qnameString = xPathFragment.getPrefix() + ':' + qnameString;
            }
            handler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setLexicalHandler(handler);
            return;
        }
        if (xmlDescriptor.hasInheritance()) {
            QName leafElementType;
            unmarshalRecord.setAttributes(atts);
            Class classValue = xmlDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, unmarshalRecord.getSession());
            if (classValue == null && (leafElementType = unmarshalRecord.getLeafElementType()) != null) {
                Object indicator = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                if (indicator == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, xmlDescriptor.getInheritancePolicy().getDescriptor());
                }
                classValue = (Class)indicator;
            }
            if (classValue != null) {
                xmlDescriptor = (XMLDescriptor)unmarshalRecord.getSession().getDescriptor(classValue);
            } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xmlDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        TreeObjectBuilder targetObjectBuilder = (TreeObjectBuilder)xmlDescriptor.getObjectBuilder();
        UnmarshalRecord childRecord = unmarshalRecord.getChildUnmarshalRecord(targetObjectBuilder);
        unmarshalRecord.setChildRecord(childRecord);
        childRecord.setAttributes(atts);
        childRecord.startDocument();
        childRecord.initializeRecord((XMLMapping)null);
        childRecord.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), xPathFragment.getShortName(), atts);
        XMLReader xmlReader = unmarshalRecord.getXMLReader();
        xmlReader.setContentHandler(childRecord);
        xmlReader.setLexicalHandler(childRecord);
    }

    protected XMLDescriptor findReferenceDescriptor(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts, DatabaseMapping mapping, UnmarshalKeepAsElementPolicy policy) {
        XMLDescriptor returnDescriptor = null;
        if (atts != null) {
            XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
            String schemaType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (schemaType != null && (schemaType = schemaType.trim()).length() > 0) {
                XPathFragment frag = new XPathFragment();
                frag.setXPath(schemaType);
                QName qname = null;
                if (frag.hasNamespace()) {
                    String prefix = frag.getPrefix();
                    String url = unmarshalRecord.resolveNamespacePrefix(prefix);
                    frag.setNamespaceURI(url);
                    qname = new QName(url, frag.getLocalName());
                    unmarshalRecord.setTypeQName(qname);
                } else {
                    String url = unmarshalRecord.resolveNamespacePrefix("");
                    if (null != url) {
                        frag.setNamespaceURI(url);
                        qname = new QName(url, frag.getLocalName());
                        unmarshalRecord.setTypeQName(qname);
                    }
                }
                returnDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                if (returnDescriptor == null && (policy == null || policy != null && policy != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && policy != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT)) {
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
                    if (theClass == null) {
                        throw XMLMarshalException.noDescriptorFound(mapping);
                    }
                }
            }
        }
        return returnDescriptor;
    }

    protected void addTypeAttribute(XMLDescriptor descriptor, MarshalRecord marshalRecord, String schemaContext) {
        String typeValue = schemaContext.substring(1);
        String xsiPrefix = null;
        if (descriptor.getNamespaceResolver() != null) {
            xsiPrefix = descriptor.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            xsiPrefix = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (xsiPrefix == null) {
            xsiPrefix = descriptor.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", xsiPrefix, "xmlns:" + xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix + ':' + "type", typeValue);
    }

    protected void writeExtraNamespaces(List extraNamespaces, XMLRecord xmlRecord, AbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        int extraNamespacesSize = extraNamespaces.size();
        for (int i = 0; i < extraNamespacesSize; ++i) {
            Namespace next = (Namespace)extraNamespaces.get(i);
            ((MarshalRecord)xmlRecord).attribute("http://www.w3.org/2000/xmlns/", next.getPrefix(), "xmlns:" + next.getPrefix(), next.getNamespaceURI());
        }
    }

    protected void setupHandlerForKeepAsElementPolicy(UnmarshalRecord unmarshalRecord, XPathFragment xPathFragment, Attributes atts) {
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        builder.setOwningRecord(unmarshalRecord);
        try {
            String namespaceURI = "";
            if (xPathFragment.getNamespaceURI() != null) {
                namespaceURI = xPathFragment.getNamespaceURI();
            }
            String qName = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qName = xPathFragment.getPrefix() + ':' + qName;
            }
            builder.startElement(namespaceURI, xPathFragment.getLocalName(), qName, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(builder);
            xmlReader.setLexicalHandler(null);
        }
        catch (SAXException ex) {
            // empty catch block
        }
    }

    protected void setOrAddAttributeValueForKeepAsElement(SAXFragmentBuilder builder, XMLMapping mapping, XMLConverter converter, UnmarshalRecord unmarshalRecord, boolean isCollection, Object collection) {
        Object node = builder.getNodes().remove(builder.getNodes().size() - 1);
        if (converter != null) {
            node = converter.convertDataValueToObjectValue(node, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        }
        if (isCollection) {
            if (collection != null) {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), node, collection);
            } else {
                unmarshalRecord.addAttributeValue((ContainerValue)((Object)this), node);
            }
        } else {
            unmarshalRecord.setAttributeValue(node, (DatabaseMapping)((Object)mapping));
        }
    }

    protected void endElementProcessText(UnmarshalRecord unmarshalRecord, Converter converter, XPathFragment xPathFragment, Object collection) {
        Object value = unmarshalRecord.getStringBuffer().toString();
        if (converter != null) {
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(value, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertDataValueToObjectValue(value, unmarshalRecord.getSession());
        }
        unmarshalRecord.resetStringBuffer();
        if (!"".equals(value)) {
            Class theClass;
            QName qname = unmarshalRecord.getTypeQName();
            if (qname != null && (theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(qname)) != null) {
                value = ((XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager()).convertObject(value, theClass, qname);
            }
            this.setOrAddAttributeValue(unmarshalRecord, value, xPathFragment, collection);
        }
    }

    protected abstract void setOrAddAttributeValue(UnmarshalRecord var1, Object var2, XPathFragment var3, Object var4);
}

