/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ModifyQuery;

public abstract class ObjectLevelModifyQuery
extends ModifyQuery {
    protected Object primaryKey;
    protected Object object;
    protected ObjectChangeSet objectChangeSet;
    protected Object backupClone;

    public ObjectLevelModifyQuery() {
        this.cascadePolicy = 2;
    }

    public void checkDescriptor(AbstractSession session) throws QueryException {
        if (this.descriptor == null) {
            if (this.getObject() == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            ClassDescriptor referenceDescriptor = session.getDescriptor(this.getObject());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getObject().getClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
    }

    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException {
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(ObjectLevelModifyQuery)");
        }
        return this.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, translationRow);
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException, OptimisticLockException {
        if (!unitOfWork.getCommitManager().isActive()) {
            throw QueryException.invalidQuery(this);
        }
        if (this.object != null && unitOfWork.isClassReadOnly(this.object.getClass(), this.descriptor)) {
            return this.object;
        }
        if (unitOfWork.shouldPerformNoValidation() && unitOfWork.isUnregisteredExistingObject(this.object)) {
            return null;
        }
        return super.executeInUnitOfWork(unitOfWork, translationRow);
    }

    public Object getBackupClone() {
        if (this.backupClone == null && this.session.isUnitOfWork()) {
            this.setBackupClone(((UnitOfWorkImpl)this.session).getBackupCloneForCommit(this.object, this.descriptor));
        }
        return this.backupClone;
    }

    public Object getObject() {
        return this.object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        if (this.getReferenceClass() != null) {
            return this.getReferenceClass().getName();
        }
        return null;
    }

    public boolean isObjectLevelModifyQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        this.checkDescriptor(this.getSession());
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        super.prepare();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.object == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.object = this.descriptor.getObjectBuilder().unwrapObject(this.object, this.session);
        if (this.primaryKey == null) {
            this.primaryKey = this.objectChangeSet != null ? this.objectChangeSet.getId() : this.descriptor.getObjectBuilder().extractPrimaryKeyFromObject(this.object, this.session);
        }
    }

    public void setBackupClone(Object backupClone) {
        this.backupClone = backupClone;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setObjectChangeSet(ObjectChangeSet changeSet) {
        this.objectChangeSet = changeSet;
    }

    public void setPrimaryKey(Object primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + String.valueOf(this.getObject()) + ")";
    }
}

