/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public abstract class DirectCollectionAccessor
extends DirectAccessor {
    private String m_joinFetch;
    private String m_batchFetch;
    private Integer m_batchFetchSize;
    private CollectionTableMetadata m_collectionTable;

    protected DirectCollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected DirectCollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation batchFetch;
        MetadataAnnotation joinFetch;
        if (annotation != null) {
            this.setFetch((String)annotation.getAttribute("fetch"));
        }
        if ((joinFetch = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (String)joinFetch.getAttribute("value");
        }
        if ((batchFetch = this.getAnnotation(BatchFetch.class)) != null) {
            this.m_batchFetch = (String)batchFetch.getAttributeString("value");
            this.m_batchFetchSize = (Integer)batchFetch.getAttribute("size");
        }
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectCollectionAccessor) {
            DirectCollectionAccessor directCollectionAccessor = (DirectCollectionAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_joinFetch, directCollectionAccessor.getJoinFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetch, directCollectionAccessor.getBatchFetch())) {
                return false;
            }
            if (!this.valuesMatch(this.m_batchFetchSize, directCollectionAccessor.getBatchFetchSize())) {
                return false;
            }
            return this.valuesMatch(this.m_collectionTable, directCollectionAccessor.getCollectionTable());
        }
        return false;
    }

    public String getBatchFetch() {
        return this.m_batchFetch;
    }

    public Integer getBatchFetchSize() {
        return this.m_batchFetchSize;
    }

    public void setBatchFetchSize(Integer batchFetchSize) {
        this.m_batchFetchSize = batchFetchSize;
    }

    public CollectionTableMetadata getCollectionTable() {
        return this.m_collectionTable;
    }

    protected String getDefaultCollectionTableName() {
        return this.getOwningDescriptor().getAlias() + "_" + this.getDefaultAttributeName();
    }

    public String getDefaultFetchType() {
        return FetchType.LAZY.name();
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.m_collectionTable.getDatabaseTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    protected abstract String getKeyConverter();

    protected String getValueConverter() {
        return this.getConvert();
    }

    protected boolean hasMapKeyClass() {
        return false;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_collectionTable, accessibleObject);
    }

    public boolean isDirectCollection() {
        return true;
    }

    protected boolean isValidDirectCollectionType() {
        return this.getAccessibleObject().isSupportedCollectionClass(this.getRawClass());
    }

    protected boolean isValidDirectMapType() {
        return this.getAccessibleObject().isSupportedMapClass(this.getRawClass());
    }

    protected void process(CollectionMapping mapping) {
        this.setMapping((DatabaseMapping)mapping);
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processJoinFetch(this.getJoinFetch(), (ForeignReferenceMapping)mapping);
        this.processBatchFetch(this.getBatchFetch(), (ForeignReferenceMapping)mapping);
        this.processCollectionTable(mapping);
        this.processReturnInsertAndUpdate();
        mapping.setShouldExtendPessimisticLockScope(true);
    }

    protected void processCollectionTable(CollectionMapping mapping) {
        if (this.m_collectionTable == null) {
            this.m_collectionTable = new CollectionTableMetadata(this.getAccessibleObject());
        }
        this.processTable(this.m_collectionTable, this.getDefaultCollectionTableName());
        if (!this.isDirectEmbeddableCollection()) {
            ((DirectCollectionMapping)mapping).setReferenceTable(this.m_collectionTable.getDatabaseTable());
        }
    }

    protected void processDirectCollectionMapping() {
        DirectCollectionMapping mapping = new DirectCollectionMapping();
        this.process((CollectionMapping)mapping);
        this.processContainerPolicyAndIndirection((CollectionMapping)mapping);
        mapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
            mapping.setDirectFieldClassification(this.getJavaClass(this.getReferenceClass()));
        }
        this.processMappingValueConverter((DatabaseMapping)mapping, this.getValueConverter(), this.getReferenceClass());
    }

    protected void processDirectMapMapping() {
        DirectMapMapping mapping = new DirectMapMapping();
        this.process((CollectionMapping)mapping);
        this.processContainerPolicyAndIndirection((CollectionMapping)mapping);
        mapping.setDirectKeyField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column"));
        if (this.isBasicMap()) {
            if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
                mapping.setDirectKeyFieldClassification(this.getJavaClass(this.getMapKeyReferenceClass()));
            }
            this.processMappingKeyConverter((DatabaseMapping)mapping, this.getKeyConverter(), this.getMapKeyReferenceClass());
        }
        mapping.setDirectField(this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_value_column"));
        if (this.hasAttributeType() || this.getAccessibleObject().isGenericCollectionType()) {
            mapping.setDirectFieldClassification(this.getJavaClass(this.getReferenceClass()));
        }
        this.processMappingValueConverter((DatabaseMapping)mapping, this.getValueConverter(), this.getReferenceClass());
    }

    public void setBatchFetch(String batchFetch) {
        this.m_batchFetch = batchFetch;
    }

    public void setCollectionTable(CollectionTableMetadata collectionTable) {
        this.m_collectionTable = collectionTable;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }
}

