/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;

public abstract class AbstractIdentityMap
implements IdentityMap,
Serializable,
Cloneable {
    protected int maxSize;
    protected ClassDescriptor descriptor;

    public AbstractIdentityMap() {
    }

    public AbstractIdentityMap(int size) {
        this.maxSize = size;
    }

    public AbstractIdentityMap(int size, ClassDescriptor descriptor) {
        this(size);
        this.descriptor = descriptor;
    }

    public CacheKey acquireDeferredLock(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireDeferredLock();
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.releaseDeferredLock();
        }
        cacheKey.acquireDeferredLock();
        return cacheKey;
    }

    public CacheKey acquireLock(Object primaryKey, boolean forMerge) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        cacheKey.acquire();
        return cacheKey;
    }

    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        if (!cacheKey.acquireNoWait(forMerge)) {
            return null;
        }
        return cacheKey;
    }

    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquire(forMerge);
            cacheKey = this.putCacheKeyIfAbsent(newCacheKey);
            if (cacheKey == null) {
                return newCacheKey;
            }
            newCacheKey.release();
        }
        if (!cacheKey.acquireWithWait(forMerge, wait)) {
            return null;
        }
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        cacheKey.acquireReadLock();
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKey(primaryKey);
        if (cacheKey == null) {
            CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
            newCacheKey.acquireReadLock();
            return newCacheKey;
        }
        if (!cacheKey.acquireReadLockNoWait()) {
            return null;
        }
        return cacheKey;
    }

    public abstract void collectLocks(HashMap var1);

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
    }

    public boolean containsKey(Object primaryKey) {
        return this.getCacheKeyWithReadLock(primaryKey) != null;
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue) {
        return this.createCacheKey(primaryKey, object, writeLockValue, 0L);
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new CacheKey(primaryKey, object, writeLockValue, readTime);
    }

    public abstract Enumeration elements();

    public Object get(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public abstract CacheKey getCacheKey(Object var1);

    public CacheKey getCacheKeyForLock(Object primaryKey) {
        return this.getCacheKey(primaryKey);
    }

    protected abstract CacheKey putCacheKeyIfAbsent(CacheKey var1);

    protected CacheKey getCacheKeyWithReadLock(Object primaryKey) {
        CacheKey key = this.getCacheKey(primaryKey);
        if (key != null) {
            key.checkReadLock();
        }
        return key;
    }

    public static Class getDefaultIdentityMapClass() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class;
    }

    public int getMaxSize() {
        if (this.maxSize == -1) {
            this.maxSize = 100;
        }
        return this.maxSize;
    }

    public abstract int getSize();

    public abstract int getSize(Class var1, boolean var2);

    public Object getWrapper(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWrapper();
    }

    public Object getWriteLockValue(Object primaryKey) {
        CacheKey cacheKey = this.getCacheKeyWithReadLock(primaryKey);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getWriteLockValue();
    }

    public abstract Enumeration keys();

    public abstract CacheKey put(Object var1, Object var2, Object var3, long var4);

    public void release() {
    }

    public Object remove(Object primaryKey, Object object) {
        CacheKey key = this.getCacheKeyForLock(primaryKey);
        return this.remove(key);
    }

    public abstract Object remove(CacheKey var1);

    protected synchronized void setMaxSize(int size) {
        this.maxSize = size;
    }

    public void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class getDescriptorClass() {
        return this.descriptor.getJavaClass();
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setWrapper(Object primaryKey, Object wrapper) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWrapper(wrapper);
        }
    }

    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.acquire();
            cacheKey.setWriteLockValue(writeLockValue);
            cacheKey.release();
        }
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "[" + this.getSize() + "]";
    }
}

