/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Map;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.MarshalRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMappingMarshalNodeValue
extends NodeValue
implements ContainerValue {
    private XMLChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<XMLField, NodeValue> fieldToNodeValues;
    private NodeValue choiceElementNodeValue;
    private XMLField xmlField;

    public XMLChoiceCollectionMappingMarshalNodeValue(XMLChoiceCollectionMapping mapping, XMLField xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<XMLField, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
    }

    private void initializeNodeValue() {
        XMLMapping xmlMapping = this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof XMLCompositeDirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((XMLCompositeDirectCollectionMapping)xmlMapping) : new XMLCompositeCollectionMappingNodeValue((XMLCompositeCollectionMapping)xmlMapping);
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlChoiceCollectionMapping.isReadOnly()) {
            return false;
        }
        Object value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
        if (value == null) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.hasNext(iterator = cp.iteratorFor(value))) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
        } else {
            return false;
        }
        while (cp.hasNext(iterator)) {
            Object nextValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Converter converter = this.xmlChoiceCollectionMapping.getConverter();
        if (null != converter) {
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshalRecord.getMarshaller()) : converter.convertObjectValueToDataValue(value, session);
        }
        NodeValue associatedNodeValue = null;
        XMLField associatedField = null;
        Object fieldValue = value;
        if (value instanceof XMLRoot) {
            XMLRoot rootValue = (XMLRoot)value;
            String localName = rootValue.getLocalName();
            String namespaceUri = rootValue.getNamespaceURI();
            fieldValue = rootValue.getObject();
            associatedField = this.getFieldForName(localName, namespaceUri);
            if (associatedField == null) {
                associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(fieldValue.getClass());
            }
        } else {
            associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(value.getClass());
        }
        if (associatedField != null) {
            associatedNodeValue = this.fieldToNodeValues.get(associatedField);
        }
        if (associatedNodeValue != null) {
            XPathFragment frag = associatedField.getXPathFragment();
            while (frag != null) {
                ContainerValue nestedNodeValue;
                if (associatedNodeValue.isOwningNode(frag)) {
                    nestedNodeValue = (ContainerValue)((Object)((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementNodeValue());
                    nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, fieldValue, session, namespaceResolver, marshalContext);
                    break;
                }
                if ((frag = frag.getNextFragment()) != null) continue;
                nestedNodeValue = (ContainerValue)((Object)((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementNodeValue());
                nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, fieldValue, session, namespaceResolver, marshalContext);
            }
        }
        return true;
    }

    private XMLField getFieldForName(String localName, String namespaceUri) {
        for (XMLField nextField : this.fieldToNodeValues.keySet()) {
            for (XPathFragment fragment = nextField.getXPathFragment(); fragment != null && !fragment.nameIsText(); fragment = fragment.getNextFragment()) {
                if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(localName)) continue;
                String fragUri = fragment.getNamespaceURI();
                if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                return nextField;
            }
        }
        return null;
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public XMLChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }
}

