/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Session;

public abstract class ServerPlatformBase
implements ServerPlatform {
    public static final String JMX_REGISTER_DEV_MBEAN_PROPERTY = "eclipselink.register.dev.mbean";
    public static final String JMX_REGISTER_RUN_MBEAN_PROPERTY = "eclipselink.register.run.mbean";
    public static final String DEFAULT_SERVER_NAME_AND_VERSION = ToStringLocalization.buildMessage("unknown");
    private boolean isRuntimeServicesEnabled = this.isRuntimeServicesEnabledDefault();
    protected boolean shouldRegisterDevelopmentBean = true;
    protected boolean shouldRegisterRuntimeBean = true;
    protected Class externalTransactionControllerClass;
    private boolean isJTAEnabled = true;
    private boolean isCMP;
    private DatabaseSession databaseSession;
    protected String serverNameAndVersion;

    public ServerPlatformBase(DatabaseSession newDatabaseSession) {
        String shouldRegisterDevelopmentBeanProperty;
        this.databaseSession = newDatabaseSession;
        this.setIsCMP(false);
        String shouldRegisterRuntimeBeanProperty = System.getProperty(JMX_REGISTER_RUN_MBEAN_PROPERTY);
        if (null != shouldRegisterRuntimeBeanProperty) {
            if (shouldRegisterRuntimeBeanProperty.toLowerCase().indexOf("false") > -1) {
                this.shouldRegisterRuntimeBean = false;
            }
            if (shouldRegisterRuntimeBeanProperty.toLowerCase().indexOf("true") > -1) {
                this.shouldRegisterRuntimeBean = true;
            }
        }
        if (null != (shouldRegisterDevelopmentBeanProperty = System.getProperty(JMX_REGISTER_DEV_MBEAN_PROPERTY))) {
            if (shouldRegisterDevelopmentBeanProperty.toLowerCase().indexOf("false") > -1) {
                this.shouldRegisterDevelopmentBean = false;
            }
            if (shouldRegisterDevelopmentBeanProperty.toLowerCase().indexOf("true") > -1) {
                this.shouldRegisterDevelopmentBean = true;
            }
        }
    }

    public void configureProfiler(Session session) {
    }

    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    public String getServerNameAndVersion() {
        if (this.serverNameAndVersion == null) {
            this.initializeServerNameAndVersion();
        }
        return this.serverNameAndVersion;
    }

    protected void initializeServerNameAndVersion() {
        this.serverNameAndVersion = DEFAULT_SERVER_NAME_AND_VERSION;
    }

    public String getModuleName() {
        return DEFAULT_SERVER_NAME_AND_VERSION;
    }

    public abstract Class getExternalTransactionControllerClass();

    public void setExternalTransactionControllerClass(Class newClass) {
        this.externalTransactionControllerClass = newClass;
    }

    public void initializeExternalTransactionController() {
        this.ensureNotLoggedIn();
        if (!this.isJTAEnabled() && !this.isCMP()) {
            return;
        }
        if (!this.isJTAEnabled() && this.isCMP()) {
            AbstractSessionLog.getLog().warning("jta_cannot_be_disabled_in_cmp");
        }
        try {
            if (this.getDatabaseSession().getExternalTransactionController() != null) {
                this.externalTransactionControllerNotNullWarning();
                return;
            }
            ExternalTransactionController controller = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    controller = (ExternalTransactionController)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getExternalTransactionControllerClass()));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof InstantiationException) {
                        throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
                    }
                    throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
                }
            } else {
                controller = (ExternalTransactionController)PrivilegedAccessHelper.newInstanceFromClass(this.getExternalTransactionControllerClass());
            }
            this.getDatabaseSession().setExternalTransactionController(controller);
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
    }

    protected void externalTransactionControllerNotNullWarning() {
        ((DatabaseSessionImpl)this.getDatabaseSession()).warning("External_transaction_controller_not_defined_by_server_platform", "ejb");
    }

    public boolean isJTAEnabled() {
        return this.isJTAEnabled;
    }

    public boolean isRuntimeServicesEnabledDefault() {
        return false;
    }

    public boolean isRuntimeServicesEnabled() {
        return this.isRuntimeServicesEnabled;
    }

    public void disableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = false;
    }

    public void enableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = true;
    }

    public void disableJTA() {
        this.ensureNotLoggedIn();
        this.isJTAEnabled = false;
    }

    public Connection unwrapConnection(Connection connection) {
        try {
            return connection.getMetaData().getConnection();
        }
        catch (SQLException e) {
            ((DatabaseSessionImpl)this.getDatabaseSession()).log(6, "connection", "cannot_unwrap_connection", e);
            return connection;
        }
    }

    public void launchContainerRunnable(Runnable runnable) {
        new Thread(runnable).start();
    }

    protected void ensureNotLoggedIn() {
        if (this.getDatabaseSession() == null) {
            return;
        }
    }

    public SessionLog getServerLog() {
        return new ServerLog();
    }

    public boolean isCMP() {
        return this.isCMP;
    }

    public void setIsCMP(boolean isThisCMP) {
        this.isCMP = isThisCMP;
    }

    public boolean shouldUseDriverManager() {
        return true;
    }

    public boolean wasFailureCommunicationBased(SQLException exception, Accessor connection, AbstractSession sessionForProfile) {
        return this.getDatabaseSession().getPlatform().wasFailureCommunicationBased(exception, connection.getConnection(), sessionForProfile);
    }

    public JPAClassLoaderHolder getNewTempClassLoader(PersistenceUnitInfo puInfo) {
        return new JPAClassLoaderHolder(puInfo.getNewTempClassLoader(), true);
    }

    public void clearStatementCache(Connection connection) {
    }

    public void registerMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificRegisterMBean();
    }

    public void unregisterMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificUnregisterMBean();
    }

    public void serverSpecificUnregisterMBean() {
    }

    public void serverSpecificRegisterMBean() {
    }
}

