/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ReadConnectionPool
extends ConnectionPool {
    public ReadConnectionPool() {
    }

    public ReadConnectionPool(String name, Login login, ServerSession owner) {
        super(name, login, owner);
    }

    public ReadConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        super(name, login, minNumberOfConnections, maxNumberOfConnections, owner);
    }

    public ReadConnectionPool(String name, Login login, int initialNumberOfConnections, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        super(name, login, initialNumberOfConnections, minNumberOfConnections, maxNumberOfConnections, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        if (this.isDead) {
            return this.failover();
        }
        Accessor leastBusyConnection = null;
        int size = this.connectionsAvailable.size();
        for (int index = 0; index < size; ++index) {
            Accessor connection = (Accessor)this.connectionsAvailable.get(index);
            if (this.checkConnections) {
                if (this.owner.getLogin().isConnectionHealthValidatedOnError() && this.owner.getServerPlatform().wasFailureCommunicationBased(null, connection, this.owner)) {
                    Object var7_9;
                    this.connectionsAvailable.remove(index);
                    try {
                        try {
                            connection.closeConnection();
                        }
                        catch (Exception ex) {
                            var7_9 = null;
                            connection.releaseCustomizer();
                        }
                        var7_9 = null;
                        connection.releaseCustomizer();
                    }
                    catch (Throwable throwable) {
                        var7_9 = null;
                        connection.releaseCustomizer();
                        throw throwable;
                    }
                    --index;
                    --size;
                    continue;
                }
                this.checkConnections = false;
            }
            if (connection.getCallCount() == 0) {
                leastBusyConnection = connection;
                break;
            }
            if (leastBusyConnection != null && leastBusyConnection.getCallCount() <= connection.getCallCount()) continue;
            leastBusyConnection = connection;
        }
        if ((leastBusyConnection == null || leastBusyConnection.getCallCount() != 0) && this.connectionsAvailable.size() + this.connectionsUsed.size() < this.maxNumberOfConnections) {
            Accessor connection = null;
            try {
                connection = this.buildConnection();
            }
            catch (RuntimeException failed) {
                if (!this.failoverConnectionPools.isEmpty()) {
                    this.isDead = true;
                    this.timeOfDeath = System.currentTimeMillis();
                    this.owner.logThrowable(6, "sql", failed);
                    return this.acquireConnection();
                }
                throw failed;
            }
            this.connectionsAvailable.add(connection);
            leastBusyConnection = connection;
        }
        leastBusyConnection.incrementCallCount(this.getOwner());
        if (this.owner.shouldLog(1, "connection")) {
            Object[] args = new Object[]{this.name};
            this.owner.log(1, "connection", "acquire_connection", args, leastBusyConnection);
        }
        return leastBusyConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        if (this.owner.shouldLog(1, "connection")) {
            Object[] args = new Object[]{this.name};
            this.owner.log(1, "connection", "release_connection", args, connection);
        }
        connection.decrementCallCount();
        if (!connection.isValid()) {
            this.checkConnections = true;
            this.connectionsAvailable.remove(connection);
            try {
                connection.disconnect(this.getOwner());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

