/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.DefaultStringExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentifierRole;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.QueryPosition;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpression
implements Expression {
    private String actualText;
    private List<Expression> children;
    private int offset = -1;
    private List<Expression> orderedChildren;
    private AbstractExpression parent;
    private String parsedText;
    private String text;
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char LEFT_CURLY_BRACKET = '{';
    public static final char LEFT_PARENTHESIS = '(';
    public static final char NOT_DEFINED = '\u0000';
    public static final char RIGHT_CURLY_BRACKET = '}';
    public static final char RIGHT_PARENTHESIS = ')';
    public static final char SINGLE_QUOTE = '\'';
    public static final char SPACE = ' ';
    public static final char UNDERSCORE = '_';

    protected AbstractExpression(AbstractExpression parent) {
        this(parent, "");
    }

    protected AbstractExpression(AbstractExpression parent, String text) {
        this.text = text;
        this.parent = parent;
    }

    protected boolean acceptUnknownVisitor(ExpressionVisitor visitor) {
        try {
            try {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), this.getClass());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.acceptUnknownVisitor(visitor, visitor.getClass(), Expression.class);
            }
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            RuntimeException actual = cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
            throw actual;
        }
    }

    protected void acceptUnknownVisitor(ExpressionVisitor visitor, Class<?> type, Class<?> parameterType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Method visitMethod = type.getDeclaredMethod("visit", parameterType);
            visitMethod.setAccessible(true);
            visitMethod.invoke((Object)visitor, this);
        }
        catch (NoSuchMethodException e) {
            type = type.getSuperclass();
            if (type == Object.class) {
                throw e;
            }
            this.acceptUnknownVisitor(visitor, type, parameterType);
        }
    }

    protected void addChildrenTo(Collection<Expression> children) {
    }

    protected void addOrderedChildrenTo(List<Expression> children) {
    }

    protected final AbstractExpression buildExpressionFromFallingBack(WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        ExpressionFactory factory = this.findFallBackExpressionFactory(queryBNF);
        if (factory == null) {
            return null;
        }
        if (tolerant && factory.getId() == "pre-literal" && this.shouldSkipLiteral(expression)) {
            return null;
        }
        return factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant);
    }

    protected final AbstractExpression buildNullExpression() {
        return new NullExpression(this);
    }

    protected final Expression buildStringExpression(char value) {
        return this.buildStringExpression(String.valueOf(value));
    }

    protected final Expression buildStringExpression(String value) {
        return new DefaultStringExpression(this, value);
    }

    protected final AbstractExpression buildUnknownExpression(String text) {
        return new UnknownExpression(this, text);
    }

    protected final int calculatePosition(Expression expression, int length) {
        Expression parent = expression.getParent();
        if (parent == null) {
            return length;
        }
        for (Expression childExpression : parent.orderedChildren()) {
            if (childExpression == expression) {
                return this.calculatePosition(parent, length);
            }
            length += childExpression.getLength();
        }
        throw new RuntimeException("The position of the Expression could not be calculated: " + expression);
    }

    @Override
    public final IterableListIterator<Expression> children() {
        if (this.children == null) {
            this.children = new LinkedList<Expression>();
            this.addChildrenTo(this.children);
        }
        return new CloneListIterator<Expression>(this.children);
    }

    protected final ExpressionFactory findFallBackExpressionFactory(JPQLQueryBNF queryBNF) {
        String fallBackBNFId = queryBNF.getFallbackBNFId();
        if (fallBackBNFId == null) {
            return null;
        }
        JPQLQueryBNF fallBackQueryBNF = this.getQueryBNF(fallBackBNFId);
        if (fallBackQueryBNF != queryBNF && fallBackQueryBNF.getFallbackBNFId() != null) {
            return this.findFallBackExpressionFactory(fallBackQueryBNF);
        }
        return this.getExpressionRegistry().getExpressionFactory(fallBackQueryBNF.getFallbackExpressionFactoryId());
    }

    public JPQLQueryBNF findQueryBNF(AbstractExpression expression) {
        return this.getQueryBNF();
    }

    protected final ExpressionFactory getExpressionFactory(String expressionFactoryId) {
        return this.getExpressionRegistry().getExpressionFactory(expressionFactoryId);
    }

    protected final ExpressionRegistry getExpressionRegistry() {
        return this.getGrammar().getExpressionRegistry();
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.getRoot().getGrammar();
    }

    protected Iterable<String> getIdentifiers(String queryBNFId) {
        return this.getExpressionRegistry().getIdentifiers(queryBNFId);
    }

    public JPAVersion getIdentifierVersion(String identifier) {
        return this.getRoot().getIdentifierVersion(identifier);
    }

    protected JPAVersion getJPAVersion() {
        return this.getRoot().getJPAVersion();
    }

    @Override
    public final int getLength() {
        return this.toActualText().length();
    }

    @Override
    public final int getOffset() {
        if (this.offset == -1) {
            this.offset = this.calculatePosition(this, 0);
        }
        return this.offset;
    }

    @Override
    public final AbstractExpression getParent() {
        return this.parent;
    }

    public JPQLQueryBNF getQueryBNF(String queryBNFID) {
        return this.getExpressionRegistry().getQueryBNF(queryBNFID);
    }

    @Override
    public final JPQLExpression getRoot() {
        return this.parent == null ? (JPQLExpression)this : this.parent.getRoot();
    }

    protected String getText() {
        return this.text;
    }

    protected boolean handleAggregate(JPQLQueryBNF queryBNF) {
        return queryBNF.handleAggregate();
    }

    @Override
    public boolean isAncestor(Expression expression) {
        if (expression == this) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        return this.isAncestor(expression.getParent());
    }

    protected final boolean isIdentifier(String word) {
        return this.getExpressionRegistry().isIdentifier(word);
    }

    protected boolean isNull() {
        return false;
    }

    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("FROM") || word.equalsIgnoreCase("WHERE") || word.equalsIgnoreCase("HAVING") || wordParser.startsWithIdentifier("GROUP BY") || wordParser.startsWithIdentifier("ORDER BY") || word.equalsIgnoreCase("UNION") || word.equalsIgnoreCase("INTERSECT") || word.equalsIgnoreCase("EXCEPT");
    }

    protected boolean isTolerant() {
        return this.getRoot().isTolerant();
    }

    protected boolean isUnknown() {
        return false;
    }

    protected boolean isVirtual() {
        return false;
    }

    @Override
    public final IterableListIterator<Expression> orderedChildren() {
        if (this.orderedChildren == null) {
            this.orderedChildren = new LinkedList<Expression>();
            this.addOrderedChildrenTo(this.orderedChildren);
        }
        return new CloneListIterator<Expression>(this.orderedChildren);
    }

    protected abstract void parse(WordParser var1, boolean var2);

    protected AbstractExpression parse(WordParser wordParser, String queryBNFId, boolean tolerant) {
        if (wordParser.isTail()) {
            return null;
        }
        JPQLQueryBNF queryBNF = this.getQueryBNF(queryBNFId);
        LinkedList<AbstractExpression> children = new LinkedList<AbstractExpression>();
        LinkedList<Boolean> separatedByCommas = new LinkedList<Boolean>();
        LinkedList<Boolean> separatedBySpaces = new LinkedList<Boolean>();
        AbstractExpression expression = null;
        AbstractExpression child = null;
        int length = wordParser.position();
        boolean beginning = !tolerant;
        char character = wordParser.character();
        int count = 0;
        while (!wordParser.isTail()) {
            String word;
            child = null;
            if (character == '(') {
                if (queryBNF.handlesSubExpression()) {
                    expression = this.buildExpressionFromFallingBack(wordParser, "", queryBNF, expression, tolerant);
                } else {
                    expression = new SubExpression(this, queryBNF.getId());
                    ((AbstractExpression)expression).parse(wordParser, tolerant);
                    if (this.getParent() != null && this.getParent().getQueryBNF().handlesSubExpression()) {
                        return expression;
                    }
                }
                beginning = false;
                count = wordParser.skipLeadingWhitespace();
                character = wordParser.character();
                children.add(expression);
                separatedByCommas.add(Boolean.FALSE);
                separatedBySpaces.add(count > 0);
            }
            if ((word = wordParser.word()).length() > 0) {
                ExpressionFactory factory;
                if (!tolerant && !beginning && this.isParsingComplete(wordParser, word, expression) || tolerant && this.isParsingComplete(wordParser, word, expression)) break;
                if (this.shouldParseWithFactoryFirst() && wordParser.getWordType() == WordParser.WordType.WORD && (factory = queryBNF.getExpressionFactory(word)) != null && (child = this.parse(wordParser, word, factory, queryBNF, expression, tolerant)) != null) {
                    expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                    beginning = false;
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                }
                if (child == null && (child = this.buildExpressionFromFallingBack(wordParser, word, queryBNF, expression, tolerant)) != null) {
                    expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                    beginning = false;
                    count = wordParser.skipLeadingWhitespace();
                    character = wordParser.character();
                }
            }
            if (child != null && expression != null && expression != child) {
                count = 0;
            }
            if (tolerant && child == null && wordParser.position() == length && character != ',') {
                ExpressionFactory factory;
                ExpressionRegistry expressionRegistry = this.getExpressionRegistry();
                if (word.length() > 0 && expressionRegistry.getIdentifierRole(word) != IdentifierRole.AGGREGATE && (factory = expressionRegistry.expressionFactoryForIdentifier(word)) != null && (child = this.parse(wordParser, word, factory, queryBNF, expression, tolerant)) != null) {
                    child = new BadExpression(this, child);
                    expression = this.updateParsingInfo(expression, child, children, separatedByCommas, separatedBySpaces);
                    character = wordParser.character();
                    beginning = false;
                }
            }
            if (child == null && character != ',') break;
            if (expression == null || child != null) {
                children.add(child);
                separatedByCommas.add(Boolean.FALSE);
                separatedBySpaces.add(count > 1);
            }
            if (wordParser.isTail()) break;
            if (character == ',') {
                boolean stopParsing;
                if (!queryBNF.handleCollection() || this.isParsingComplete(wordParser, word, expression)) break;
                int collectionIndex = separatedByCommas.size() - 1;
                wordParser.moveForward(1);
                separatedByCommas.set(collectionIndex, Boolean.TRUE);
                count = wordParser.skipLeadingWhitespace();
                separatedBySpaces.set(collectionIndex, count > 0);
                character = wordParser.character();
                expression = null;
                if (character == '(') continue;
                word = wordParser.word();
                boolean bl = stopParsing = tolerant && (word.length() == 0 || this.isParsingComplete(wordParser, word, null));
                if (wordParser.isTail() || stopParsing) {
                    child = null;
                    count = 0;
                    children.add(child);
                    separatedByCommas.add(Boolean.FALSE);
                    separatedBySpaces.add(Boolean.FALSE);
                    if (stopParsing) break;
                }
                if (character != ')') continue;
                break;
            }
            if (character == ')' || !this.handleAggregate(queryBNF)) break;
            separatedBySpaces.set(separatedBySpaces.size() - 1, count > 0);
        }
        if (count > 0) {
            if (!separatedByCommas.isEmpty() && ((Boolean)separatedByCommas.get(separatedByCommas.size() - 1)).booleanValue()) {
                separatedBySpaces.set(separatedBySpaces.size() - 1, Boolean.TRUE);
            } else {
                wordParser.moveBackward(count);
                if (!separatedBySpaces.isEmpty()) {
                    separatedBySpaces.set(separatedBySpaces.size() - 1, Boolean.FALSE);
                }
            }
        }
        expression = children.size() == 1 && separatedByCommas.get(0) == Boolean.FALSE && separatedBySpaces.get(0) == Boolean.FALSE ? (AbstractExpression)children.get(0) : (!children.isEmpty() ? new CollectionExpression(this, children, separatedByCommas, separatedBySpaces) : null);
        return expression;
    }

    protected final AbstractExpression parse(WordParser wordParser, String word, ExpressionFactory factory, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        return factory.buildExpression(this, wordParser, word, queryBNF, expression, tolerant);
    }

    protected AbstractExpression parseSingleExpression(WordParser wordParser, String queryBNFId, boolean tolerant) {
        String word = wordParser.word();
        JPQLQueryBNF queryBNF = this.getQueryBNF(queryBNFId);
        ExpressionFactory factory = queryBNF.getExpressionFactory(word);
        return factory == null ? null : this.parse(wordParser, word, factory, queryBNF, null, tolerant);
    }

    @Override
    public void populatePosition(QueryPosition queryPosition, int position) {
        queryPosition.addPosition(this, position);
        if (position != 0) {
            for (Expression expression : this.orderedChildren()) {
                String expressionText = expression.toParsedText();
                if (position <= expressionText.length()) {
                    expression.populatePosition(queryPosition, position);
                    return;
                }
                position -= expressionText.length();
            }
            throw new IllegalStateException("The traversal to find the ExpressionFactories didn't work correctly, it shouldn't hit this.");
        }
        queryPosition.setExpression(this);
    }

    protected final void rebuildActualText() {
        if (this.actualText != null) {
            this.toActualText();
        }
    }

    protected final void rebuildParsedText() {
        if (this.parsedText != null) {
            this.toParsedText();
        }
    }

    protected final void setParent(AbstractExpression parent) {
        this.parent = parent;
    }

    protected final void setText(String text) {
        this.text = text;
    }

    protected boolean shouldParseWithFactoryFirst() {
        return true;
    }

    protected boolean shouldSkipLiteral(AbstractExpression expression) {
        return expression != null;
    }

    @Override
    public String toActualText() {
        if (this.actualText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, true);
            this.actualText = writer.toString();
        }
        return this.actualText;
    }

    @Override
    public String toParsedText() {
        if (this.parsedText == null) {
            StringBuilder writer = new StringBuilder();
            this.toParsedText(writer, false);
            this.parsedText = writer.toString();
        }
        return this.parsedText;
    }

    protected abstract void toParsedText(StringBuilder var1, boolean var2);

    public final String toString() {
        this.parsedText = null;
        return this.toParsedText();
    }

    private AbstractExpression updateParsingInfo(AbstractExpression expression, AbstractExpression child, List<AbstractExpression> children, List<Boolean> separatedByCommas, List<Boolean> separatedBySpaces) {
        if (expression != null && child.isAncestor(expression)) {
            int expressionLocation = children.indexOf(expression);
            if (expressionLocation > -1) {
                separatedByCommas.remove(expressionLocation);
                separatedBySpaces.remove(expressionLocation);
            }
            children.remove(expression);
        }
        return child;
    }
}

