/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.test.visit.PrecisionTypeVisitor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrecisionTypeTest {
    protected static long LONG_1 = 1L;
    protected static long LONG_6 = 6L;
    protected static long LONG_39 = 39L;
    protected static long LONG_19 = 19L;
    protected static String DECIMAL = "DECIMAL";
    protected static String DECIMAL_6 = "DECIMAL(6)";
    protected static String DECIMAL_6_1 = "DECIMAL(6,1)";
    protected static String DOUBLE = "DOUBLE";
    protected static String DOUBLE_39 = "DOUBLE(39)";
    protected static String FLOAT = "FLOAT";
    protected static String FLOAT_39 = "FLOAT(39)";
    protected static String NUMERIC = "NUMERIC";
    protected static String NUMERIC_39 = "NUMERIC(39)";
    protected static String NUMERIC_39_1 = "NUMERIC(39,1)";
    protected static String REAL = "REAL";
    protected static String REAL_19 = "REAL(19)";
    protected static PrecisionTypeVisitor visitor;

    @BeforeClass
    public static void setUp() {
        visitor = new PrecisionTypeVisitor();
    }

    @Test
    public void testDecimalType() {
        DecimalType decimalType = new DecimalType();
        decimalType.accept(visitor);
        Assert.assertEquals((String)"DecimalType() test failed:\n", (Object)visitor.toString(), (Object)DECIMAL);
        decimalType = new DecimalType(LONG_6);
        decimalType.accept(visitor);
        Assert.assertEquals((String)"DecimalType(LONG_6) test failed:\n", (Object)visitor.toString(), (Object)DECIMAL_6);
        decimalType = new DecimalType(LONG_6, LONG_1);
        decimalType.accept(visitor);
        Assert.assertEquals((String)"DecimalType(LONG_6, LONG_1) test failed:\n", (Object)visitor.toString(), (Object)DECIMAL_6_1);
    }

    @Test
    public void testDoubleType() {
        DoubleType doubleType = new DoubleType();
        doubleType.accept(visitor);
        Assert.assertEquals((String)"DoubleType() test failed:\n", (Object)visitor.toString(), (Object)DOUBLE);
        doubleType = new DoubleType(LONG_39);
        doubleType.accept(visitor);
        Assert.assertEquals((String)"DoubleType(LONG_39) test failed:\n", (Object)visitor.toString(), (Object)DOUBLE_39);
        doubleType = new DoubleType(LONG_39, LONG_1);
        doubleType.accept(visitor);
        Assert.assertEquals((String)"DoubleType(LONG_39, LONG_1) test failed:\n", (Object)visitor.toString(), (Object)DOUBLE_39);
    }

    @Test
    public void testFloatType() {
        FloatType floatType = new FloatType();
        floatType.accept(visitor);
        Assert.assertEquals((String)"FloatType() test failed:\n", (Object)visitor.toString(), (Object)FLOAT);
        floatType = new FloatType(LONG_39);
        floatType.accept(visitor);
        Assert.assertEquals((String)"FloatType(LONG_39) test failed:\n", (Object)visitor.toString(), (Object)FLOAT_39);
        floatType = new FloatType(LONG_39, LONG_1);
        floatType.accept(visitor);
        Assert.assertEquals((String)"FloatType(LONG_39, LONG_1) test failed:\n", (Object)visitor.toString(), (Object)FLOAT_39);
    }

    @Test
    public void testNumericType() {
        NumericType numericType = new NumericType();
        numericType.accept(visitor);
        Assert.assertEquals((String)"NumericType() test failed:\n", (Object)visitor.toString(), (Object)NUMERIC);
        numericType = new NumericType(LONG_39);
        numericType.accept(visitor);
        Assert.assertEquals((String)"NumericType(LONG_39) test failed:\n", (Object)visitor.toString(), (Object)NUMERIC_39);
        numericType = new NumericType(LONG_39, LONG_1);
        numericType.accept(visitor);
        Assert.assertEquals((String)"NumericType(LONG_39, LONG_1) test failed:\n", (Object)visitor.toString(), (Object)NUMERIC_39_1);
    }

    @Test
    public void testRealType() {
        RealType realType = new RealType();
        realType.accept(visitor);
        Assert.assertEquals((String)"RealType() test failed:\n", (Object)visitor.toString(), (Object)REAL);
        realType = new RealType(LONG_19);
        realType.accept(visitor);
        Assert.assertEquals((String)"RealType(LONG_19) test failed:\n", (Object)visitor.toString(), (Object)REAL_19);
        realType = new RealType(LONG_19, LONG_1);
        realType.accept(visitor);
        Assert.assertEquals((String)"RealType(LONG_19, LONG_1) test failed:\n", (Object)visitor.toString(), (Object)REAL_19);
    }
}

