/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.MarkAndResetHandler;
import com.sun.corba.ee.impl.encoding.RestorableInputStream;
import com.sun.corba.ee.impl.protocol.RequestCanceledException;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBData;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public class BufferManagerReadStream
implements BufferManagerRead,
MarkAndResetHandler {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private volatile boolean receivedCancel = false;
    private int cancelReqId = 0;
    private boolean endOfStream = true;
    private final BufferQueue fragmentQueue = new BufferQueue();
    private final ORB orb;
    private boolean markEngaged = false;
    private LinkedList<ByteBuffer> fragmentStack = null;
    private RestorableInputStream inputStream = null;
    private Object streamMemento = null;

    BufferManagerReadStream(ORB orb) {
        this.orb = orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelProcessing(int requestId) {
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            this.receivedCancel = true;
            this.cancelReqId = requestId;
            this.fragmentQueue.notify();
        }
    }

    @InfoMethod
    private void bufferMessage(String msg, int bbAddr, String tail) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void processFragment(ByteBuffer byteBuffer, FragmentMessage msg) {
        byteBuffer.position(msg.getHeaderLength());
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            if (this.orb.transportDebugFlag) {
                this.logBufferMessage("processFragment() - queuing ByteByffer id (", byteBuffer, ") to fragment queue.");
            }
            this.fragmentQueue.enqueue(byteBuffer);
            this.endOfStream = !msg.moreFragmentsToFollow();
            this.fragmentQueue.notify();
        }
    }

    @InfoMethod
    private void underflowMessage(String msg, int rid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public ByteBuffer underflow(ByteBuffer byteBuffer) {
        ByteBuffer result;
        long startNanos = System.nanoTime();
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            long timeoutNanos;
            if (this.receivedCancel) {
                this.underflowMessage("underflow() - Cancel request id:", this.cancelReqId);
                throw new RequestCanceledException(this.cancelReqId);
            }
            ORBData orbData = this.orb.getORBData();
            int timeoutMillis = orbData.fragmentReadTimeout();
            long waitNanos = timeoutNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
            while (this.fragmentQueue.size() == 0) {
                if (this.endOfStream) {
                    throw wrapper.endOfStream();
                }
                boolean interrupted = false;
                try {
                    orbData.waitNanos(this.fragmentQueue, waitNanos);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                long elapsedNanos = System.nanoTime() - startNanos;
                long l = waitNanos = elapsedNanos < 0L ? 0L : timeoutNanos - elapsedNanos;
                if (!interrupted && waitNanos <= 0L && this.fragmentQueue.size() == 0) {
                    throw wrapper.bufferReadManagerTimeout();
                }
                if (!this.receivedCancel) continue;
                this.underflowMessage("underflow() - Cancel request id after wait:", this.cancelReqId);
                throw new RequestCanceledException(this.cancelReqId);
            }
            result = this.fragmentQueue.dequeue();
            if (!this.markEngaged && byteBuffer != null) {
                this.getByteBufferPool().releaseByteBuffer(byteBuffer);
            }
        }
        return result;
    }

    @Override
    public boolean isFragmentOnUnderflow() {
        return true;
    }

    @Override
    public void init(Message msg) {
        if (msg != null) {
            this.endOfStream = !msg.moreFragmentsToFollow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void close(ByteBuffer byteBuffer) {
        int inputBbAddress = 0;
        if (byteBuffer != null) {
            inputBbAddress = System.identityHashCode(byteBuffer);
        }
        ByteBufferPool byteBufferPool = this.getByteBufferPool();
        BufferQueue bufferQueue = this.fragmentQueue;
        synchronized (bufferQueue) {
            while (this.fragmentQueue.size() != 0) {
                ByteBuffer aBuffer = this.fragmentQueue.dequeue();
                if (aBuffer == null) continue;
                byteBufferPool.releaseByteBuffer(aBuffer);
            }
        }
        this.fragmentQueue.clear();
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            for (ByteBuffer aBuffer : this.fragmentStack) {
                if (aBuffer == null || inputBbAddress == System.identityHashCode(aBuffer)) continue;
                byteBufferPool.releaseByteBuffer(aBuffer);
            }
            this.fragmentStack = null;
        }
    }

    private void logBufferMessage(String prefix, ByteBuffer byteBuffer, String suffix) {
        this.bufferMessage(prefix, System.identityHashCode(byteBuffer), suffix);
    }

    protected ByteBufferPool getByteBufferPool() {
        return this.orb.getByteBufferPool();
    }

    @Override
    public void mark(RestorableInputStream inputStream) {
        this.inputStream = inputStream;
        this.markEngaged = true;
        this.streamMemento = inputStream.createStreamMemento();
        if (this.fragmentStack != null) {
            this.fragmentStack.clear();
        }
    }

    @Override
    public void fragmentationOccured(ByteBuffer newFrament) {
        if (!this.markEngaged) {
            return;
        }
        if (this.fragmentStack == null) {
            this.fragmentStack = new LinkedList();
        }
        this.fragmentStack.addFirst(newFrament.duplicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        if (!this.markEngaged) {
            return;
        }
        this.markEngaged = false;
        if (this.fragmentStack != null && this.fragmentStack.size() != 0) {
            BufferQueue bufferQueue = this.fragmentQueue;
            synchronized (bufferQueue) {
                for (ByteBuffer aBuffer : this.fragmentStack) {
                    this.fragmentQueue.push(aBuffer);
                }
            }
            this.fragmentStack.clear();
        }
        this.inputStream.restoreInternalState(this.streamMemento);
    }

    @Override
    public MarkAndResetHandler getMarkAndResetHandler() {
        return this;
    }
}

