/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.junit.runtime;

import org.eclipse.core.runtime.Platform;
import org.eclipse.rap.internal.junit.runtime.RemotePluginTestRunner;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class Application
implements IEntryPoint,
ITestHarness {
    private TestableObject fTestableObject;

    public int createUI() {
        UICallBack.activate((String)Application.class.getName());
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        return this.createAndRunWorkbench();
    }

    private int createAndRunWorkbench() {
        int result;
        String entryPointName = this.getEntryPointName();
        if (entryPointName != null) {
            IEntryPoint entryPoint = this.getEntryPoint(entryPointName);
            result = entryPoint.createUI();
        } else {
            result = this.createAndRunEmptyWorkbench();
        }
        return result;
    }

    private int createAndRunEmptyWorkbench() {
        Display display = PlatformUI.createDisplay();
        WorkbenchAdvisor workbenchAdvisor = new WorkbenchAdvisor(){

            public String getInitialWindowPerspectiveId() {
                return "org.eclipse.rap.junit.runtime.emptyPerspective";
            }
        };
        return PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
    }

    private String getEntryPointName() {
        String parameter = RWT.getRequest().getParameter("testentrypoint");
        String result = null;
        if (!"rapjunit".equals(parameter) && !"".equals(parameter)) {
            result = parameter;
        }
        return result;
    }

    private IEntryPoint getEntryPoint(String entryPointName) {
        EntryPointManager entryPointManager = RWTFactory.getEntryPointManager();
        IEntryPointFactory factory = entryPointManager.getFactoryByName(entryPointName);
        if (factory == null) {
            throw new IllegalArgumentException(entryPointName);
        }
        return factory.create();
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(new Runnable(){

            public void run() {
                RemotePluginTestRunner.main(Platform.getCommandLineArgs());
            }
        });
        this.fTestableObject.testingFinished();
    }
}

