/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets.formtextkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.widgets.IAggregateHyperlinkSegmentAdapter;
import org.eclipse.ui.forms.internal.widgets.IBulletParagraphAdapter;
import org.eclipse.ui.forms.internal.widgets.IFormTextAdapter;
import org.eclipse.ui.forms.internal.widgets.ITextSegmentAdapter;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.forms.widgets.AggregateHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.BulletParagraph;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageSegment;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class FormTextLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "forms.widgets.FormText";
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final String PREFIX = "resource/widget/rap/formtext/";
    private static final String BULLET_CIRCLE_GIF = "resource/widget/rap/formtext/bullet_circle.gif";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_TEXT = "text";
    private static final String PROP_HYPERLINK_SETTINGS = "hyperlinkSettings";
    private static final String PROP_HYPERLINK_UNDERLINE_MODE = "hyperlinkUnderlineMode";
    private static final String PROP_HYPERLINK_FOREGROUND = "hyperlinkForeground";
    private static final String PROP_HYPERLINK_ACTIVE_FOREGROUND = "hyperlinkActiveForeground";
    private static final String PROP_RESOURCE_TABLE = "resourceTable";

    public void preserveValues(Widget widget) {
        FormText formText = (FormText)widget;
        ControlLCAUtil.preserveValues((Control)formText);
        WidgetLCAUtil.preserveCustomVariant((Widget)formText);
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_UNDERLINE_MODE, (int)settings.getHyperlinkUnderlineMode());
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_FOREGROUND, (Object)settings.getForeground());
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_ACTIVE_FOREGROUND, (Object)settings.getActiveForeground());
        WidgetLCAUtil.preserveProperty((Widget)widget, (String)PROP_RESOURCE_TABLE, (Object)FormTextLCA.getResourceTable(formText));
    }

    public void renderInitialization(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)formText);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId((Widget)formText.getParent()));
    }

    public void readData(Widget widget) {
        FormText formText = (FormText)widget;
        ControlLCAUtil.processSelection((Widget)formText, null, (boolean)false);
        ControlLCAUtil.processEvents((Control)formText);
        ControlLCAUtil.processKeyEvents((Control)formText);
    }

    public void renderChanges(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        ControlLCAUtil.renderChanges((Control)formText);
        WidgetLCAUtil.renderCustomVariant((Widget)formText);
        FormTextLCA.renderHyperlinkSettings(formText);
        FormTextLCA.renderText(formText);
    }

    private static void renderHyperlinkSettings(FormText formText) {
        if (FormTextLCA.hasHyperlinkSettingsChanged(formText)) {
            HyperlinkSettings newValue = formText.getHyperlinkSettings();
            int underlineMode = newValue.getHyperlinkUnderlineMode();
            Color foreground = newValue.getForeground();
            Color activeForeground = newValue.getActiveForeground();
            Object[] args = new Object[]{new Integer(underlineMode), FormTextLCA.getColorAsArray(foreground), FormTextLCA.getColorAsArray(activeForeground)};
            IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)formText);
            clientObject.set(PROP_HYPERLINK_SETTINGS, (Object)args);
        }
    }

    private static void renderText(FormText formText) {
        if (FormTextLCA.hasLayoutChanged(formText) || FormTextLCA.hasResourceTableChanged(formText) || FormTextLCA.hasBoundsChanged(formText)) {
            Paragraph[] paragraphs = FormTextLCA.getParagraphs(formText);
            ArrayList buffer = new ArrayList();
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph paragraph = paragraphs[i];
                if (paragraph instanceof BulletParagraph) {
                    BulletParagraph bullet = (BulletParagraph)paragraph;
                    FormTextLCA.appendBullet(formText, bullet, buffer);
                }
                ParagraphSegment[] segments = paragraph.getSegments();
                FormTextLCA.appendSegments(formText, segments, buffer);
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject((Adaptable)formText);
            clientObject.set(PROP_TEXT, (Object)buffer.toArray(new Object[0]));
        }
    }

    private static void appendBullet(FormText formText, BulletParagraph bullet, ArrayList buffer) {
        int style = bullet.getBulletStyle();
        Image image = FormTextLCA.getBulletImage(formText, bullet);
        String imageName = ImageFactory.getImagePath((Image)image);
        String text = bullet.getBulletText();
        Rectangle bounds = FormTextLCA.getBulletBounds(bullet);
        if (bounds != null) {
            Object[] args = new Object[]{"bullet", new Integer(style), imageName, text, FormTextLCA.getBoundsAsArray(bounds)};
            buffer.add(args);
        }
    }

    private static void appendSegments(FormText formText, ParagraphSegment[] segments, ArrayList buffer) {
        int i = 0;
        while (i < segments.length) {
            ParagraphSegment segment = segments[i];
            if (segment instanceof TextHyperlinkSegment) {
                FormTextLCA.appendTextHyperlinkSegment(formText, (TextHyperlinkSegment)segment, buffer);
            } else if (segment instanceof TextSegment) {
                FormTextLCA.appendTextSegment(formText, (TextSegment)segment, buffer);
            } else if (segment instanceof ImageHyperlinkSegment) {
                FormTextLCA.appendImageHyperlinkSegment(formText, (ImageHyperlinkSegment)segment, buffer);
            } else if (segment instanceof ImageSegment) {
                FormTextLCA.appendImageSegment(formText, (ImageSegment)segment, buffer);
            } else if (segment instanceof AggregateHyperlinkSegment) {
                FormTextLCA.appendAggregateHyperlinkSegment(formText, (AggregateHyperlinkSegment)segment, buffer);
            }
            ++i;
        }
    }

    private static void appendTextHyperlinkSegment(FormText formText, TextHyperlinkSegment segment, ArrayList buffer) {
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        String tooltipText = segment.getTooltipText();
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        int i = 0;
        while (i < textFragments.length) {
            Object[] args = new Object[]{"textHyperlink", textFragments[i], tooltipText, FormTextLCA.getBoundsAsArray(textFragmentsBounds[i]), FormTextLCA.getFontAsArray(font)};
            buffer.add(args);
            ++i;
        }
    }

    private static void appendTextSegment(FormText formText, TextSegment segment, ArrayList buffer) {
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        String colorId = segment.getColorId();
        Color color = null;
        if (colorId != null) {
            color = (Color)FormTextLCA.getResourceTable(formText).get(colorId);
        }
        int i = 0;
        while (i < textFragments.length) {
            Object[] args = new Object[]{PROP_TEXT, textFragments[i], FormTextLCA.getBoundsAsArray(textFragmentsBounds[i]), FormTextLCA.getFontAsArray(font), FormTextLCA.getColorAsArray(color)};
            buffer.add(args);
            ++i;
        }
    }

    private static void appendImageHyperlinkSegment(FormText formText, ImageHyperlinkSegment segment, ArrayList buffer) {
        String tooltipText = segment.getTooltipText();
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ImageFactory.getImagePath((Image)image);
        Object[] args = new Object[]{"imageHyperlink", imageName, tooltipText, FormTextLCA.getBoundsAsArray(bounds)};
        buffer.add(args);
    }

    private static void appendImageSegment(FormText formText, ImageSegment segment, ArrayList buffer) {
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ImageFactory.getImagePath((Image)image);
        Object[] args = new Object[]{"image", imageName, FormTextLCA.getBoundsAsArray(bounds)};
        buffer.add(args);
    }

    private static void appendAggregateHyperlinkSegment(FormText formText, AggregateHyperlinkSegment segment, ArrayList buffer) {
        Object[] segments = FormTextLCA.getHyperlinkSegments(segment);
        int i = 0;
        while (i < segments.length) {
            Object hyperlinkSegment = segments[i];
            if (hyperlinkSegment instanceof TextHyperlinkSegment) {
                FormTextLCA.appendTextHyperlinkSegment(formText, (TextHyperlinkSegment)hyperlinkSegment, buffer);
            } else if (hyperlinkSegment instanceof ImageHyperlinkSegment) {
                FormTextLCA.appendImageHyperlinkSegment(formText, (ImageHyperlinkSegment)hyperlinkSegment, buffer);
            }
            ++i;
        }
    }

    private static boolean hasHyperlinkSettingsChanged(FormText formText) {
        HyperlinkSettings newValue = formText.getHyperlinkSettings();
        Integer underlineMode = new Integer(newValue.getHyperlinkUnderlineMode());
        Color foreground = newValue.getForeground();
        Color actForeground = newValue.getActiveForeground();
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_UNDERLINE_MODE, (Object)underlineMode) || WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_FOREGROUND, (Object)foreground) || WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_ACTIVE_FOREGROUND, (Object)actForeground);
    }

    private static Paragraph[] getParagraphs(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.getParagraphs();
    }

    private static boolean hasLayoutChanged(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.hasLayoutChanged();
    }

    private static boolean hasResourceTableChanged(FormText formText) {
        Hashtable resourceTable = FormTextLCA.getResourceTable(formText);
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_RESOURCE_TABLE, (Object)resourceTable);
    }

    private static boolean hasBoundsChanged(FormText formText) {
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_BOUNDS, (Object)formText.getBounds());
    }

    private static IFormTextAdapter getAdapter(FormText formText) {
        Object adapter = formText.getAdapter(IFormTextAdapter.class);
        return (IFormTextAdapter)adapter;
    }

    private static ITextSegmentAdapter getAdapter(TextSegment segment) {
        Object adapter = segment.getAdapter(ITextSegmentAdapter.class);
        return (ITextSegmentAdapter)adapter;
    }

    private static IBulletParagraphAdapter getAdapter(BulletParagraph bullet) {
        Object adapter = bullet.getAdapter(IBulletParagraphAdapter.class);
        return (IBulletParagraphAdapter)adapter;
    }

    private static IAggregateHyperlinkSegmentAdapter getAdapter(AggregateHyperlinkSegment segment) {
        Object adapter = segment.getAdapter(IAggregateHyperlinkSegmentAdapter.class);
        return (IAggregateHyperlinkSegmentAdapter)adapter;
    }

    private static Image getBulletImage(FormText formText, BulletParagraph bullet) {
        Image img;
        String text;
        ClassLoader classLoader = FormTextLCA.class.getClassLoader();
        Image bulletImage = Graphics.getImage((String)BULLET_CIRCLE_GIF, (ClassLoader)classLoader);
        if (bullet.getBulletStyle() == 3 && (text = bullet.getBulletText()) != null && (img = (Image)FormTextLCA.getResourceTable(formText).get(text)) != null) {
            bulletImage = img;
        }
        return bulletImage;
    }

    private static Rectangle getBulletBounds(BulletParagraph bullet) {
        IBulletParagraphAdapter bulletParagraphAdapter = FormTextLCA.getAdapter(bullet);
        return bulletParagraphAdapter.getBulletBounds();
    }

    private static Hashtable getResourceTable(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.getResourceTable();
    }

    private static String[] getTextFragments(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getTextFragments();
    }

    private static Rectangle[] getTextFragmentsBounds(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getTextFragmentsBounds();
    }

    private static String getFontId(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getFontId();
    }

    private static Object[] getHyperlinkSegments(AggregateHyperlinkSegment segment) {
        IAggregateHyperlinkSegmentAdapter hyperlinkSegmentAdapter = FormTextLCA.getAdapter(segment);
        return hyperlinkSegmentAdapter.getHyperlinkSegments();
    }

    private static int[] getBoundsAsArray(Rectangle bounds) {
        return new int[]{bounds.x, bounds.y, bounds.width, bounds.height};
    }

    private static Object[] getFontAsArray(Font font) {
        Object[] result = null;
        if (font != null) {
            result = new Object[]{FormTextLCA.getFontName(font), FormTextLCA.getFontSize(font), FormTextLCA.getFontStyle(font, 1), FormTextLCA.getFontStyle(font, 2)};
        }
        return result;
    }

    private static String[] getFontName(Font font) {
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        String[] result = fontName.split(",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
            result[i] = matcher.replaceAll("");
            ++i;
        }
        return result;
    }

    private static Integer getFontSize(Font font) {
        FontData fontData = font.getFontData()[0];
        return new Integer(fontData.getHeight());
    }

    private static Boolean getFontStyle(Font font, int style) {
        FontData fontData = font.getFontData()[0];
        return (fontData.getStyle() & style) != 0;
    }

    private static int[] getColorAsArray(Color color) {
        int[] result = null;
        if (color != null) {
            RGB rgb = color.getRGB();
            result = new int[]{rgb.red, rgb.green, rgb.blue, 255};
        }
        return result;
    }
}

