/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ButtonTab
extends ExampleTab {
    private static final String BUTTON_IMAGE_PATH = "resources/button-image.gif";
    private Image buttonImage;
    private boolean showImage;
    private boolean setGrayed;
    private Button pushButton;
    private Button toggleButton;
    private Button checkButton1;
    private Button checkButton2;
    private Button radioButton1;
    private Button radioButton2;
    private Button radioButton3;
    private Button defaultButton;

    public ButtonTab() {
        super("Button");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("FLAT", 0x800000);
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("CENTER", 0x1000000);
        this.createStyleButton("RIGHT", 131072);
        this.createStyleButton("UP", 128);
        this.createStyleButton("DOWN", 1024);
        this.createStyleButton("WRAP", 64);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createImageButton(parent);
        this.createGrayedButton(parent);
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createCursorCombo();
        Button button = this.createPropertyButton("Toggle Button", 8);
        button.setToolTipText("Remote control the toggle button");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ButtonTab.this.toggleButton.setSelection(!ButtonTab.this.toggleButton.getSelection());
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = this.getStyle();
        this.pushButton = new Button(parent, style | 8);
        this.pushButton.setText("Push\n Button");
        this.updateButtonImage(this.pushButton);
        this.toggleButton = new Button(parent, style | 2);
        this.toggleButton.setText("Toggle");
        this.checkButton1 = new Button(parent, style | 0x20);
        this.checkButton1.setText("Check");
        this.checkButton2 = new Button(parent, style | 0x20);
        this.checkButton2.setText("Check with image");
        this.createButtonImage(parent.getDisplay());
        this.checkButton2.setImage(this.buttonImage);
        this.radioButton1 = new Button(parent, style | 0x10);
        this.radioButton1.setText("Radio 1");
        this.radioButton2 = new Button(parent, style | 0x10);
        this.radioButton2.setText("Radio 2");
        this.radioButton3 = new Button(parent, style | 0x10);
        this.radioButton3.setText("Radio 3");
        Button arrowButton = new Button(parent, style | 4);
        this.registerControl((Control)this.pushButton);
        this.registerControl((Control)this.toggleButton);
        this.registerControl((Control)this.checkButton1);
        this.registerControl((Control)this.checkButton2);
        this.registerControl((Control)this.radioButton1);
        this.registerControl((Control)this.radioButton2);
        this.registerControl((Control)this.radioButton3);
        this.registerControl((Control)arrowButton);
        final Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText("Default Button");
        group.setLayout((Layout)new RowLayout(256));
        Label label = new Label((Composite)group, 0);
        label.setText("Enter some text and press Return");
        final Text text = new Text((Composite)group, 2052);
        text.setLayoutData((Object)new RowData(100, -1));
        this.defaultButton = new Button((Composite)group, style | 8);
        this.defaultButton.setText("Default Button");
        this.defaultButton.getShell().setDefaultButton(this.defaultButton);
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String message = "The text You entered: " + text.getText();
                MessageDialog.openInformation((Shell)group.getShell(), (String)"Information", (String)message);
            }
        });
        Menu menu = new Menu((Control)parent);
        int i = 0;
        while (i < 5) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText("Item " + (i + 1));
            ++i;
        }
        parent.setMenu(menu);
    }

    private void createButtonImage(Display display) {
        if (this.buttonImage == null) {
            this.buttonImage = Util.loadImage(display, BUTTON_IMAGE_PATH);
        }
    }

    private void createImageButton(Composite parent) {
        final Button imageButton = new Button(parent, 32);
        imageButton.setText("Push Button with Image");
        imageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ButtonTab.this.showImage = imageButton.getSelection();
                ButtonTab.this.updateButtonImage(ButtonTab.this.pushButton);
                ButtonTab.this.pushButton.getParent().layout();
            }
        });
    }

    private void updateButtonImage(Button button) {
        if (this.showImage) {
            this.createButtonImage(button.getDisplay());
            button.setImage(this.buttonImage);
        } else {
            button.setImage(null);
        }
    }

    private void createGrayedButton(Composite parent) {
        final Button grayedButton = new Button(parent, 32);
        grayedButton.setText("Grayed Check Buttons");
        grayedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ButtonTab.this.setGrayed = grayedButton.getSelection();
                ButtonTab.this.updateButtonGrayed();
            }
        });
    }

    private void updateButtonGrayed() {
        for (Button button : this.controls) {
            button.setGrayed(this.setGrayed);
        }
    }
}

