/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private static final int LOGIN_ID = 1025;
    private Text userText;
    private Text passText;
    private Label mesgLabel;
    private final String title;
    private final String message;
    private String username;
    private String password;

    public LoginDialog(Shell parent, String title, String message) {
        super(parent);
        this.title = title;
        this.message = message;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
        shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LoginDialog.this.initializeBounds();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.mesgLabel = new Label(composite, 0);
        GridData messageData = new GridData(4, 0x1000000, true, false);
        messageData.horizontalSpan = 2;
        this.mesgLabel.setLayoutData((Object)messageData);
        Label userLabel = new Label(composite, 0);
        userLabel.setText("Username:");
        this.userText = new Text(composite, 2048);
        this.userText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label passLabel = new Label(composite, 0);
        passLabel.setText("Password:");
        this.passText = new Text(composite, 0x400800);
        this.passText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.initilizeDialogArea();
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        this.createButton(parent, 1025, "Login", true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.username = this.userText.getText();
            this.password = this.passText.getText();
            this.setReturnCode(0);
            this.close();
        } else {
            this.password = null;
        }
        super.buttonPressed(buttonId);
    }

    private void initilizeDialogArea() {
        if (this.message != null) {
            this.mesgLabel.setText(this.message);
        }
        if (this.username != null) {
            this.userText.setText(this.username);
        }
        this.userText.setFocus();
    }
}

