/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class LabelExample
implements IExamplePage {
    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        LabelExample.createTextLabels(parent);
        LabelExample.createAlignedLabels(parent);
        this.createImageLabels(parent);
        this.createCLabels(parent);
        LabelExample.createLinks(parent);
    }

    private static void createTextLabels(Composite parent) {
        Group textGroup = new Group(parent, 0);
        textGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        textGroup.setText("Text Labels");
        textGroup.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        Label simpleLabel = new Label((Composite)textGroup, 0);
        simpleLabel.setText("A simple text label.");
        Label wrappedLabel = new Label((Composite)textGroup, 2112);
        wrappedLabel.setText("A fixed width label with a long text that wraps. A long text that wraps. A long text that wraps. A long text that wraps.");
        GridData wrappedData = new GridData(200, -1);
        wrappedData.verticalSpan = 2;
        wrappedLabel.setLayoutData((Object)wrappedData);
        Label borderLabel = new Label((Composite)textGroup, 2048);
        borderLabel.setText("A label with a border.");
    }

    private static void createAlignedLabels(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setText("Alignment");
        group.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        Label leftLabel = new Label((Composite)group, 18432);
        leftLabel.setText("These lines\nare\nleft-aligned");
        leftLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        Label centerLabel = new Label((Composite)group, 0x1000800);
        centerLabel.setText("These lines\nare\ncentered");
        centerLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        Label rightLabel = new Label((Composite)group, 133120);
        rightLabel.setText("These lines\nare\nright-aligned");
        rightLabel.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private void createImageLabels(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Image Labels");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        Composite comp = new Composite((Composite)group, 0);
        comp.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        comp.setLayout((Layout)ExampleUtil.createGridLayout((int)5, (boolean)false, (boolean)true, (boolean)true));
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image image1 = Graphics.getImage((String)"resources/emblem-system.png", (ClassLoader)classLoader);
        Image image2 = Graphics.getImage((String)"resources/go-bottom.png", (ClassLoader)classLoader);
        Image image3 = Graphics.getImage((String)"resources/system-search.png", (ClassLoader)classLoader);
        Label imageLabel1 = new Label(comp, 0);
        imageLabel1.setImage(image1);
        new Label(comp, 514);
        Label imageLabel2 = new Label(comp, 0);
        imageLabel2.setImage(image2);
        new Label(comp, 514);
        Label imageLabel3 = new Label(comp, 0);
        imageLabel3.setImage(image3);
    }

    private void createCLabels(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("CLabel");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)ExampleUtil.createGridLayout((int)3, (boolean)false, (boolean)true, (boolean)true));
        ClassLoader classLoader = this.getClass().getClassLoader();
        Image image4 = Graphics.getImage((String)"resources/button-image.gif", (ClassLoader)classLoader);
        CLabel cLabel1 = new CLabel((Composite)group, 0);
        cLabel1.setText("Image and text");
        cLabel1.setImage(image4);
        cLabel1.setAlignment(0x1000000);
        cLabel1.setLayoutData((Object)new GridData(4, 128, true, false));
        CLabel cLabel2 = new CLabel((Composite)group, 4);
        cLabel2.setText("Shadow-in style");
        cLabel2.setImage(image4);
        cLabel2.setAlignment(0x1000000);
        cLabel2.setLayoutData((Object)new GridData(4, 128, true, false));
        CLabel cLabel3 = new CLabel((Composite)group, 8);
        cLabel3.setText("Shadow-out style");
        cLabel3.setImage(image4);
        cLabel3.setAlignment(0x1000000);
        cLabel3.setLayoutData((Object)new GridData(4, 128, true, false));
    }

    private static void createLinks(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Links");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        Link link = new Link((Composite)group, 0);
        link.setText("A link widget with <a>two</a> embedded <a>hyperlinks</a>");
        final Label linkLabel = new Label((Composite)group, 0);
        linkLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                linkLabel.setText("clicked \"" + e.text + "\"");
            }
        });
    }
}

