/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class TextInputExamplePage
implements IExamplePage {
    protected Image errorImage;
    protected Image warningImage;

    public void createControl(Composite parent) {
        this.createImages();
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)2));
        Composite leftComp = this.createPart(parent);
        Composite rightComp = this.createPart(parent);
        this.createInputForm(leftComp);
        this.createControlDecoratorsForm(rightComp);
        this.createMultiline(rightComp);
    }

    private void createImages() {
        this.errorImage = TextInputExamplePage.getDecorationImage("DEC_ERROR");
        this.warningImage = TextInputExamplePage.getDecorationImage("DEC_WARNING");
    }

    private Composite createPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)ExampleUtil.createGridLayoutWithoutMargin((int)1, (boolean)false));
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        return composite;
    }

    private void createInputForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"Simple Input Widgets", (int)2);
        final Text firstNameText = this.createFirstNameField(composite);
        final Text lastNameText = this.createLastNameField(composite);
        final Text passwordText = this.createPasswordField(composite);
        final Spinner spinner = this.createSpinner(composite);
        final Combo countryCombo = this.createCountryCombo(composite);
        final Combo classCombo = this.createReadOnlyCombo(composite);
        final DateTime dateTime = this.createDateField(composite);
        final Button enabledCheckbox = new Button(composite, 32);
        enabledCheckbox.setText("Enabled");
        enabledCheckbox.setSelection(true);
        enabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editable = enabledCheckbox.getSelection();
                firstNameText.setEnabled(editable);
                lastNameText.setEnabled(editable);
                passwordText.setEnabled(editable);
                spinner.setEnabled(editable);
                countryCombo.setEnabled(editable);
                classCombo.setEnabled(editable);
                dateTime.setEnabled(editable);
            }
        });
    }

    private void createControlDecoratorsForm(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createHorzFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)2, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"Input validation with visual feedback", (int)2);
        this.createVerifiedText(composite);
        this.createMandatoryText(composite);
    }

    private void createVerifiedText(Composite formComp) {
        new Label(formComp, 0).setText("Digits Only:");
        final Text text = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        text.setLayoutData((Object)gridData1);
        final ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        decoration.setImage(this.errorImage);
        text.setText("4711 abcd");
        text.setBackground(new Color((Device)text.getDisplay(), 250, 200, 150));
        decoration.setDescriptionText("validation failed: only numbers allowed for this textfield");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String content = text.getText();
                if (!TextInputExamplePage.isNumbers(content)) {
                    decoration.setDescriptionText("validation failed: only numbers allowed for this textfield");
                    text.setBackground(new Color((Device)text.getDisplay(), 250, 200, 150));
                    decoration.show();
                } else {
                    text.setBackground(null);
                    decoration.hide();
                }
            }
        });
    }

    private void createMandatoryText(Composite formComp) {
        new Label(formComp, 0).setText("Mandatory:");
        final Text text = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        text.setLayoutData((Object)gridData1);
        final ControlDecoration decoration = new ControlDecoration((Control)text, 16512);
        decoration.setImage(this.warningImage);
        decoration.setDescriptionText("this field cannot be empty. Please enter mandatory content.");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String content = text.getText();
                if (content.trim().length() == 0) {
                    decoration.show();
                    decoration.setDescriptionText("this field cannot be empty. Please enter mandatory content.");
                } else {
                    text.setBackground(null);
                    decoration.hide();
                }
            }
        });
    }

    private Text createFirstNameField(Composite formComp) {
        new Label(formComp, 0).setText("First Name:");
        Text firstNameText = new Text(formComp, 2052);
        GridData gridData1 = ExampleUtil.createHorzFillData();
        gridData1.minimumWidth = 250;
        firstNameText.setLayoutData((Object)gridData1);
        return firstNameText;
    }

    private Text createLastNameField(Composite formComp) {
        new Label(formComp, 0).setText("Last Name:");
        Text lastNameText = new Text(formComp, 2052);
        GridData gridData2 = ExampleUtil.createHorzFillData();
        lastNameText.setLayoutData((Object)gridData2);
        return lastNameText;
    }

    private Text createPasswordField(Composite formComp) {
        new Label(formComp, 0).setText("Passphrase:");
        Text passwordText = new Text(formComp, 0x400800);
        GridData gridData3 = ExampleUtil.createHorzFillData();
        passwordText.setLayoutData((Object)gridData3);
        passwordText.setText("Password");
        return passwordText;
    }

    private Spinner createSpinner(Composite formComp) {
        new Label(formComp, 0).setText("Age:");
        Spinner spinner = new Spinner(formComp, 2048);
        GridData gridData4 = ExampleUtil.createHorzFillData();
        spinner.setLayoutData((Object)gridData4);
        spinner.setSelection(23);
        return spinner;
    }

    private Combo createCountryCombo(Composite formComp) {
        new Label(formComp, 0).setText("Country:");
        Combo combo = new Combo(formComp, 2048);
        String[] countries = new String[]{"Germany", "Canada", "USA", "Bulgaria"};
        combo.setItems(countries);
        GridData gridData = ExampleUtil.createHorzFillData();
        combo.setLayoutData((Object)gridData);
        combo.select(0);
        return combo;
    }

    private Combo createReadOnlyCombo(Composite formComp) {
        new Label(formComp, 0).setText("Class:");
        Combo classCombo = new Combo(formComp, 2056);
        String[] classes = new String[]{"Business", "Economy", "Economy Plus"};
        classCombo.setItems(classes);
        GridData gridData = ExampleUtil.createHorzFillData();
        classCombo.setLayoutData((Object)gridData);
        classCombo.select(0);
        return classCombo;
    }

    private DateTime createDateField(Composite formComp) {
        new Label(formComp, 0).setText("Date:");
        int dateTimeStyle = 2056;
        DateTime dateTime = new DateTime(formComp, dateTimeStyle);
        return dateTime;
    }

    private void createMultiline(Composite parent) {
        Composite multiComp = new Composite(parent, 0);
        ExampleUtil.createHeading((Composite)multiComp, (String)"Multiline Texts", (int)2);
        multiComp.setLayoutData((Object)ExampleUtil.createHorzFillData());
        multiComp.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        String text = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. ";
        text = String.valueOf(text) + text;
        new Label(multiComp, 0).setText("This text box wraps:");
        int wrapStyle = 2626;
        Text wrapText = new Text(multiComp, wrapStyle);
        wrapText.setText(text);
        GridData wrapTextData = ExampleUtil.createFillData();
        wrapTextData.minimumHeight = 70;
        wrapText.setLayoutData((Object)wrapTextData);
        new Label(multiComp, 0).setText("And this one doesn't:");
        int nowrapStyle = 2818;
        Text nowrapText = new Text(multiComp, nowrapStyle);
        nowrapText.setText(text);
        GridData nowrapData = ExampleUtil.createFillData();
        nowrapData.minimumHeight = 70;
        nowrapText.setLayoutData((Object)nowrapData);
    }

    private static boolean isNumbers(String content) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            char ch = content.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static Image getDecorationImage(String id) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        FieldDecoration decoration = registry.getFieldDecoration(id);
        return decoration.getImage();
    }
}

