/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.internal.application.ApplicationContextActivator;
import org.eclipse.rap.rwt.internal.application.ApplicationImpl;
import org.eclipse.rap.rwt.internal.client.ClientSelector;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleAdapterFactory;
import org.eclipse.rap.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rap.rwt.internal.resources.ResourceDirectory;
import org.eclipse.rap.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rap.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rap.rwt.internal.serverpush.ServerPushServiceHandler;
import org.eclipse.rap.rwt.internal.service.ApplicationStoreImpl;
import org.eclipse.rap.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rap.rwt.internal.service.ServiceManagerImpl;
import org.eclipse.rap.rwt.internal.service.SettingStoreManager;
import org.eclipse.rap.rwt.internal.service.StartupPage;
import org.eclipse.rap.rwt.internal.textsize.MeasurementListener;
import org.eclipse.rap.rwt.internal.textsize.ProbeStore;
import org.eclipse.rap.rwt.internal.textsize.TextSizeStorage;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.FileSettingStoreFactory;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.internal.graphics.FontDataFactory;
import org.eclipse.swt.internal.graphics.ImageDataFactory;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.graphics.InternalImageFactory;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.DisplaysHolder;

public class ApplicationContextImpl
implements ApplicationContext {
    public static ResourceManager testResourceManager;
    private ThemeManager themeManager;
    private final ApplicationConfiguration applicationConfiguration;
    private final ResourceDirectory resourceDirectory;
    private final ResourceManagerImpl resourceManager;
    private final PhaseListenerRegistry phaseListenerRegistry;
    private final LifeCycleFactory lifeCycleFactory;
    private final EntryPointManager entryPointManager;
    private final LifeCycleAdapterFactory lifeCycleAdapterFactory;
    private final SettingStoreManager settingStoreManager;
    private final ServiceManagerImpl serviceManager;
    private final ResourceRegistry resourceRegistry;
    private final ApplicationStoreImpl applicationStore;
    private final ResourceFactory resourceFactory;
    private final ImageFactory imageFactory;
    private final InternalImageFactory internalImageFactory;
    private final ImageDataFactory imageDataFactory;
    private final FontDataFactory fontDataFactory;
    private final StartupPage startupPage;
    private final DisplaysHolder displaysHolder;
    private final TextSizeStorage textSizeStorage;
    private final ProbeStore probeStore;
    private final ServletContext servletContext;
    private final ApplicationContextActivator contextActivator;
    private final ClientSelector clientSelector;
    private boolean active;

    public ApplicationContextImpl(ApplicationConfiguration applicationConfiguration, ServletContext servletContext) {
        this.applicationConfiguration = applicationConfiguration;
        this.servletContext = servletContext;
        this.applicationStore = new ApplicationStoreImpl();
        this.resourceDirectory = new ResourceDirectory();
        this.resourceManager = new ResourceManagerImpl(this.resourceDirectory);
        this.phaseListenerRegistry = new PhaseListenerRegistry();
        this.entryPointManager = new EntryPointManager();
        this.lifeCycleFactory = new LifeCycleFactory(this);
        this.themeManager = new ThemeManager();
        this.resourceFactory = new ResourceFactory();
        this.imageFactory = new ImageFactory();
        this.internalImageFactory = new InternalImageFactory();
        this.imageDataFactory = new ImageDataFactory(this.resourceManager);
        this.fontDataFactory = new FontDataFactory();
        this.lifeCycleAdapterFactory = new LifeCycleAdapterFactory();
        this.settingStoreManager = new SettingStoreManager();
        this.resourceRegistry = new ResourceRegistry(this.getResourceManager());
        this.startupPage = new StartupPage(this);
        this.serviceManager = this.createServiceManager();
        this.displaysHolder = new DisplaysHolder();
        this.textSizeStorage = new TextSizeStorage();
        this.probeStore = new ProbeStore(this.textSizeStorage);
        this.contextActivator = new ApplicationContextActivator(this);
        this.clientSelector = new ClientSelector();
    }

    public void setAttribute(String name, Object value) {
        this.applicationStore.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.applicationStore.getAttribute(name);
    }

    public void removeAttribute(String name) {
        this.applicationStore.removeAttribute(name);
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.checkIsActivated();
        this.active = true;
        try {
            this.doActivate();
        }
        catch (RuntimeException rte) {
            this.active = false;
            throw rte;
        }
    }

    public void deactivate() {
        this.checkIsNotActivated();
        try {
            this.doDeactivate();
        }
        finally {
            this.active = false;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ResourceDirectory getResourceDirectory() {
        return this.resourceDirectory;
    }

    public ResourceManager getResourceManager() {
        return testResourceManager != null ? testResourceManager : this.resourceManager;
    }

    public EntryPointManager getEntryPointManager() {
        return this.entryPointManager;
    }

    public SettingStoreManager getSettingStoreManager() {
        return this.settingStoreManager;
    }

    public PhaseListenerRegistry getPhaseListenerRegistry() {
        return this.phaseListenerRegistry;
    }

    public LifeCycleAdapterFactory getLifeCycleAdapterFactory() {
        return this.lifeCycleAdapterFactory;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    public ServiceManagerImpl getServiceManager() {
        return this.serviceManager;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public LifeCycleFactory getLifeCycleFactory() {
        return this.lifeCycleFactory;
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public InternalImageFactory getInternalImageFactory() {
        return this.internalImageFactory;
    }

    public ImageDataFactory getImageDataFactory() {
        return this.imageDataFactory;
    }

    public FontDataFactory getFontDataFactory() {
        return this.fontDataFactory;
    }

    public StartupPage getStartupPage() {
        return this.startupPage;
    }

    public DisplaysHolder getDisplaysHolder() {
        return this.displaysHolder;
    }

    public TextSizeStorage getTextSizeStorage() {
        return this.textSizeStorage;
    }

    public ProbeStore getProbeStore() {
        return this.probeStore;
    }

    public ClientSelector getClientSelector() {
        return this.clientSelector;
    }

    private void checkIsNotActivated() {
        if (!this.active) {
            throw new IllegalStateException("The ApplicationContext has not been activated.");
        }
    }

    private void checkIsActivated() {
        if (this.active) {
            throw new IllegalStateException("The ApplicationContext has already been activated.");
        }
    }

    private void doActivate() {
        this.themeManager.initialize();
        this.applicationConfiguration.configure(new ApplicationImpl(this, this.applicationConfiguration));
        this.resourceDirectory.configure(this.getContextDirectory());
        this.addInternalPhaseListeners();
        this.addInternalServiceHandlers();
        this.setInternalSettingStoreFactory();
        this.contextActivator.activate();
    }

    private void doDeactivate() {
        this.contextActivator.deactivate();
        this.entryPointManager.deregisterAll();
        this.phaseListenerRegistry.removeAll();
        this.resourceRegistry.clear();
        this.settingStoreManager.deregisterFactory();
        this.resourceDirectory.reset();
        this.applicationStore.reset();
    }

    private ServiceManagerImpl createServiceManager() {
        return new ServiceManagerImpl(new LifeCycleServiceHandler(this.lifeCycleFactory, this.startupPage));
    }

    private String getContextDirectory() {
        String location = (String)this.servletContext.getAttribute("resource_root_location");
        if (location == null) {
            location = this.servletContext.getRealPath("/");
        }
        return location;
    }

    private void addInternalPhaseListeners() {
        this.phaseListenerRegistry.add(new MeasurementListener());
    }

    private void addInternalServiceHandlers() {
        this.serviceManager.registerServiceHandler("org.eclipse.rap.serverpush", new ServerPushServiceHandler());
    }

    private void setInternalSettingStoreFactory() {
        if (!this.settingStoreManager.hasFactory()) {
            this.settingStoreManager.register(new FileSettingStoreFactory());
        }
    }
}

