/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.engine;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.rap.rwt.service.UISession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostDeserialization {
    private static final String PROCESSORS = String.valueOf(PostDeserialization.class.getName()) + "#processors";
    private static final Runnable[] EMPTY_PROCESSORS = new Runnable[0];

    public static void runProcessors(UISession uiSession) {
        Runnable[] processors = PostDeserialization.getProcessors(uiSession);
        PostDeserialization.clearProcessors(uiSession);
        Runnable[] runnableArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable processor = runnableArray[n2];
            processor.run();
            ++n2;
        }
    }

    public static void addProcessor(UISession uiSession, Runnable processor) {
        List<Runnable> processorsList = PostDeserialization.getProcessorsList(uiSession);
        processorsList.add(processor);
    }

    private static Runnable[] getProcessors(UISession uiSession) {
        Runnable[] result = EMPTY_PROCESSORS;
        List list = (List)uiSession.getAttribute(PROCESSORS);
        if (list != null) {
            result = list.toArray(new Runnable[list.size()]);
        }
        return result;
    }

    private static List<Runnable> getProcessorsList(UISession uiSession) {
        LinkedList result = (LinkedList)uiSession.getAttribute(PROCESSORS);
        if (result == null) {
            result = new LinkedList();
            uiSession.setAttribute(PROCESSORS, result);
        }
        return result;
    }

    private static void clearProcessors(UISession uiSession) {
        uiSession.removeAttribute(PROCESSORS);
    }

    private PostDeserialization() {
    }
}

